/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.neqlize;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.baja.sys.BComponent;
import javax.baja.tag.Tag;
import javax.baja.util.PatternFilter;

public final class FilteredTagsMap {
    private static final Pattern EXCLUSION_STRING_SPLIT = Pattern.compile("\\s*(\\s|;|,)\\s*");
    private static final boolean ARE_TAG_EXCLUSIONS = true;
    private final List<PatternFilter> excludeFilters;
    private final Map<BComponent, List<Tag>> filteredTagMap;

    public FilteredTagsMap(Set<String> excludeFilters) {
        this.excludeFilters = new ArrayList<PatternFilter>(excludeFilters.size());
        for (String excludeFilter : excludeFilters) {
            this.excludeFilters.add(new PatternFilter(excludeFilter));
        }
        this.filteredTagMap = new ConcurrentHashMap<BComponent, List<Tag>>();
    }

    public List<Tag> getFilteredTags(BComponent component) {
        List<Tag> filteredTags = this.filteredTagMap.get(component);
        if (filteredTags == null) {
            filteredTags = new ArrayList<Tag>(component.tags().filter(t -> !this.matchesExcludedFilter(t.getId().getQName())));
            this.filteredTagMap.put(component, filteredTags);
        }
        return filteredTags;
    }

    public boolean matchesExcludedFilter(String id) {
        for (PatternFilter filter : this.excludeFilters) {
            if (!filter.accept(id)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getTagExclusions(String exclusionString) {
        return FilteredTagsMap.getExclusions(exclusionString, true);
    }

    public static Set<String> getRelationExclusions(String exclusionString) {
        return FilteredTagsMap.getExclusions(exclusionString, false);
    }

    private static Set<String> getExclusions(String exclusionString, boolean areTagExclusions) {
        if (exclusionString.trim().isEmpty()) {
            return new HashSet<String>();
        }
        String[] exclusions = EXCLUSION_STRING_SPLIT.split(exclusionString.trim());
        if (exclusions.length == 0) {
            return new HashSet<String>();
        }
        HashSet<String> exclusionSet = new HashSet<String>(exclusions.length);
        for (String entry : exclusions) {
            if (areTagExclusions) {
                if (!FilteredTagsMap.isValidTagPattern(entry)) continue;
                exclusionSet.add(entry);
                continue;
            }
            if (!FilteredTagsMap.isValidRelationPattern(entry)) continue;
            exclusionSet.add(entry);
        }
        return exclusionSet;
    }

    public static boolean isValidTagPattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return false;
        }
        if (pattern.contains(":")) {
            return pattern.split(":").length == 2;
        }
        return pattern.contains("*");
    }

    public static boolean isValidRelationPattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return false;
        }
        if (pattern.contains("->") && !pattern.endsWith("->")) {
            return false;
        }
        if (pattern.contains("<-") && !pattern.endsWith("<-")) {
            return false;
        }
        if (pattern.contains(":")) {
            return pattern.split(":").length == 2;
        }
        return pattern.contains("*");
    }
}

