/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.condition;

import com.tridium.neql.NamespaceContext;
import java.util.function.Predicate;
import javax.baja.neql.NeqlEntityEvaluator;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagRuleCondition;

@NiagaraType
@NiagaraProperty(name="filter", type="String", defaultValue="\"false\"")
public class BBooleanFilter
extends BTagRuleCondition {
    public static final Property filter = BBooleanFilter.newProperty((int)0, (String)"false", null);
    public static final Type TYPE = Sys.loadType(BBooleanFilter.class);
    private static final String DEFAULT_NAMESPACE_ID_NAME = BTagDictionaryService.defaultNamespaceId.getName();
    private Predicate<Entity> predicate;
    private TagDictionaryServiceSubscriber subscriber;

    public String getFilter() {
        return this.getString(filter);
    }

    public void setFilter(String v) {
        this.setString(filter, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BBooleanFilter() {
    }

    public BBooleanFilter(String filter) {
        this.setFilter(filter);
    }

    @Override
    public boolean test(Entity entity) {
        Predicate<Entity> predicate = this.getFilterPredicate();
        return this.test(predicate, entity);
    }

    @Override
    public boolean testIdealMatch(Type type) {
        return true;
    }

    protected boolean test(Predicate<Entity> predicate, Entity entity) {
        return predicate.test(entity);
    }

    public void started() throws Exception {
        BComponent service = Sys.getService((Type)BTagDictionaryService.TYPE);
        if (service != null) {
            this.subscriber = new TagDictionaryServiceSubscriber();
            this.subscriber.subscribe(service);
        }
        super.started();
    }

    public void stopped() throws Exception {
        if (this.subscriber != null) {
            this.subscriber.unsubscribeAll();
        }
        super.stopped();
    }

    public void changed(Property prop, Context cx) {
        if (cx == Context.decoding) {
            return;
        }
        if (prop.equals(filter)) {
            this.predicate = null;
        }
    }

    private Predicate<Entity> getFilterPredicate() {
        if (this.predicate == null) {
            if (!this.isRunning()) {
                return this.makePredicate();
            }
            this.predicate = this.makePredicate();
        }
        return this.predicate;
    }

    private Predicate<Entity> makePredicate() {
        TagDictionaryService service = this.getTagDictionaryService();
        NamespaceContext cx = service != null ? new NamespaceContext(service.getDefaultNamespace(), (Context)new BasicContext()) : null;
        return NeqlEntityEvaluator.makePredicate((String)this.getFilter(), (Context)cx);
    }

    private class TagDictionaryServiceSubscriber
    extends Subscriber {
        private TagDictionaryServiceSubscriber() {
        }

        public void event(BComponentEvent event) {
            if (event.getId() == 0 && event.getSlotName().equals(DEFAULT_NAMESPACE_ID_NAME)) {
                BBooleanFilter.this.predicate = null;
            }
        }
    }
}

