/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.file.types.bog.BBogSpace;
import com.tridium.tagdictionary.tag.BHasPxViewTag;
import com.tridium.tagdictionary.util.ImportUtil;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagRule;
import javax.baja.tagdictionary.TagRule;
import javax.baja.user.BUser;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="namespace", type="String", defaultValue="n", flags=1, override=true), @NiagaraProperty(name="neqlizeExcludedTags", type="String", defaultValue="BNiagaraTagDictionary.DEFAULT_EXCLUDE_TAGS", override=true, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}, flags=1), @NiagaraProperty(name="neqlizeExcludedRelations", type="String", defaultValue="BNiagaraTagDictionary.DEFAULT_EXCLUDE_RELATIONS", override=true, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}, flags=1), @NiagaraProperty(name="frozen", type="boolean", defaultValue="true", flags=1, override=true)})
@NiagaraAction(name="importDictionary", flags=20)
public class BNiagaraTagDictionary
extends BSmartTagDictionary {
    public static final Property namespace = BNiagaraTagDictionary.newProperty((int)1, (String)"n", null);
    public static final Property neqlizeExcludedTags = BNiagaraTagDictionary.newProperty((int)1, (String)"n:bindHints, n:displayName, n:geo*,\nn:hasPxView, n:history, n:name, n:node,\nn:ordInSession, n:station,\nn:targetSlotHint, n:type, n:vendor,\nn:version", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property neqlizeExcludedRelations = BNiagaraTagDictionary.newProperty((int)1, (String)"n:child, n:parent, n:tagGroup", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property frozen = BNiagaraTagDictionary.newProperty((int)1, (boolean)true, null);
    public static final Action importDictionary = BNiagaraTagDictionary.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BNiagaraTagDictionary.class);
    public static final String CONNECT_TYPE_FOXS = "foxs";
    public static final String NIAGARA_DICT = "n";
    public static final Id ADDRESS = Id.newId((String)"n", (String)"address");
    public static final Id BIND_HINTS = Id.newId((String)"n", (String)"bindHints");
    public static final Id CREDENTIALS = Id.newId((String)"n", (String)"credentials");
    public static final Id CONNECTION_TYPE = Id.newId((String)"n", (String)"connectionType");
    public static final Id DEVICE = Id.newId((String)"n", (String)"device");
    public static final Id DISPLAY_NAME = Id.newId((String)"n", (String)"displayName");
    public static final Id DESCRIPTION = Id.newId((String)"n", (String)"description");
    public static final Id GEO_ADDR = Id.newId((String)"n", (String)"geoAddr");
    public static final Id GEO_CITY = Id.newId((String)"n", (String)"geoCity");
    public static final Id GEO_COORD = Id.newId((String)"n", (String)"geoCoord");
    public static final Id GEO_COUNTRY = Id.newId((String)"n", (String)"geoCountry");
    public static final Id GEO_COUNTY = Id.newId((String)"n", (String)"geoCounty");
    public static final Id GEO_POSTAL_CODE = Id.newId((String)"n", (String)"geoPostalCode");
    public static final Id GEO_STATE = Id.newId((String)"n", (String)"geoState");
    public static final Id GEO_STREET = Id.newId((String)"n", (String)"geoStreet");
    public static final Id HISTORY = Id.newId((String)"n", (String)"history");
    public static final Id HAS_PX_VIEW = Id.newId((String)"n", (String)"hasPxView");
    public static final Id ID = Id.newId((String)"n", (String)"id");
    public static final Id INPUT = Id.newId((String)"n", (String)"input");
    public static final Id NAME = Id.newId((String)"n", (String)"name");
    public static final Id NETWORK = Id.newId((String)"n", (String)"network");
    public static final Id NODE = Id.newId((String)"n", (String)"node");
    public static final Id NODE_PATH = Id.newId((String)"n", (String)"nodePath");
    public static final Id NODE_STATE = Id.newId((String)"n", (String)"nodeState");
    public static final Id ORD_IN_SESSION = Id.newId((String)"n", (String)"ordInSession");
    public static final Id OUTPUT = Id.newId((String)"n", (String)"output");
    public static final Id POINT = Id.newId((String)"n", (String)"point");
    public static final Id PORT = Id.newId((String)"n", (String)"port");
    public static final Id SCHEDULE = Id.newId((String)"n", (String)"schedule");
    public static final Id STATION = Id.newId((String)"n", (String)"station");
    public static final Id USER_TIP = Id.newId((String)"n", (String)"userTip");
    public static final Id TARGET_SLOT_HINT = Id.newId((String)"n", (String)"targetSlotHint");
    public static final Id TEMPLATE = Id.newId((String)"n", (String)"template");
    public static final Id TYPE_ID = Id.newId((String)"n", (String)"type");
    public static final Id UUID = Id.newId((String)"n", (String)"uuid");
    public static final Id VENDOR = Id.newId((String)"n", (String)"vendor");
    public static final Id VERSION = Id.newId((String)"n", (String)"version");
    public static final Id CHILD = Id.newId((String)"n", (String)"child");
    public static final Id PARENT = Id.newId((String)"n", (String)"parent");
    public static final Id CHILD_POINT = Id.newId((String)"n", (String)"childPoint");
    public static final Id CHILD_NULL_PROXY_POINT = Id.newId((String)"n", (String)"childNullProxyPoint");
    public static final Id PARENT_DEVICE = Id.newId((String)"n", (String)"parentDevice");
    public static final Id CHILD_DEVICE = Id.newId((String)"n", (String)"childDevice");
    public static final Id PARENT_NETWORK = Id.newId((String)"n", (String)"parentNetwork");
    public static final Id TAG_GROUP_RELATION = Id.newId((String)"n", (String)"tagGroup");
    public static final String TAG_GROUP_FACET = "tg__";
    public static final String DEFAULT_EXCLUDE_TAGS = "n:bindHints, n:displayName, n:geo*,\nn:hasPxView, n:history, n:name, n:node,\nn:ordInSession, n:station,\nn:targetSlotHint, n:type, n:vendor,\nn:version";
    public static final String DEFAULT_EXCLUDE_RELATIONS = "n:child, n:parent, n:tagGroup";

    public void importDictionary() {
        this.invoke(importDictionary, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.importFromBog(null);
    }

    @Override
    public String toString(Context context) {
        String name = this.getName();
        if (name != null) {
            return lex.getText("tag.dictionary.shortName", new Object[]{name});
        }
        return super.toString(context);
    }

    @Override
    public BValue getActionParameterDefault(Action action) {
        if (action.equals(importDictionary)) {
            return action.getParameterDefault();
        }
        return super.getActionParameterDefault(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BTagDictionary getStandardDictionary() {
        BBogFile bogFile = null;
        try {
            String moduleName = this.getType().getModule().getModuleName();
            bogFile = (BBogFile)BOrd.make((String)("module://" + moduleName + "/bog/Niagara.bog")).resolve().get();
            bogFile.open();
            BSmartTagDictionary std = BNiagaraTagDictionary.getStandardDictionary(bogFile);
            std.lease(Integer.MAX_VALUE);
            BSmartTagDictionary bSmartTagDictionary = std;
            return bSmartTagDictionary;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (bogFile != null && bogFile.isOpen()) {
                bogFile.close();
            }
        }
        return null;
    }

    public IFuture post(Action action, BValue argument, Context context) {
        Invocation i = new Invocation((BComponent)this, action, argument, context);
        new Thread((Runnable)i, "Niagara Dictionary Import").start();
        return null;
    }

    public void doImportDictionary(Context context) {
        if (this.getTagDefinitions().getSlotCount() != 0) {
            if (context == null) {
                return;
            }
            BUser user = context.getUser();
            if (user == null) {
                return;
            }
            if (!user.getPermissionsFor((BIProtected)this).hasAdminWrite()) {
                return;
            }
        }
        this.importFromBog(importContext);
    }

    public void importFromBog(Context context) {
        try {
            BSmartTagDictionary std = (BSmartTagDictionary)this.getStandardDictionary();
            std.lease(Integer.MAX_VALUE);
            if (ImportUtil.equivalent(this, std)) {
                logger.fine(() -> this.getName() + " tagdictionary is up to date.");
                return;
            }
            logger.info(this.getName() + " tagdictionary is out of date or has been modified.");
            this.setFlags((Slot)frozen, this.getFlags((Slot)frozen) | 1);
            this.setFrozen(true);
            boolean includePxFromRegistry = false;
            BHasPxViewTag oldHasPxViewTag = this.getHasPxView();
            if (oldHasPxViewTag != null) {
                includePxFromRegistry = oldHasPxViewTag.getIncludePxFromRegistry();
            }
            ArrayList<ImportUtil.DataPolicyInfo> savedDataPolicies = ImportUtil.saveDataPolicyInfo(this, new ArrayList<ImportUtil.DataPolicyInfo>());
            this.getTagDefinitions().removeAll(context);
            SlotCursor c = std.getTagDefinitions().getProperties();
            while (c.next(TagInfo.class)) {
                BComponent tag = (BComponent)c.get();
                this.getTagDefinitions().add(tag.getName(), tag.newCopy(true), context);
            }
            this.getTagGroupDefinitions().removeAll(context);
            c = std.getTagGroupDefinitions().getProperties();
            while (c.next(TagGroupInfo.class)) {
                BComponent tagGroup = (BComponent)c.get();
                this.getTagGroupDefinitions().add(tagGroup.getName(), tagGroup.newCopy(true), context);
            }
            this.getRelationDefinitions().removeAll(context);
            c = std.getRelationDefinitions().getProperties();
            while (c.next(RelationInfo.class)) {
                BComponent relation = (BComponent)c.get();
                this.getRelationDefinitions().add(relation.getName(), relation.newCopy(true), context);
            }
            this.getTagRules().removeAll(context);
            c = std.getTagRules().getProperties();
            while (c.next(TagRule.class)) {
                BComponent tagRule = (BComponent)c.get();
                this.getTagRules().add(tagRule.getName(), tagRule.newCopy(true), context);
            }
            logger.info(this.getName() + " tagdictionary has been reloaded.");
            ImportUtil.restoreDataPolicies(savedDataPolicies, this);
            BHasPxViewTag newHasPxViewTag = this.getHasPxView();
            if (newHasPxViewTag != null) {
                newHasPxViewTag.setIncludePxFromRegistry(includePxFromRegistry);
            } else {
                logger.info("hasPxViewTag not found after importing the Niagara Tag Dictionary");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private BHasPxViewTag getHasPxView() {
        BTagRule objectTags = (BTagRule)this.getTagRules().get("object$20tags");
        if (objectTags == null) {
            logger.fine("object tags tag rule not found during Niagara Tag Dictionary import");
            return null;
        }
        return (BHasPxViewTag)objectTags.getTagList().get("hasPxView");
    }

    private static BSmartTagDictionary getStandardDictionary(BBogFile bogFile) {
        BBogSpace bogSpace = bogFile.getBogSpace();
        BComponent root = bogSpace.getRootComponent();
        SlotCursor c = root.getProperties();
        if (c.next(BSmartTagDictionary.class)) {
            return (BSmartTagDictionary)c.get();
        }
        return null;
    }
}

