/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.ui;

import com.tridium.ndriver.discover.BINDiscoveryGroup;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.workbench.propsheet.BPropertySheetFE;
import java.util.Stack;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

public class NMgrColumnUtil {
    public static void getColumnsFor(BComplex c, Array<MgrColumn> mgrColumns) {
        Stack<Property> cols = new Stack<Property>();
        if (c instanceof BProxyExt) {
            cols.add(BControlPoint.proxyExt);
        }
        NMgrColumnUtil.recurse(c, mgrColumns, cols);
    }

    private static void recurse(BComplex c, Array<MgrColumn> mgrColumns, Stack<Property> cols) {
        Property[] pa = c.getPropertiesArray();
        for (int i = 0; i < pa.length; ++i) {
            Property prop = pa[i];
            if (!SfUtil.isMgrInclude((Property)prop)) continue;
            BValue typ = c.get(prop);
            cols.push(prop);
            if (typ instanceof BSimple || typ instanceof BStruct && NMgrColumnUtil.hasCustomFE(prop)) {
                int fl = SfUtil.getMgrColumnFlags((Property)prop);
                Property[] path = cols.toArray(new Property[0]);
                mgrColumns.add((Object)new NMgrPropPath(path, fl));
            } else if (typ instanceof BComplex) {
                NMgrColumnUtil.recurse((BComplex)typ, mgrColumns, cols);
            }
            cols.pop();
        }
    }

    private static boolean hasCustomFE(Property p) {
        BWbFieldEditor fe = BWbFieldEditor.makeFor((BObject)p.getDefaultValue());
        return !fe.getType().is(BPropertySheetFE.TYPE);
    }

    static String toDotNotation(Property[] propPath) {
        String dotNotation = "";
        for (int i = 0; i < propPath.length; ++i) {
            if (dotNotation.length() > 0) {
                dotNotation = dotNotation + ".";
            }
            dotNotation = dotNotation + propPath[i].getName();
        }
        if (dotNotation.startsWith("proxyExt.")) {
            dotNotation = dotNotation.substring(9);
        }
        return dotNotation;
    }

    static String getMgrColumnName(Property[] props) {
        String mgrColumnName = props[props.length - 1].getDefaultDisplayName(null);
        String propPathInDotNotation = NMgrColumnUtil.toDotNotation(props);
        for (int i = 0; i < props.length; ++i) {
            Lexicon propLex = props[i].getDeclaringType().getModule().getLexicon();
            if (propLex == null) continue;
            mgrColumnName = propLex.get(propPathInDotNotation, mgrColumnName);
        }
        return mgrColumnName;
    }

    public static class NMgrPropPath
    extends MgrColumn.PropPath {
        public NMgrPropPath(Property[] props, int flags) {
            super(NMgrColumnUtil.getMgrColumnName(props), props, flags);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            return super.toEditor(rows, colIndex, null);
        }

        public Object get(Object row) {
            if (row instanceof BINDiscoveryGroup) {
                return row.toString();
            }
            return super.get(row);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (row instanceof BINDiscoveryGroup) {
                return row.toString();
            }
            return super.toDisplayString(row, value, cx);
        }
    }
}

