/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetOws.datatypes;

import com.tridium.bacnet.datatypes.BPriorityFilter;
import com.tridium.bacnet.datatypes.BRequestConfig;
import com.tridium.bacnet.enums.BAcknowledgmentFilter;
import com.tridium.bacnet.enums.BEventStateFilter;
import com.tridium.bacnetOws.BBacnetOwsNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetRecipientProcess;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BGetESummConfig
extends BRequestConfig {
    public static final Property deviceAddress = BGetESummConfig.newProperty((int)4, (BValue)BBacnetAddress.DEFAULT, null);
    public static final Property acknowledgment = BGetESummConfig.newProperty((int)0, (BValue)BAcknowledgmentFilter.all, null);
    public static final Property enrollment = BGetESummConfig.newProperty((int)0, (BValue)new BBacnetRecipientProcess(), null);
    public static final Property eventState = BGetESummConfig.newProperty((int)0, (BValue)BEventStateFilter.all, null);
    public static final Property eventType = BGetESummConfig.newProperty((int)0, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((Type)BBacnetEventType.TYPE, (int[])new int[]{-1}, (String[])new String[]{"all"})), null);
    public static final Property priority = BGetESummConfig.newProperty((int)0, (BValue)new BPriorityFilter(), null);
    public static final Property notificationClass = BGetESummConfig.newProperty((int)0, (int)-1, null);
    public static final Type TYPE = Sys.loadType(BGetESummConfig.class);

    public BBacnetAddress getDeviceAddress() {
        return (BBacnetAddress)this.get(deviceAddress);
    }

    public void setDeviceAddress(BBacnetAddress v) {
        this.set(deviceAddress, (BValue)v, null);
    }

    public BAcknowledgmentFilter getAcknowledgment() {
        return (BAcknowledgmentFilter)this.get(acknowledgment);
    }

    public void setAcknowledgment(BAcknowledgmentFilter v) {
        this.set(acknowledgment, (BValue)v, null);
    }

    public BBacnetRecipientProcess getEnrollment() {
        return (BBacnetRecipientProcess)this.get(enrollment);
    }

    public void setEnrollment(BBacnetRecipientProcess v) {
        this.set(enrollment, (BValue)v, null);
    }

    public BEventStateFilter getEventState() {
        return (BEventStateFilter)this.get(eventState);
    }

    public void setEventState(BEventStateFilter v) {
        this.set(eventState, (BValue)v, null);
    }

    public BEnum getEventType() {
        return (BEnum)this.get(eventType);
    }

    public void setEventType(BEnum v) {
        this.set(eventType, (BValue)v, null);
    }

    public BPriorityFilter getPriority() {
        return (BPriorityFilter)this.get(priority);
    }

    public void setPriority(BPriorityFilter v) {
        this.set(priority, (BValue)v, null);
    }

    public long getNotificationClass() {
        return this.getLong(notificationClass);
    }

    public void setNotificationClass(long v) {
        this.setLong(notificationClass, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder();
        if (cx == BBacnetOwsNetwork.jobContext) {
            sb.append("ack:").append(this.getAcknowledgment());
            if (this.isEnrollmentUsed()) {
                sb.append("; enrollment:").append(this.getEnrollment());
            }
            if (this.isEventStateUsed()) {
                sb.append("; eventState:").append(this.getEventState());
            }
            if (this.isEventTypeUsed()) {
                sb.append("; eventTypeFilter:").append(this.getEventType());
            }
            if (this.isPriorityUsed()) {
                sb.append("; priorityFilter:").append(this.getPriority());
            }
            if (this.isNotificationClassUsed()) {
                sb.append("; notificationClassFilter:").append(this.getNotificationClass());
            }
        } else {
            sb.append("\n  ackFilter:" + this.getAcknowledgment());
            if (this.isEnrollmentUsed()) {
                sb.append("\n  enrollmentFilter:").append(this.getEnrollment());
            }
            if (this.isEventStateUsed()) {
                sb.append("\n  eventStateFilter:").append(this.getEventState());
            }
            if (this.isEventTypeUsed()) {
                sb.append("\n  eventTypeFilter:").append(this.getEventType());
            }
            if (this.isPriorityUsed()) {
                sb.append("\n  priorityFilter:").append(this.getPriority());
            }
            if (this.isNotificationClassUsed()) {
                sb.append("\n  notificationClassFilter:").append(this.getNotificationClass());
            }
        }
        return sb.toString();
    }

    public boolean isEnrollmentUsed() {
        return !enrollment.isEquivalentToDefaultValue((BValue)this.getEnrollment());
    }

    public boolean isEventStateUsed() {
        return !eventState.isEquivalentToDefaultValue((BValue)this.getEventState());
    }

    public boolean isEventTypeUsed() {
        return !eventType.isEquivalentToDefaultValue((BValue)this.getEventType());
    }

    public boolean isPriorityUsed() {
        return !priority.isEquivalentToDefaultValue((BValue)this.getPriority());
    }

    public boolean isNotificationClassUsed() {
        return !notificationClass.isEquivalentToDefaultValue(this.get(notificationClass));
    }

    public BAcknowledgmentFilter getAcknowledgmentFilter() {
        return this.getAcknowledgment();
    }

    public BBacnetRecipientProcess getEnrollmentFilter() {
        return this.isEnrollmentUsed() ? this.getEnrollment() : null;
    }

    public BEventStateFilter getEventStateFilter() {
        return this.isEventStateUsed() ? this.getEventState() : null;
    }

    public BEnum getEventTypeFilter() {
        return this.isEventTypeUsed() ? this.getEventType() : null;
    }

    public BPriorityFilter getPriorityFilter() {
        return this.isPriorityUsed() ? this.getPriority() : null;
    }

    public long getNotificationClassFilter() {
        return this.isNotificationClassUsed() ? this.getNotificationClass() : -1L;
    }
}

