/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetOws;

import javax.baja.bacnet.util.BBacnetWorker;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

public class BBacnetThreadPoolWorker
extends BBacnetWorker {
    public static final Property maxQueueSize = BBacnetThreadPoolWorker.newProperty((int)0, (int)100000, null);
    public static final Property maxThreads = BBacnetThreadPoolWorker.newProperty((int)0, (int)4, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Type TYPE = Sys.loadType(BBacnetThreadPoolWorker.class);

    public int getMaxThreads() {
        return this.getInt(maxThreads);
    }

    public void setMaxThreads(int v) {
        this.setInt(maxThreads, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetThreadPoolWorker() {
    }

    public BBacnetThreadPoolWorker(int queueSize) {
        super(queueSize);
    }

    public BBacnetThreadPoolWorker(String workerName) {
        super(workerName);
    }

    public void started() throws Exception {
        super.started();
        this.updateMaxThreads();
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.updateMaxThreads();
    }

    public void changed(Property prop, Context cx) {
        if (this.isRunning() && prop.equals(maxThreads)) {
            this.updateMaxThreads();
            return;
        }
        super.changed(prop, cx);
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new CoalesceQueue(this.getMaxQueueSize());
            this.worker = new ThreadPoolWorker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    void updateMaxThreads() {
        ThreadPoolWorker w = (ThreadPoolWorker)this.getWorker();
        if (w != null) {
            w.setMaxThreads(this.getMaxThreads());
        }
    }
}

