/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.TellStationMessage;
import com.tridium.util.CommandLineArguments;
import java.util.logging.Logger;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTellStationCommand
extends BDaemonSessionCommand {
    public static final BTellStationCommand INSTANCE = new BTellStationCommand();
    public static final Type TYPE = Sys.loadType(BTellStationCommand.class);
    private static Logger log = Logger.getLogger("tellstation");

    public Type getType() {
        return TYPE;
    }

    protected BTellStationCommand() {
    }

    public String getCommandName() {
        return "tellstation";
    }

    public String getCommandDescription() {
        return "send text to the console of a running Niagara Station";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BTellStationCommand.println((String)"", (Object[])new Object[0]);
        BTellStationCommand.println((String)"usage:", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  plat tellstation <flags> <stationname> <message>", (Object[])new Object[0]);
        BTellStationCommand.println((String)"parameters:", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  stationname        name of the station which gets the message", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  message            text to send to the station's console.  If", (Object[])new Object[0]);
        BTellStationCommand.println((String)"                       the text has whitespace, it should be quoted", (Object[])new Object[0]);
        BTellStationCommand.println((String)"required flags:", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -h:<hostord>       host's ORD", (Object[])new Object[0]);
        BTellStationCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -pwd:<password>    password for the host's platform daemon", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -noinput           if given, command will fail when username", (Object[])new Object[0]);
        BTellStationCommand.println((String)"                       and password are missing or incorrect,", (Object[])new Object[0]);
        BTellStationCommand.println((String)"                       instead of prompting and reading them", (Object[])new Object[0]);
        BTellStationCommand.println((String)"                       from stdin", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -p:<port>          port for the host's platform daemon", (Object[])new Object[0]);
        BTellStationCommand.println((String)"                       if omitted, default port 3011 is used", (Object[])new Object[0]);
        BTellStationCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        if (args.hasHelpOption() || args.parameters.length < 2) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        String stationName = args.parameters[0];
        String message = args.parameters[1];
        session.sendMessage((DaemonMessage)new TellStationMessage(stationName, message));
        log.info("message sent to " + stationName);
        return 0;
    }
}

