/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.util.CommandLineArguments;
import java.util.logging.Logger;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStopStationCommand
extends BDaemonSessionCommand {
    public static final BStopStationCommand INSTANCE = new BStopStationCommand();
    public static final Type TYPE = Sys.loadType(BStopStationCommand.class);
    private static Logger log = Logger.getLogger("stopstation");

    public Type getType() {
        return TYPE;
    }

    protected BStopStationCommand() {
    }

    public String getCommandName() {
        return "stopstation";
    }

    public String getCommandDescription() {
        return "request that a Niagara Platform Daemon stop a station";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BStopStationCommand.println((String)"", (Object[])new Object[0]);
        BStopStationCommand.println((String)"usage:", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  plat stopstation <flags> [stationname]", (Object[])new Object[0]);
        BStopStationCommand.println((String)"parameters:", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  stationname        name of the station to stop.   If omitted,", (Object[])new Object[0]);
        BStopStationCommand.println((String)"                       the first/only station will be stopped", (Object[])new Object[0]);
        BStopStationCommand.println((String)"required flags:", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  -h:<hostord>       host's ORD", (Object[])new Object[0]);
        BStopStationCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  -pwd:<password>    password for the host's platform daemon", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  -noinput           if given, command will fail when username", (Object[])new Object[0]);
        BStopStationCommand.println((String)"                       and password are missing or incorrect,", (Object[])new Object[0]);
        BStopStationCommand.println((String)"                       instead of prompting and reading them", (Object[])new Object[0]);
        BStopStationCommand.println((String)"                       from stdin", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  -p:<port>          port for the host's platform daemon", (Object[])new Object[0]);
        BStopStationCommand.println((String)"                       if omitted, default port 3011 is used", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  -restart           if provided, the station will be restarted", (Object[])new Object[0]);
        BStopStationCommand.println((String)"                       after it terminates", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  -kill              kill the station immediately, instead of allowing", (Object[])new Object[0]);
        BStopStationCommand.println((String)"                       it to gracefully terminate", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  -locale:<x>        set the default locale (en_US)", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  -@<option>         pass option to Java VM", (Object[])new Object[0]);
        BStopStationCommand.println((String)"  -buildreg          force rebuild of the registry", (Object[])new Object[0]);
        BStopStationCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        String stationName;
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        boolean restartArg = args.hasOption("restart");
        boolean killArg = args.hasOption("kill");
        if (args.parameters.length == 0) {
            BStationSurrogate[] stations = BStationSurrogate.makeAll((BDaemonSession)session);
            if (stations.length == 0) {
                log.warning("No stations on remote host");
                return 4;
            }
            stationName = stations[0].getStationName();
        } else {
            stationName = args.parameters[0];
        }
        BStationSurrogate station = BStationSurrogate.make((BDaemonSession)session, (String)stationName);
        if (station.getStationStatus() == BStationStatus.unknown) {
            log.severe("Station " + stationName + " not found");
            return 1;
        }
        if (station.getStationStatus() == BStationStatus.idle || station.getStationStatus() == BStationStatus.failed) {
            log.warning("Station " + stationName + " is not running");
            return 4;
        }
        if (killArg) {
            station.killStationAsync();
            log.info("Station " + stationName + " killed");
        } else if (restartArg) {
            station.restartStationAsync();
            log.info("Station " + stationName + " restarted");
        } else {
            station.stopStation(null, null);
            log.info("Station " + stationName + " stopped");
        }
        return 0;
    }
}

