/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.CommandLineArguments;
import java.util.logging.Logger;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BModuleInstallCommand
extends BDaemonSessionCommand {
    public static final BModuleInstallCommand INSTANCE = new BModuleInstallCommand();
    public static final Type TYPE = Sys.loadType(BModuleInstallCommand.class);
    private static Logger log = Logger.getLogger("moduleinstall");

    public Type getType() {
        return TYPE;
    }

    protected BModuleInstallCommand() {
    }

    public String getCommandName() {
        return "moduleinstall";
    }

    public String getCommandDescription() {
        return "install Niagara modules to a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BModuleInstallCommand.println((String)"", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"usage:", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  plat moduleinstall <flags> [modulename]*", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"parameters:", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  modulename         names of a module to install to the remote host", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"required flags:", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -h:<hostord>       ORD for the remote host", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -pwd:<password>    password for the host's platform daemon", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -noinput           if given, command will fail when username", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"                       and password are missing or incorrect,", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"                       instead of prompting and reading them", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"                       from stdin", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -p:<port>          port for the remote host's platform daemon", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"                       if omitted, default port 3011 is used", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -ood               all out-of-date modules are to be upgraded", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -locale:<x>        set the default locale (en_US)", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -@<option>         pass option to Java VM", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"  -buildreg          force rebuild of the registry", (Object[])new Object[0]);
        BModuleInstallCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        UnmeetableDependency[] unmet;
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        boolean oodArg = args.hasOption("ood");
        if (!oodArg && args.parameters.length == 0) {
            this.usage();
            return 2;
        }
        int retCode = 0;
        BRemoteDaemonPlatform targetPlatform = BRemoteDaemonPlatform.make((BDaemonSession)session, null);
        targetPlatform.checkSession();
        targetPlatform.loadPreferredVerificationMode();
        BDependency[] moduleDeps = new BDependency[args.parameters.length];
        for (int i = 0; i < args.parameters.length; ++i) {
            moduleDeps[i] = BDependency.forModule((String)args.parameters[i]);
        }
        Listener listener = new Listener();
        InstallScenario scenario = InstallScenario.solve((BDaemonPlatform)targetPlatform, (DaemonSessionTaskListener)listener, null, (BDependency[])moduleDeps, null, null, (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)CertificateChainValidator.make((ICoreCryptoManager)BPlatCryptoManager.make((BDaemonPlatform)targetPlatform)));
        if (scenario.canCommit() && oodArg) {
            scenario = InstallScenario.upgradeOutOfDate((InstallScenario)scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance());
        }
        if ((unmet = scenario.getUnmeetableDependencies()).length > 0) {
            log.severe("The following dependencies cannot be met");
            for (int i = 0; i < unmet.length; ++i) {
                System.out.println("  " + unmet[i]);
            }
            return 1;
        }
        if (scenario.getToInstall().length == 0) {
            log.info("All remote modules are already up to date.");
            return retCode;
        }
        if (!scenario.canCommit()) {
            log.severe("cannot commit installation");
            return 1;
        }
        log.info("Stopping stations on " + session.getHost().getNavDisplayName(null));
        BAppSurrogate[] stopped = BAppSurrogate.stopAllApps((BDaemonSession)session, null, null, null);
        scenario.commit((DaemonSessionTaskListener)listener, null);
        log.info("Installation complete.");
        if (stopped.length > 0) {
            for (int i = 0; i < stopped.length; ++i) {
                if (!stopped[i].isRestartEnabled()) continue;
                stopped[i].startAppAsync();
                log.info("Started " + stopped[i].toString(null));
            }
        }
        return retCode;
    }

    private static class Listener
    implements DaemonSessionTaskListener {
        String lastText = null;

        private Listener() {
        }

        public void taskStarted(DaemonSessionTask task) {
            if (!task.getMessage().equals(this.lastText)) {
                System.out.println(task.getMessage());
                this.lastText = task.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask task) {
            this.taskStarted(task);
        }

        public void taskFinished(DaemonSessionTask task) {
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

