/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platDaemon.util.DaemonGlob;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.FileCache;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.CommandLineArguments;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFilePutCommand
extends BDaemonSessionCommand {
    public static final BFilePutCommand INSTANCE = new BFilePutCommand();
    public static final Type TYPE = Sys.loadType(BFilePutCommand.class);
    private static Logger log = Logger.getLogger("fput");

    public Type getType() {
        return TYPE;
    }

    protected BFilePutCommand() {
    }

    public String getCommandName() {
        return "fput";
    }

    public boolean includeInCommandListing() {
        return false;
    }

    public String getCommandDescription() {
        return "send one or more files to a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BFilePutCommand.println((String)"", (Object[])new Object[0]);
        BFilePutCommand.println((String)"usage:", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  plat fput <flags> <srcPath>* <destPath>", (Object[])new Object[0]);
        BFilePutCommand.println((String)"parameters:", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  srcPath            path of a file on the local computer to be copied", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  destPath           path of a directory to which the files are to be", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       copied", (Object[])new Object[0]);
        BFilePutCommand.println((String)"required flags:", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -h:<hostord>       ORD for the remote host", (Object[])new Object[0]);
        BFilePutCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -pwd:<password>    password for the host's platform daemon", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -noinput           if given, command will fail when username", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       and password are missing or incorrect,", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       instead of prompting and reading them", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       from stdin", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -recurse           copy children of the directories identified by", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       <srcPath> recursively", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -r                 same as -recurse", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -overwrite:<opt>   overwrite option, default is 'prompt', values are:", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       'all'    unconditionally overwrite", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       'prompt' prompt for each overwrite", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       'none'   never overwrite", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       'crc'    overwrite only if crc is different", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -o:<opt>           same as -overwrite", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -notransact        by default, files are written to a temporary", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       location, then copied by the niagarad to", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       their final location once all transmission", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       is successful.  -notransact disables this", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       feature. WARNING: using this option increases", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       the chance of file corruption, and can result", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       in a Jace that is not remotely servicable", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -nt                same as -notransact", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -p:<port>          port for the remote host's platform daemon", (Object[])new Object[0]);
        BFilePutCommand.println((String)"                       if omitted, default port 3011 is used", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -locale:<x>        set the default locale (en_US)", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -@<option>         pass option to Java VM", (Object[])new Object[0]);
        BFilePutCommand.println((String)"  -buildreg          force rebuild of the registry", (Object[])new Object[0]);
        BFilePutCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        boolean noTransact = args.hasOption("notransact") || args.hasOption("nt");
        String overwriteArg = "prompt";
        if (args.hasOption("o")) {
            overwriteArg = args.getOption("o");
        } else if (args.hasOption("overwrite")) {
            overwriteArg = args.getOption("overwrite");
        }
        if (!(overwriteArg.equals("all") || overwriteArg.equals("prompt") || overwriteArg.equals("crc") || overwriteArg.equals("none"))) {
            this.usage();
            return 2;
        }
        boolean recurse = args.hasOption("r") || args.hasOption("recurse");
        boolean osUpdate = args.hasOption("osupdate");
        if (args.parameters.length < 2) {
            this.usage();
            return 2;
        }
        FileCache cache = new FileCache((BFileSpace)session.getFileSpace());
        FileTransferMessage msg = new FileTransferMessage(noTransact, (StoreCache)cache, (BDaemonFileSpace)session.getFileSpace());
        FilePath destRoot = new FilePath(args.parameters[args.parameters.length - 1]);
        BIFile destDir = DaemonFileUtil.findFile((BFileSpace)session.getFileSpace(), (FilePath)destRoot, (FileCache)cache);
        if (destDir != null && !destDir.isDirectory()) {
            if (args.parameters.length > 2) {
                log.severe("Multiple file sources with one file target");
                return 2;
            }
            destRoot = destRoot.getParent();
        }
        for (int ixArg = 0; ixArg < args.parameters.length - 1; ++ixArg) {
            FilePath[] paths = DaemonGlob.expandPathString((BFileSpace)BFileSystem.INSTANCE, DaemonGlob.makeFilePathString(args.parameters[ixArg]));
            for (int ixPath = 0; ixPath < paths.length; ++ixPath) {
                BIFile srcFile = BFileSystem.INSTANCE.findFile(paths[ixPath]);
                if (srcFile.isDirectory()) {
                    this.addDirectoryContents(msg, (BDirectory)srcFile, destRoot, recurse, overwriteArg, cache);
                    continue;
                }
                this.addFile(msg, srcFile, destRoot, overwriteArg, cache);
            }
        }
        DaemonFileUtil.transfer((BDaemonSession)session, (FileTransferMessage)msg, null, (DaemonSessionTaskListener)new Listener());
        if (osUpdate && (overwriteArg.equals("all") || this.promptBoolean("Apply OS Update (y/n)? "))) {
            session.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 90000);
            log.info("OS update requested");
        }
        return 0;
    }

    private void addFile(FileTransferMessage msg, BIFile srcFile, FilePath destDirPath, String overwriteArg, FileCache cache) throws Exception {
        FilePath destPath = destDirPath.merge(srcFile.getFileName());
        if (overwriteArg.equals("all")) {
            msg.addFile(srcFile, destPath);
        } else {
            BIFile existingFile = DaemonFileUtil.findFile((BFileSpace)msg.getTargetFileSpace(), (FilePath)destPath, (FileCache)cache);
            if (existingFile == null || overwriteArg.equals("all")) {
                msg.addFile(srcFile, destPath);
            } else if (overwriteArg.equals("crc")) {
                if (DaemonFileUtil.getCrc((BIFile)srcFile) == DaemonFileUtil.getCrc((BIFile)existingFile)) {
                    log.info(destPath.getBody() + " not overwritten");
                } else {
                    msg.addFile(srcFile, destPath);
                }
            } else if (overwriteArg.equals("prompt")) {
                if (this.promptBoolean("Replace \"" + destPath.getBody() + "\" (y/n)? ")) {
                    msg.addFile(srcFile, destPath);
                }
            } else if (overwriteArg.equals("none")) {
                log.info(destPath.getBody() + " not overwritten");
            }
        }
    }

    private void addDirectoryContents(FileTransferMessage msg, BDirectory srcDir, FilePath destDirPath, boolean recurse, String overwriteArg, FileCache cache) throws Exception {
        BIFile[] srcFiles = srcDir.listFiles();
        for (int i = 0; i < srcFiles.length; ++i) {
            if (srcFiles[i].isDirectory()) {
                if (!recurse) continue;
                this.addDirectoryContents(msg, (BDirectory)srcFiles[i], destDirPath.merge(srcFiles[i].getFileName()), recurse, overwriteArg, cache);
                continue;
            }
            this.addFile(msg, srcFiles[i], destDirPath.merge(srcFiles[i].getFileName()), overwriteArg, cache);
        }
    }

    private static class Listener
    implements DaemonSessionTaskListener {
        String lastText = null;

        private Listener() {
        }

        public void taskStarted(DaemonSessionTask task) {
            if (!task.getMessage().equals(this.lastText)) {
                System.out.println(task.getMessage());
                this.lastText = task.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask task) {
            this.taskStarted(task);
        }

        public void taskFinished(DaemonSessionTask task) {
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

