/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platDaemon.util.DaemonGlob;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.FileCache;
import com.tridium.util.CommandLineArguments;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFileGetCommand
extends BDaemonSessionCommand {
    public static final BFileGetCommand INSTANCE = new BFileGetCommand();
    public static final Type TYPE = Sys.loadType(BFileGetCommand.class);
    private static Logger log = Logger.getLogger("fget");

    public Type getType() {
        return TYPE;
    }

    protected BFileGetCommand() {
    }

    public String getCommandName() {
        return "fget";
    }

    public String getCommandDescription() {
        return "get one or more files from a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BFileGetCommand.println((String)"", (Object[])new Object[0]);
        BFileGetCommand.println((String)"usage:", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  plat fget <flags> <srcPath>* <destPath>", (Object[])new Object[0]);
        BFileGetCommand.println((String)"parameters:", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  srcPath            path of a file on the remote host to be", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       copied", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  destPath           path of an existing directory on the local computer", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       to which files are to be copied", (Object[])new Object[0]);
        BFileGetCommand.println((String)"required flags:", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -h:<hostord>       ORD for the remote host", (Object[])new Object[0]);
        BFileGetCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -pwd:<password>    password for the host's platform daemon", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -noinput           if given, command will fail when username", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       and password are missing or incorrect,", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       instead of prompting and reading them", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       from stdin", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -recurse           copy children of the directories identified by", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       <srcPath> recursively", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -r                 same as -recurse", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -overwrite:<opt>   overwrite option, default is 'prompt', values are:", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       'all'    unconditionally overwrite", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       'prompt' prompt for each overwrite", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       'none'   never overwrite", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       'crc'    overwrite only if crc is different", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -o:<opt>           same as -overwrite", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -p:<port>          port for the remote host's platform daemon", (Object[])new Object[0]);
        BFileGetCommand.println((String)"                       if omitted, default port 3011 is used", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -locale:<x>        set the default locale (en_US)", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -@<option>         pass option to Java VM", (Object[])new Object[0]);
        BFileGetCommand.println((String)"  -buildreg          force rebuild of the registry", (Object[])new Object[0]);
        BFileGetCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        boolean recurse;
        if (args.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        String overwriteArg = "prompt";
        if (args.hasOption("o")) {
            overwriteArg = args.getOption("o", "prompt");
        } else if (args.hasOption("overwrite")) {
            overwriteArg = args.getOption("overwrite", "prompt");
        }
        if (!(overwriteArg.equals("all") || overwriteArg.equals("prompt") || overwriteArg.equals("crc") || overwriteArg.equals("none"))) {
            this.usage();
            return 2;
        }
        if (args.hasOption("noinput") && overwriteArg.equals("prompt")) {
            log.severe("Error: cannot use overwrite=prompt and noinput options together");
            return 2;
        }
        boolean bl = recurse = args.hasOption("r") || args.hasOption("recurse");
        if (args.parameters.length < 2) {
            this.usage();
            return 2;
        }
        FileCache cache = new FileCache((BFileSpace)session.getFileSpace());
        FilePath targetDirPath = new FilePath(DaemonGlob.makeFilePathString(args.parameters[args.parameters.length - 1]));
        BIFile targetDir = BFileSystem.INSTANCE.findFile(targetDirPath);
        if (targetDir != null && !targetDir.isDirectory()) {
            if (args.parameters.length > 2) {
                log.severe("Multiple file sources with one file target");
                return 2;
            }
            targetDirPath = targetDirPath.getParent();
        }
        for (int ixArgs = 0; ixArgs < args.parameters.length - 1; ++ixArgs) {
            FilePath[] paths = DaemonGlob.expandPathString((BFileSpace)session.getFileSpace(), args.parameters[ixArgs], cache);
            for (int ixPath = 0; ixPath < paths.length; ++ixPath) {
                BIFile srcFile = DaemonFileUtil.findFile((BFileSpace)session.getFileSpace(), (FilePath)paths[ixPath], (FileCache)cache);
                if (srcFile.isDirectory()) {
                    this.getDirectory((BDirectory)srcFile, targetDirPath, recurse, overwriteArg, cache);
                    continue;
                }
                this.getFile(srcFile, targetDirPath, overwriteArg, cache);
            }
        }
        return 0;
    }

    private void getDirectory(BDirectory srcDir, FilePath targetDirPath, boolean recurse, String overwriteArg, FileCache cache) throws Exception {
        BIFile[] kids = DaemonFileUtil.listFiles((BDirectory)srcDir, (FileCache)cache);
        for (int i = 0; i < kids.length; ++i) {
            if (kids[i].isDirectory()) {
                if (!recurse) continue;
                this.getDirectory((BDirectory)kids[i], targetDirPath.merge(kids[i].getFileName()), recurse, overwriteArg, cache);
                continue;
            }
            this.getFile(kids[i], targetDirPath, overwriteArg, cache);
        }
    }

    private void getFile(BIFile srcFile, FilePath targetDirPath, String overwriteArg, FileCache cache) throws Exception {
        BFileSystem.INSTANCE.makeDir(targetDirPath);
        FilePath destPath = targetDirPath.merge(srcFile.getFileName());
        BIFile newFile = BFileSystem.INSTANCE.findFile(destPath);
        String actionText = "created ";
        if (newFile == null) {
            newFile = BFileSystem.INSTANCE.makeFile(destPath);
        } else {
            if (overwriteArg.equals("crc") && DaemonFileUtil.getCrc((BIFile)srcFile) == DaemonFileUtil.getCrc((BIFile)newFile)) {
                log.info(destPath.getBody() + " not overwritten");
                return;
            }
            if (overwriteArg.equals("prompt")) {
                if (!this.promptBoolean("Replace " + destPath.getBody() + " (y/n)? ")) {
                    return;
                }
                actionText = "replaced ";
            } else {
                if (overwriteArg.equals("none")) {
                    log.info(destPath.getBody() + " not overwritten");
                    return;
                }
                actionText = "replaced ";
            }
        }
        OutputStream out = newFile.getOutputStream();
        InputStream in = srcFile.getInputStream();
        byte[] buf = new byte[8192];
        try {
            int nRead;
            while ((nRead = in.read(buf, 0, 8192)) > 0) {
                out.write(buf, 0, nRead);
            }
        }
        catch (IOException e) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        log.info(actionText + destPath.getBody());
    }
}

