/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platDaemon.util.DaemonGlob;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.CommandLineArguments;
import javax.baja.file.BFileSpace;
import javax.baja.file.FilePath;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFileDeleteCommand
extends BDaemonSessionCommand {
    public static final BFileDeleteCommand INSTANCE = new BFileDeleteCommand();
    public static final Type TYPE = Sys.loadType(BFileDeleteCommand.class);

    public Type getType() {
        return TYPE;
    }

    protected BFileDeleteCommand() {
    }

    public String getCommandName() {
        return "fdelete";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public boolean includeInCommandListing() {
        return false;
    }

    public String getCommandDescription() {
        return "delete files or directories from the remote host";
    }

    public void usage() {
        BFileDeleteCommand.println((String)"", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"usage:", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  plat fdelete <flags> <path>*", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"parameters:", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  path               path to be deleted", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"required flags:", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  -h:<hostord>       ORD for the remote host", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  -pwd:<password>    password for the host's platform daemon", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  -noinput           if given, command will fail when username", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"                       and password are missing or incorrect,", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"                       instead of prompting and reading them", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"                       from stdin", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  -prompt            prompt before each delete, default", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  -noprompt          do not prompt before each delete", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  -p:<port>          port for the remote host's platform daemon", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"                       if omitted, default port 3011 is used", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  -locale:<x>        set the default locale (en_US)", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  -@<option>         pass option to Java VM", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"  -buildreg          force rebuild of the registry", (Object[])new Object[0]);
        BFileDeleteCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        if (args.hasHelpOption() || args.parameters.length < 1) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        boolean prompt = !args.hasOption("noprompt");
        BDefaultDaemonFileSpace space = session.getFileSpace();
        FileTransferMessage msg = new FileTransferMessage((BDaemonFileSpace)space);
        for (int ixArg = 0; ixArg < args.parameters.length; ++ixArg) {
            FilePath[] paths = DaemonGlob.expandPathString((BFileSpace)space, args.parameters[ixArg]);
            for (int ixPath = 0; ixPath < paths.length; ++ixPath) {
                if (prompt && !this.promptDelete(paths[ixPath])) continue;
                msg.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(paths[ixPath], (BDaemonFileSpace)space));
            }
        }
        DaemonFileUtil.transfer((BDaemonSession)session, (FileTransferMessage)msg, null, (DaemonSessionTaskListener)new Listener());
        return 0;
    }

    private boolean promptDelete(FilePath path) throws Exception {
        return this.promptBoolean("Delete " + path.getBody() + " (y/n)? ");
    }

    private static class Listener
    implements DaemonSessionTaskListener {
        String lastText = null;

        private Listener() {
        }

        public void taskStarted(DaemonSessionTask task) {
            if (!task.getMessage().equals(this.lastText)) {
                System.out.println(task.getMessage());
                this.lastText = task.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask task) {
            this.taskStarted(task);
        }

        public void taskFinished(DaemonSessionTask task) {
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

