/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DaemonPlatformUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.CheckAuthenticationReadonlyMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.util.CommandLineArguments;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BDistInstallCommand
extends BDaemonSessionCommand {
    public static final BDistInstallCommand INSTANCE = new BDistInstallCommand();
    public static final Type TYPE = Sys.loadType(BDistInstallCommand.class);
    private static Logger log = Logger.getLogger("distinstall");

    public Type getType() {
        return TYPE;
    }

    protected BDistInstallCommand() {
    }

    public String getCommandName() {
        return "distinstall";
    }

    public String getCommandDescription() {
        return "install distribution files to a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BDistInstallCommand.println((String)"", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"usage:", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  plat distinstall <flags> <distfilepath>", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"parameters:", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  distfilepath              FilePath for the distribution file to install", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"required flags:", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -h:<hostord>              ORD for the remote host", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -usr:<userName>           user name for the host's platform daemon", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -pwd:<password>           password for the host's platform daemon", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -syspwd:<password>        system passphrase used to protect this distribution file", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"                              if the target platform is currently protected by the same", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"                              system passphrase as this distribution, this argument is ignored", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -notcp                    if present, the install will not change the", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"                              remote host's TCP/IP settings", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -tcp                      if present, the install will change the", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"                              remote host's TCP/IP settings", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -ood                      all out-of-date modules are to be upgraded", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -p:<port>                 port for the remote host's platform daemon", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"                              if omitted, default port 3011 is used", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -noinput                  if given, command will fail when username", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"                              password, passphrase are missing or incorrect,", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"                              instead of prompting and reading them", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"                              from stdin", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -locale:<x>               set the default locale (en_US)", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -@<option>                pass option to Java VM", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"  -buildreg                 force rebuild of the registry", (Object[])new Object[0]);
        BDistInstallCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        boolean oodArg = args.hasOption("ood");
        boolean noTcpArg = args.hasOption("notcp");
        boolean tcpArg = args.hasOption("tcp");
        if (args.hasHelpOption() || args.parameters.length != 1) {
            this.usage();
            return 2;
        }
        String distArg = args.parameters[0];
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        int retCode = 0;
        BIFile distFile = BFileSystem.INSTANCE.findFile(new FilePath(distArg));
        if (distFile == null) {
            log.severe(distArg + " not found");
            return 1;
        }
        BRemoteDaemonPlatform target = BRemoteDaemonPlatform.make((BDaemonSession)session, null);
        target.checkSession();
        target.getModuleList().init();
        target.loadPreferredVerificationMode();
        BDistribution distToInstall = new BDistribution(distFile);
        PBEEncodingInfo passphraseEncodingInfo = distToInstall.getManifest().getPBEEncodingInfo();
        SecretChars systemPassphrase = null;
        boolean systemPassphraseRequired = passphraseEncodingInfo != null && !session.validateSystemPassPhrase((PBEValidator)distToInstall.getManifest().getPBEEncodingInfo());
        String systemPassphraseArg = null;
        if (systemPassphraseRequired) {
            systemPassphraseArg = args.getOption("syspwd", null);
            if (systemPassphraseArg != null) {
                try (SecretChars secretChars = SecretChars.fromString((String)systemPassphraseArg);){
                    if (passphraseEncodingInfo.test(secretChars)) {
                        systemPassphraseRequired = false;
                    }
                    if (args.hasOption("noinput")) {
                        log.severe("The incorrect system passphrase (syspwd) for this distribution was provided.");
                        int n = 1;
                        return n;
                    }
                    log.info("The incorrect system passphrase for this distribution was provided.");
                    log.info("Please provide the system passphrase used to create this distribution file to install it.");
                }
            } else {
                if (args.hasOption("noinput")) {
                    log.severe("Target platform does not use the same system passphrase as the distribution file, must provide syspwd argument.");
                    return 1;
                }
                log.info("This distribution file requires a system passphrase for installation.");
                log.info("Please provide the system passphrase used to create this distribution file to install it.");
            }
            while (systemPassphraseRequired) {
                systemPassphraseArg = this.promptString("System Passphrase: ");
                boolean bl = systemPassphraseRequired = !passphraseEncodingInfo.test(SecretChars.fromString((String)systemPassphraseArg));
                if (systemPassphraseRequired) {
                    log.info("Incorrect system passphrase.");
                    continue;
                }
                log.info("System passphrase accepted.");
            }
            systemPassphrase = SecretChars.fromString((String)systemPassphraseArg);
        }
        CertificateChainValidator certificateChainValidator = CertificateChainValidator.make((ICoreCryptoManager)BPlatCryptoManager.make((BDaemonPlatform)target));
        certificateChainValidator.setLaxValidation(distToInstall.getInstallableName().equals("backupdist"));
        InstallScenario scenario = InstallScenario.solve((BDaemonPlatform)target, null, null, null, (BInstallable[])new BInstallable[]{distToInstall}, null, (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)certificateChainValidator);
        if (scenario.getExcludedInstallables().length > 0) {
            log.severe("One or more of the file's exclusions failed");
            return 1;
        }
        UnmeetableDependency[] unmet = scenario.getUnmeetableDependencies();
        if (unmet.length == 0 && oodArg) {
            scenario = InstallScenario.upgradeOutOfDate((InstallScenario)scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
        }
        if (unmet.length > 0) {
            log.severe("The following dependencies cannot be met");
            for (int i = 0; i < unmet.length; ++i) {
                System.out.println("  " + unmet[i]);
            }
            return 1;
        }
        if (scenario.getToInstall().length == 0) {
            log.info("All remote software is already up to date.");
            return retCode;
        }
        long flags = scenario.getProcessingFlags();
        if ((flags & 0x80000L) > 0L) {
            if (noTcpArg) {
                flags &= 0xFFFFFFFFFFF7FFFFL;
            } else if (!tcpArg) {
                if (args.hasOption("noinput")) {
                    log.severe("Distribution contains TCP/IP changes, must provide -tcp or -notcp option");
                    return 1;
                }
                if (!this.promptBoolean("Apply TCP/IP changes (y/n)?")) {
                    flags &= 0xFFFFFFFFFFF7FFFFL;
                }
            }
        }
        BAppSurrogate[] stopped = new BAppSurrogate[]{};
        Listener listener = new Listener();
        if ((flags & 1L) > 0L || (flags & 2L) > 0L) {
            log.info("Stopping apps on " + session.getHost().getNavDisplayName(null));
            stopped = BAppSurrogate.stopAllApps((BDaemonSession)session, (Type)((flags & 1L) > 0L ? null : BStationSurrogate.TYPE), null, null);
            BStationSurrogate[] allStations = BStationSurrogate.makeAll((BDaemonSession)session);
            block16: for (int ixStn = 0; ixStn < allStations.length; ++ixStn) {
                if (allStations[ixStn].getStationStatus() == BStationStatus.idle) continue;
                BInstallable[] solutionInstallables = scenario.getToInstall();
                for (int i = 0; i < solutionInstallables.length; ++i) {
                    BPart toInstall = solutionInstallables[i].getPart();
                    if (toInstall == null || !(toInstall instanceof BNrePart)) continue;
                    DaemonPlatformUtil.doExtraStationShutdownTasks((BDaemonPlatform)target, (DaemonSessionTaskListener)listener, null);
                    break block16;
                }
                break;
            }
        }
        Consumer messageInitializer = DaemonClientEncodingInfo.makeMessageInitializer((BDaemonSession)session, Optional.ofNullable(distToInstall.getManifest().getPBEEncodingInfo()), Optional.ofNullable(systemPassphrase));
        boolean ignoreDhcpd = session.getHostProperties().supportsServlet("dhcpd");
        boolean ignoreLink = session.getHostProperties().supportsServlet("linkcfg");
        if ((flags & 0x80000L) == 0L) {
            ignoreDhcpd = true;
            ignoreLink = true;
        }
        scenario.setIgnoreDhcpdTransfer(ignoreDhcpd);
        scenario.setIgnoreLinkTransfer(ignoreLink);
        boolean authReadonly = false;
        try {
            XElem authInfo = XParser.make((InputStream)session.getInputStream((DaemonMessage)new CheckAuthenticationReadonlyMessage(), "text/xml")).parse();
            XElem authElem = authInfo.elem("auth");
            if (authElem != null) {
                authReadonly = authElem.getb("readonly", false);
            }
        }
        catch (Exception authInfo) {
            // empty catch block
        }
        scenario.commit((DaemonSessionTaskListener)listener, new StoreCache(), null, authReadonly, Optional.ofNullable(messageInitializer));
        if ((flags & 0x80000L) > 0L) {
            BTcpIpHostSettings currentHostSettings = new BTcpIpHostSettings();
            TcpUtil.loadFromSession((BTcpIpHostSettings)currentHostSettings, (BDaemonSession)session);
            if (scenario.getTcpIpChanges() != null && !currentHostSettings.getIsReadonly() && !scenario.getTcpIpChanges().getIsReadonly()) {
                log.info("Applying changes to TCP/IP settings");
                TcpUtil.saveToSession((BTcpIpHostSettings)scenario.getTcpIpChanges(), (BDaemonSession)session, (boolean)false);
            }
        }
        if ((flags & 0x20000L) > 0L) {
            log.info("Installing OS Image.");
            session.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 90000);
        }
        if ((flags & 0x10000L) > 0L) {
            log.info("Rebooting remote host.");
            session.sendRebootRequest();
            log.info("Installation complete.");
        } else if ((flags & 0x40000L) > 0L) {
            log.info("Updating daemon binaries");
            session.sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
            log.info("Installation complete.");
        } else {
            log.info("Installation complete.");
            if (stopped.length > 0) {
                for (int i = 0; i < stopped.length; ++i) {
                    if (!stopped[i].isRestartEnabled()) continue;
                    stopped[i].startAppAsync();
                    log.info("Started " + stopped[i].getAppName());
                }
            }
        }
        return retCode;
    }

    private static class Listener
    implements DaemonSessionTaskListener {
        String lastText = null;

        private Listener() {
        }

        public void taskStarted(DaemonSessionTask task) {
            if (!task.getMessage().equals(this.lastText)) {
                System.out.println(task.getMessage());
                this.lastText = task.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask task) {
            this.taskStarted(task);
        }

        public void taskFinished(DaemonSessionTask task) {
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

