/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.util.CommandLineArguments;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBigFilesCommand
extends BDaemonSessionCommand {
    public static final BBigFilesCommand INSTANCE = new BBigFilesCommand();
    public static final Type TYPE = Sys.loadType(BBigFilesCommand.class);

    public Type getType() {
        return TYPE;
    }

    protected BBigFilesCommand() {
    }

    public String getCommandName() {
        return "bigfiles";
    }

    public String getCommandDescription() {
        return "display a list of the largest files on a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BBigFilesCommand.println((String)"", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"usage:", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  plat bigfiles <flags> <dir>", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"required flags:", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  -h:<hostord>       host's ORD", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  <dir>              directory to look under", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  -pwd:<password>    password for the host's platform daemon", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  -size:<size>       size of the listing, default 10", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  -noinput           if given, command will fail when username", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"                       and password are missing or incorrect,", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"                       instead of prompting and reading them", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"                       from stdin", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  -p:<port>          port for the host's platform daemon", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"                       if omitted, default port 3011 is used", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  -locale:<x>        set the default locale (en_US)", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  -@<option>         pass option to Java VM", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"  -buildreg          force rebuild of the registry", (Object[])new Object[0]);
        BBigFilesCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        Item item;
        int i;
        if (args.hasHelpOption() || args.parameters.length != 1) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        TreeSet<Item> results = new TreeSet<Item>();
        this.accum(results, BDaemonDirectoryStore.make((BDaemonFileSpace)session.getFileSpace(), (FilePath)new FilePath(args.parameters[0]), (boolean)true, (boolean)false, (boolean)false, (StoreCache)new StoreCache()));
        int listSize = args.getIntOption("size", 10);
        int pathPad = 0;
        int sizePad = 0;
        Iterator<Item> items = results.iterator();
        for (i = 0; i < listSize && items.hasNext(); ++i) {
            item = items.next();
            pathPad = Math.max(pathPad, item.getPath().length());
            sizePad = Math.max(sizePad, item.getSize().length());
        }
        items = results.iterator();
        for (i = 0; i < listSize && items.hasNext(); ++i) {
            item = items.next();
            System.out.print(TextUtil.pad((String)item.getPath(), (int)pathPad));
            System.out.print("  ");
            System.out.println(TextUtil.padLeft((String)item.getSize(), (int)sizePad));
        }
        return 0;
    }

    private void accum(Set<Item> set, BDaemonDirectoryStore dir) throws Exception {
        if (dir != null) {
            Array kids = dir.getChildren();
            for (int i = 0; i < kids.size(); ++i) {
                if (kids.get(i) instanceof BDaemonFileStore) {
                    set.add(new Item((BDaemonFileStore)kids.get(i)));
                    continue;
                }
                if (!(kids.get(i) instanceof BDaemonDirectoryStore)) continue;
                this.accum(set, (BDaemonDirectoryStore)kids.get(i));
            }
        }
    }

    private static class Item
    implements Comparable<Item> {
        private BDaemonFileStore fileStore;

        public Item(BDaemonFileStore fileStore) {
            this.fileStore = fileStore;
        }

        @Override
        public int compareTo(Item o2) {
            long size2;
            long size1 = this.fileStore.getSize();
            if (size1 < (size2 = o2.fileStore.getSize())) {
                return 1;
            }
            if (size1 > size2) {
                return -1;
            }
            String path1 = this.fileStore.getFilePath().getBody();
            String path2 = o2.fileStore.getFilePath().getBody();
            return path1.compareTo(path2);
        }

        public String getPath() {
            return this.fileStore.getFilePath().getBody();
        }

        public String getSize() {
            return DaemonFileUtil.fileSize((long)this.fileStore.getSize());
        }
    }
}

