/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DaemonPlatformUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCachedDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.AddMemberMessage;
import com.tridium.platform.daemon.message.AddUserMessage;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.CheckAuthenticationReadonlyMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteMemberMessage;
import com.tridium.platform.daemon.message.DeleteUserMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.util.CommandLineArguments;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.BStationStatus;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class BBackupInstallCommand
extends BDaemonSessionCommand {
    public static final BBackupInstallCommand INSTANCE = new BBackupInstallCommand();
    public static final Type TYPE = Sys.loadType(BBackupInstallCommand.class);
    private static Logger log = Logger.getLogger("backupinstall");

    public Type getType() {
        return TYPE;
    }

    protected BBackupInstallCommand() {
    }

    public String getCommandName() {
        return "backupinstall";
    }

    public String getCommandDescription() {
        return "install backup distribution file to a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public boolean includeInCommandListing() {
        return false;
    }

    public void usage() {
        BBackupInstallCommand.println((String)"", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"usage:", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  plat backupinstall <flags> <distfilepath>", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"parameters:", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  distfilepath              FilePath for the distribution file to install", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"required flags:", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -h:<hostord>              ORD for the remote host", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -usr:<userName>           user name for the host's platform daemon", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -pwd:<password>           password for the host's platform daemon", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -syspwd:<password>        system passphrase used to protect this distribution file", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"                              if the target platform is currently protected by the same", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"                              system passphrase as this distribution, this argument is ignored", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -notcp                    if present, the install will not change the", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"                              remote host's TCP/IP settings", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -allowupgrades            if present, the install will attempt to", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"                              use different software than what's specified", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"                              in the backup dist if the backup dist's", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"                              dependencies can't be met exactly", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -p:<port>                 port for the remote host's platform daemon", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"                              if omitted, default port 3011 is used", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -noinput                  if given, command will fail when username", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"                              password, passphrase are missing or incorrect,", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"                              instead of prompting and reading them", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"                              from stdin", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -locale:<x>               set the default locale (en_US)", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -@<option>                pass option to Java VM", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"  -buildreg                 force rebuild of the registry", (Object[])new Object[0]);
        BBackupInstallCommand.println((String)"", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invoke(CommandLineArguments args) throws Exception {
        XElem authElem;
        Array allStations;
        boolean noTcpArg = args.hasOption("notcp");
        boolean allowUpgradesArg = args.hasOption("allowupgrades");
        if (args.hasHelpOption() || args.parameters.length != 1) {
            this.usage();
            return 2;
        }
        String distArg = args.parameters[0];
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        BIFile backupDistFile = BFileSystem.INSTANCE.findFile(new FilePath(distArg));
        if (backupDistFile == null) {
            log.severe(distArg + " not found");
            return 1;
        }
        BDistribution backupDist = new BDistribution(backupDistFile);
        if (!backupDist.getInstallableName().equals("backupdist")) {
            log.severe(distArg + " is not a backup distribution file");
            return 1;
        }
        BRemoteDaemonPlatform targetPlatform = BRemoteDaemonPlatform.make((BDaemonSession)session, (DaemonSessionTaskListener)this);
        targetPlatform.checkSession();
        targetPlatform.loadPreferredVerificationMode();
        if (!targetPlatform.getIsNiagara4()) {
            log.severe("Installing backups to Niagara AX hosts is unsupported");
            return 1;
        }
        PBEEncodingInfo passphraseEncodingInfo = backupDist.getManifest().getPBEEncodingInfo();
        SecretChars systemPassphrase = null;
        boolean systemPassphraseRequired = passphraseEncodingInfo != null && !session.validateSystemPassPhrase((PBEValidator)backupDist.getManifest().getPBEEncodingInfo());
        String systemPassphraseArg = null;
        if (systemPassphraseRequired) {
            systemPassphraseArg = args.getOption("syspwd", null);
            if (systemPassphraseArg != null) {
                try (SecretChars secretChars = SecretChars.fromString((String)systemPassphraseArg);){
                    if (passphraseEncodingInfo.test(secretChars)) {
                        systemPassphraseRequired = false;
                    }
                    if (args.hasOption("noinput")) {
                        log.severe("The incorrect system passphrase (syspwd) for this distribution was provided.");
                        int n = 1;
                        return n;
                    }
                    log.info("The incorrect system passphrase for this distribution was provided.");
                    log.info("Please provide the system passphrase used to create this distribution file to install it.");
                }
            } else {
                if (args.hasOption("noinput")) {
                    log.severe("Target platform does not use the same system passphrase as the distribution file, must provide syspwd argument.");
                    return 1;
                }
                log.info("This distribution file requires a system passphrase for installation.");
                log.info("Please provide the system passphrase used to create this distribution file to install it.");
            }
            while (systemPassphraseRequired) {
                systemPassphraseArg = this.promptString("System Passphrase: ");
                boolean bl = systemPassphraseRequired = !passphraseEncodingInfo.test(SecretChars.fromString((String)systemPassphraseArg));
                if (systemPassphraseRequired) {
                    log.info("Incorrect system passphrase.");
                    continue;
                }
                log.info("System passphrase accepted.");
            }
            systemPassphrase = SecretChars.fromString((String)systemPassphraseArg);
        }
        targetPlatform.getModuleList().init();
        CertificateChainValidator certValidator = CertificateChainValidator.make((ICoreCryptoManager)BPlatCryptoManager.make((BDaemonPlatform)targetPlatform));
        certValidator.setLaxValidation(true);
        InstallScenario scenario = InstallScenario.solve((BDaemonPlatform)targetPlatform, null, (String[])new String[0], (BDependency[])new BDependency[0], (BInstallable[])new BInstallable[]{backupDist}, null, (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)certValidator);
        BCachedDaemonFileSpace fileSpace = new BCachedDaemonFileSpace(session, true, true, false, null, (DaemonSessionTaskListener)this, null, new AutoCloseable[0]);
        FileTransferMessage extraTransfers = new FileTransferMessage((BDaemonFileSpace)fileSpace);
        ZipFile backupDistZip = null;
        if (scenario.getUnmetDependencies().length > 0) {
            XElem[] configDistSvcElems;
            BInstallable[] services;
            if (!allowUpgradesArg) {
                for (int i = 0; i < scenario.getUnmetDependencies().length; ++i) {
                    log.severe("Unmet dependency: " + scenario.getUnmetDependencies()[i]);
                }
                log.info("Use the -allowupgrades option to install this backup with upgraded software");
                return 1;
            }
            backupDistZip = new ZipFile(((BLocalFileStore)backupDistFile.getStore()).getLocalFile());
            ZipEntry zipEntry = backupDistZip.getEntry("META-INF/dist.xml");
            if (zipEntry == null) {
                zipEntry = backupDistZip.getEntry("meta-inf/dist.xml");
            }
            DistributionManifest backupManifest = DistributionManifest.make((InputStream)backupDistZip.getInputStream(zipEntry));
            Array depends = new Array(BDependency.class);
            BDistribution configDist = null;
            IterableCursor c = LocalInstallableRegistry.getInstance().getInstallables(true, null, targetPlatform.getConfigDistFileName());
            while (c.next()) {
                BDistribution configCandidate = (BDistribution)c.get();
                InstallScenario s = InstallScenario.solve((BDaemonPlatform)targetPlatform, null, null, null, (BInstallable[])new BInstallable[]{configCandidate}, null, (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)certValidator);
                if (s.getUnmetDependencies().length != 0) continue;
                configDist = configCandidate;
                break;
            }
            if (configDist == null) {
                log.severe("Can't find a nre-config-*.dist version suitable for the remote host's platform");
                try {
                    backupDistZip.close();
                }
                catch (Exception configCandidate) {
                    // empty catch block
                }
                return 1;
            }
            XElem backupPlatform = backupManifest.getPlatformXml();
            HashMap<String, BInstallable> backupPlatSvcElemsByType = new HashMap<String, BInstallable>();
            for (BInstallable service : services = backupPlatform.elems("p")) {
                String type = service.get("t");
                type = type.substring(type.indexOf(58) + 1);
                backupPlatSvcElemsByType.put(type, service);
            }
            ZipFile configDistZip = new ZipFile(configDist.getLocalInstallableFile());
            zipEntry = configDistZip.getEntry("META-INF/dist.xml");
            if (zipEntry == null) {
                zipEntry = configDistZip.getEntry("meta-inf/dist.xml");
            }
            DistributionManifest configManifest = DistributionManifest.make((InputStream)configDistZip.getInputStream(zipEntry));
            XElem configPlatform = configManifest.getPlatformXml();
            HashSet<String> requiredModules = new HashSet<String>();
            String moduleAttr = configPlatform.get("m", null);
            if (moduleAttr != null) {
                int ixEquals = moduleAttr.indexOf(61);
                if (ixEquals < 0) {
                    requiredModules.add(moduleAttr);
                } else {
                    requiredModules.add(moduleAttr.substring(ixEquals + 1));
                }
            }
            XElem[] platformBogRoot = new XElem("bajaObjectGraph");
            platformBogRoot.addAttr("version", "1.0");
            XElem svcContainerElem = new XElem("p");
            svcContainerElem.addAttr("n", "platform");
            svcContainerElem.addAttr("m", "platform=platform");
            svcContainerElem.addAttr("t", "platform:PlatformServiceContainer");
            platformBogRoot.addContent((XContent)svcContainerElem);
            for (XElem configDistSvcElem : configDistSvcElems = configPlatform.elems()) {
                if (!configDistSvcElem.name().equals("p")) continue;
                moduleAttr = configDistSvcElem.get("m", null);
                if (moduleAttr != null) {
                    int ixEquals = moduleAttr.indexOf(61);
                    if (ixEquals < 0) {
                        requiredModules.add(moduleAttr);
                    } else {
                        requiredModules.add(moduleAttr.substring(ixEquals + 1));
                    }
                }
                String type = configDistSvcElem.get("t");
                XElem backupPlatSvcElem = (XElem)backupPlatSvcElemsByType.get(type = type.substring(type.indexOf(58) + 1));
                if (backupPlatSvcElem != null) {
                    svcContainerElem.addContent((XContent)backupPlatSvcElem.copy());
                    continue;
                }
                svcContainerElem.addContent((XContent)configDistSvcElem.copy());
            }
            ByteArrayOutputStream platformBytes = new ByteArrayOutputStream();
            XWriter xw = new XWriter((OutputStream)platformBytes);
            xw.prolog();
            platformBogRoot.write(xw);
            xw.close();
            BModuleContent newModuleContent = backupManifest.getUpdateModuleContent();
            if (newModuleContent != null && newModuleContent != BModuleContent.runtime) {
                requiredModules.add("converters");
                requiredModules.add("icons");
                requiredModules.add("webChart");
                requiredModules.add("chart");
                requiredModules.add("fonts");
                requiredModules.add("html");
                requiredModules.add("kitPx");
                requiredModules.add("web");
                requiredModules.add("pdf");
                requiredModules.add("wiresheet");
                requiredModules.add("workbench");
                requiredModules.add("jxBrowser");
            }
            Array excludedEntries = new Array(String.class);
            excludedEntries.add((Object)backupManifest.getEntryPath(new FilePath("!defaults/platform.bog")));
            excludedEntries.add((Object)backupManifest.getEntryPath(new FilePath("!defaults/system.properties")));
            excludedEntries.add((Object)backupManifest.getEntryPath(new FilePath("!defaults/nre.properties")));
            excludedEntries.add((Object)backupManifest.getEntryPath(new FilePath("~daemon/daemon.properties")));
            extraTransfers.addElement((FileTransferMessageElement)new ByteArrayFileTransferElement(new FilePath("!defaults/platform.bog"), platformBytes.toByteArray(), (BDaemonFileSpace)fileSpace));
            String stationsPrefix = backupManifest.getEntryPath(SystemFilePaths.getStationsDirPath((BIFileSpace)fileSpace));
            boolean licenseReadonly = targetPlatform.getDaemonSession().getHostProperties().getIsLicenseReadonly();
            Enumeration<? extends ZipEntry> entries = backupDistZip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry backupEntry = entries.nextElement();
                String[] entryPath = this.getEntryDestPath(backupManifest.useAbsoluteElementPaths(), backupEntry.getName());
                int exclude = backupEntry.getName().toLowerCase().startsWith("meta-inf");
                if (licenseReadonly && (entryPath.getBody().endsWith(".license") || entryPath.getBody().endsWith(".certificate"))) {
                    exclude = 1;
                } else if (entryPath.getName().endsWith(".license")) {
                    InputStream elemIn = backupDistZip.getInputStream(backupEntry);
                    try {
                        XElem licenseElem = XParser.make((InputStream)elemIn).parse();
                        LicenseInfo licenseInfo = new LicenseInfo(licenseElem);
                        if (!session.getHostProperties().getHostId().equals(licenseInfo.vendorLicense.getHostId())) {
                            exclude = 1;
                        }
                    }
                    catch (Exception e) {
                        exclude = 1;
                    }
                    elemIn.close();
                }
                for (int ixExclude = 0; exclude == 0 && ixExclude < excludedEntries.size(); ++ixExclude) {
                    if (!backupEntry.getName().equals(excludedEntries.get(ixExclude))) continue;
                    exclude = 1;
                }
                if (exclude != 0) continue;
                if (configManifest.useAbsoluteElementPaths() || entryPath.isSysHomeAbsolute()) {
                    extraTransfers.addElement((FileTransferMessageElement)new ZipTransferElement((FilePath)entryPath, (BDaemonFileSpace)fileSpace, backupDistZip, backupEntry));
                }
                if (!backupEntry.getName().startsWith(stationsPrefix) || !backupEntry.getName().endsWith("/config.bog")) continue;
                InputStream configIn = backupDistZip.getInputStream(backupEntry);
                try {
                    XElem stationBog = XParser.make((InputStream)configIn).parse();
                    this.accumBogModuleDeps(requiredModules, stationBog);
                }
                finally {
                    try {
                        configIn.close();
                    }
                    catch (Exception stationBog) {}
                }
            }
            for (String requiredModule : requiredModules) {
                depends.add((Object)BDependency.forModule((String)requiredModule));
            }
            BTimeZone newTz = backupDist.getNewOsTimeZone();
            if (!TimeZoneUtil.isSupported((BTimeZone)newTz, (BDstSupportLevel)session.getHostProperties().getTimezoneDayModeSupport())) {
                newTz = BTimeZone.NULL;
            }
            TreeSet<RuntimeProfile> updatedProfiles = new TreeSet<RuntimeProfile>();
            if (backupDist.getUpdateRuntimeProfilesEnabled()) {
                for (String profileName : backupDist.getEnabledRuntimeProfileNames().split(",")) {
                    updatedProfiles.add(RuntimeProfile.valueOf((String)profileName));
                }
            }
            scenario = new InstallScenario((BDaemonPlatform)targetPlatform, new String[]{}, (BDependency[])depends.trim(), new BInstallable[]{configDist}, newTz, backupDist.getTcpIpChanges(), backupDist.getUpdateModuleContent() ? backupDist.getNewModuleContent() : null, updatedProfiles, new SolutionParameters(null), (InstallableRegistry)LocalInstallableRegistry.getInstance(), certValidator).solve();
            if ((scenario = InstallScenario.upgradeOutOfDate((InstallScenario)scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance())).getUnmetDependencies().length > 0) {
                for (int i = 0; i < scenario.getUnmetDependencies().length; ++i) {
                    log.severe("Unmet dependency: " + scenario.getUnmetDependencies()[i]);
                }
                return 1;
            }
        }
        BAppSurrogate[] stoppedApps = BAppSurrogate.stopAllApps((BDaemonSession)session, null, null, (DaemonSessionTaskListener)this);
        block37: for (BStationSurrogate station : allStations = BStationSurrogate.makeAll((BDaemonSession)session)) {
            BInstallable[] solutionInstallables;
            if (station.getStationStatus() == BStationStatus.idle) continue;
            for (BInstallable solutionInstallable : solutionInstallables = scenario.getToInstall()) {
                BPart toInstall = solutionInstallable.getPart();
                if (toInstall == null || !(toInstall instanceof BNrePart)) continue;
                DaemonPlatformUtil.doExtraStationShutdownTasks((BDaemonPlatform)targetPlatform, (DaemonSessionTaskListener)this, null);
                break block37;
            }
            break;
        }
        Consumer messageInitializer = DaemonClientEncodingInfo.makeMessageInitializer((BDaemonSession)session, Optional.ofNullable(backupDist.getManifest().getPBEEncodingInfo()), Optional.ofNullable(systemPassphrase));
        boolean ignoreDhcpd = session.getHostProperties().supportsServlet("dhcpd");
        boolean ignoreLink = session.getHostProperties().supportsServlet("linkcfg");
        if (noTcpArg) {
            ignoreDhcpd = true;
            ignoreLink = true;
        }
        scenario.setIgnoreDhcpdTransfer(ignoreDhcpd);
        scenario.setIgnoreLinkTransfer(ignoreLink);
        boolean authReadonly = false;
        try {
            XElem authInfo = XParser.make((InputStream)session.getInputStream((DaemonMessage)new CheckAuthenticationReadonlyMessage(), "text/xml")).parse();
            authElem = authInfo.elem("auth");
            if (authElem != null) {
                authReadonly = authElem.getb("readonly", false);
            }
        }
        catch (Exception authInfo) {
            // empty catch block
        }
        scenario.commit((DaemonSessionTaskListener)this, fileSpace.getCache(), null, authReadonly, Optional.ofNullable(messageInitializer));
        DaemonFileUtil.transfer((BDaemonSession)session, (FileTransferMessage)extraTransfers, null, (DaemonSessionTaskListener)this);
        if (backupDistZip != null) {
            backupDistZip.close();
        }
        if (!noTcpArg) {
            BTcpIpHostSettings currentHostSettings = new BTcpIpHostSettings();
            TcpUtil.loadFromSession((BTcpIpHostSettings)currentHostSettings, (BDaemonSession)session);
            if (scenario.getTcpIpChanges() != null && !currentHostSettings.getIsReadonly() && !scenario.getTcpIpChanges().getIsReadonly()) {
                log.info("Applying changes to TCP/IP settings");
                TcpUtil.saveToSession((BTcpIpHostSettings)scenario.getTcpIpChanges(), (BDaemonSession)session, (boolean)false);
            }
        }
        if ((scenario.getProcessingFlags() & 0x20000L) > 0L) {
            log.info("Updating OS Image");
            session.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 90000);
        }
        if (backupDist.getManifest().getPlatformUsersXml() != null && session.getHostProperties().hasFullAccess() && session.getHostProperties().supportsServlet("acctmgt")) {
            XElem authenticationInfo = XParser.make((InputStream)session.getInputStream((DaemonMessage)new AuthenticationInfoMessage())).parse();
            authElem = authenticationInfo.elem("auth");
            if (!authReadonly) {
                XElem[] remoteGroups;
                XElem adminGroupElement = authElem.elem("admingroup");
                GroupAccount adminGroup = new GroupAccount(adminGroupElement.get("name"), adminGroupElement.get("id", null));
                XElem accountInfo = XParser.make((InputStream)session.getInputStream((DaemonMessage)new AccountManagementMessage())).parse();
                ArrayList<UserAccount> usersToRemove = new ArrayList<UserAccount>();
                for (XElem currentGroup : remoteGroups = accountInfo.elems("group")) {
                    if (!currentGroup.get("name").equals(adminGroup.getFullyQualifiedName())) continue;
                    XElem[] adminUsers = currentGroup.elems("user");
                    for (XElem adminUser : adminUsers) {
                        usersToRemove.add(new UserAccount(adminUser.get("name"), adminUser.get("id", null), adminUser.get("description"), null));
                    }
                }
                BUsernameAndPassword sessionCred = (BUsernameAndPassword)session.getCredentials();
                String currentUserName = NativeAccount.fullyQualifiedToUsername((String)sessionCred.getUsername());
                ArrayList<UserAccount> usersToAdd = new ArrayList<UserAccount>();
                XElem platformUsers = backupDist.getManifest().getPlatformUsersXml();
                XElem[] backupUsers = platformUsers.elems("user");
                for (XElem backupUser : backupUsers) {
                    UserAccount userToAdd;
                    String passwordHashAttribute = backupUser.get("passwordHash");
                    if (!session.getHostProperties().getIsNpsdk()) {
                        boolean validBase64;
                        String[] hashSegments;
                        String passwordHash = null;
                        boolean validHash = false;
                        if (passwordHashAttribute != null && passwordHashAttribute.startsWith("@") && (hashSegments = TextUtil.split((String)passwordHashAttribute.substring(1), (char)'@')).length == 3) {
                            passwordHash = hashSegments[1];
                            validHash = true;
                        }
                        if (!validHash) {
                            log.warning("NOTICE: Can not restore user \"" + backupUser.get("name") + "\", password is not a recognized hash scheme.");
                            continue;
                        }
                        try {
                            Base64.getDecoder().decode(passwordHash);
                            validBase64 = true;
                        }
                        catch (Exception ignored) {
                            validBase64 = false;
                        }
                        if (!validBase64) {
                            log.warning("NOTICE: Can not restore user \"" + backupUser.get("name") + "\", password is hashed using deprecated scheme.");
                            continue;
                        }
                    }
                    if ((userToAdd = new UserAccount(backupUser.get("name"), null, backupUser.get("description"), LegacyStorageUtil.encode((String)backupUser.get("passwordHash"), (int)0))).getAccountName().equalsIgnoreCase(currentUserName)) continue;
                    if (usersToAdd.size() >= 19) {
                        log.warning("NOTICE: Can not restore user \"" + userToAdd.getAccountName() + "\", would exceed maximum platform user count (20))");
                        continue;
                    }
                    usersToAdd.add(userToAdd);
                }
                for (UserAccount userToRemove : usersToRemove) {
                    if (userToRemove.getAccountName().equalsIgnoreCase(currentUserName)) continue;
                    session.sendMessage((DaemonMessage)new DeleteMemberMessage(adminGroup, userToRemove));
                    session.sendMessage((DaemonMessage)new DeleteUserMessage(userToRemove));
                }
                for (UserAccount userToAdd : usersToAdd) {
                    AddUserMessage addUserMessage = new AddUserMessage(userToAdd, true);
                    addUserMessage.setSharedKey(session.generateSharedSecretKey("backupInstall_addUser"));
                    session.sendMessage((DaemonMessage)addUserMessage);
                    session.sendMessage((DaemonMessage)new AddMemberMessage(adminGroup, userToAdd));
                }
            } else {
                log.fine("skipping user account restore because target user readonly authentication");
            }
        }
        boolean mustReboot = (scenario.getProcessingFlags() & 0x10000L) > 0L;
        boolean startStations = false;
        if (stoppedApps.length > 0) {
            if (!session.getHostProperties().getAllowStationRestart()) {
                startStations = true;
            } else {
                mustReboot = true;
            }
        }
        if (mustReboot) {
            log.info("Rebooting the remote host");
            session.sendRebootRequest();
        } else if ((scenario.getProcessingFlags() & 0x40000L) > 0L) {
            log.info("Restarting the platform daemon");
            session.sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
        } else if (startStations) {
            for (BAppSurrogate stoppedApp : stoppedApps) {
                log.info("Starting  " + stoppedApp.toString(null));
                stoppedApp.startAppAsync();
            }
        }
        log.info("Installation complete");
        return 0;
    }

    private void accumBogModuleDeps(Set<String> accum, XElem bogElem) throws Exception {
        XElem[] kids;
        String moduleAttr;
        if (bogElem.name().equals("p") && (moduleAttr = bogElem.get("m", null)) != null) {
            int ixEquals = moduleAttr.indexOf(61);
            if (ixEquals < 0) {
                accum.add(moduleAttr);
            } else {
                accum.add(moduleAttr.substring(ixEquals + 1));
            }
        }
        for (XElem kid : kids = bogElem.elems()) {
            this.accumBogModuleDeps(accum, kid);
        }
    }

    private FilePath getEntryDestPath(boolean absoluteElementPaths, String entryName) {
        if (absoluteElementPaths) {
            FilePath result = entryName.charAt(0) == '/' ? new FilePath(entryName) : new FilePath("/" + entryName);
            if (result.nameAt(0).equals("niagara")) {
                FilePath src = result;
                result = new FilePath("~");
                for (int i = 1; i < src.depth(); ++i) {
                    result = result.merge(src.nameAt(i));
                }
            }
            return result;
        }
        if (entryName.charAt(0) == '/') {
            return new FilePath("~" + entryName.substring(1));
        }
        return new FilePath("~" + entryName);
    }

    private static class ZipTransferElement
    extends FileTransferMessageElement {
        private final ZipFile zipFile;
        private final ZipEntry zipEntry;

        public ZipTransferElement(FilePath path, BDaemonFileSpace fileSpace, ZipFile zipFile, ZipEntry zipEntry) {
            super(path, fileSpace);
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        public InputStream getStream() throws IOException {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        public long getSize() {
            return this.zipEntry.getSize();
        }
    }
}

