/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.event;

import com.tridium.driver.util.DrUtil;
import com.tridium.maxpro.camera.BMaxproCamera;
import com.tridium.maxpro.camera.BMaxproCameraDeviceId;
import com.tridium.maxpro.enums.BMaxproEventTypesEnum;
import com.tridium.maxpro.event.BMaxproAlarmExt;
import com.tridium.maxpro.event.BMaxproBooleanChangeOfStateAlgorithm;
import com.tridium.maxpro.event.BMaxproEventCameraExt;
import com.tridium.maxpro.nvr.BMaxproNvr;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nvideo.event.BVideoEventProxyExt;
import com.tridium.nvideo.event.BVideoEventStatus;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="maxproEventTypeEnum", type="BMaxproEventTypesEnum", defaultValue="BMaxproEventTypesEnum.motionDetected", flags=1, facets={@Facet(value="SfUtil.incl()")})
public class BMaxproEventProxyExt
extends BVideoEventProxyExt {
    public static final Property maxproEventTypeEnum = BMaxproEventProxyExt.newProperty((int)1, (BValue)BMaxproEventTypesEnum.motionDetected, (BFacets)SfUtil.incl());
    public static final Type TYPE = Sys.loadType(BMaxproEventProxyExt.class);

    public BMaxproEventTypesEnum getMaxproEventTypeEnum() {
        return (BMaxproEventTypesEnum)this.get(maxproEventTypeEnum);
    }

    public void setMaxproEventTypeEnum(BMaxproEventTypesEnum v) {
        this.set(maxproEventTypeEnum, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BMaxproEventCameraExt.TYPE;
    }

    public BVideoEventTypesEnum getEventTypeEnum() {
        if (this.getMaxproEventTypeEnum() == BMaxproEventTypesEnum.motionDetected) {
            return BVideoEventTypesEnum.motionStarted;
        }
        if (this.getMaxproEventTypeEnum() == BMaxproEventTypesEnum.cameraFail) {
            return BVideoEventTypesEnum.fault;
        }
        return BVideoEventTypesEnum.nullEvent;
    }

    public void videoProxyExtStarted() {
        super.videoProxyExtStarted();
        BMaxproNvr dvr = (BMaxproNvr)DrUtil.getParent((BComplex)this, (Type)BMaxproNvr.TYPE);
        dvr.registerEventProxy(this, this.getMaxproEventTypeEnum());
        if (this.getMaxproEventTypeEnum() == BMaxproEventTypesEnum.motionDetected) {
            BMaxproAlarmExt alarmExt = new BMaxproAlarmExt();
            alarmExt.setOffnormalAlgorithm((BOffnormalAlgorithm)new BMaxproBooleanChangeOfStateAlgorithm());
            BControlPoint event = (BControlPoint)this.getParent();
            if (((BMaxproAlarmExt[])event.getChildren(BMaxproAlarmExt.class)).length <= 0) {
                event.add(null, (BValue)alarmExt);
            }
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        BMaxproNvr dvr = (BMaxproNvr)DrUtil.getParent((BComplex)this, (Type)BMaxproNvr.TYPE);
        dvr.unregisterEventProxy(this, this.getMaxproEventTypeEnum());
    }

    protected void implEnableDetection(boolean on) throws Exception {
        if (this.getEventTypeEnum() != BVideoEventTypesEnum.motionStarted) {
            throw new BajaRuntimeException("Can only control event detection for 'motionStarted' events, not " + this.getEventTypeEnum() + ". Please have my program fixed.");
        }
    }

    public void readSubscribed(Context cx) throws Exception {
    }

    public void readUnsubscribed(Context cx) throws Exception {
    }

    public boolean write(Context cx) throws Exception {
        throw new BajaRuntimeException("BMaxproEventProxyExt " + this.getDisplayName(cx) + " is not writeable");
    }

    public int getCameraId() throws Exception {
        BMaxproCamera cam = (BMaxproCamera)this.getVideoCamera();
        return ((BMaxproCameraDeviceId)cam.getVideoDeviceId()).getCameraId();
    }

    public void updateMotion(boolean motionDetected, BAbsTime cameraTime) {
        BVideoEvent videoEvent;
        BDynamicEnum e = BDynamicEnum.make((BEnum)BMaxproEventTypesEnum.motionDetected);
        if (motionDetected) {
            videoEvent = BVideoEvent.makeMotionStarted();
            videoEvent.setTimestamp(cameraTime);
            videoEvent.setDescription("VMD " + this.getVideoCamera().getCameraDescription());
        } else {
            videoEvent = BVideoEvent.makeMotionStopped();
            videoEvent.setMetaData(BFacets.make((String)"MaxproEventType", (BIDataValue)e));
            videoEvent.setTimestamp(cameraTime);
        }
        BVideoEventStatus eventStaus = new BVideoEventStatus(videoEvent);
        this.readOk((BStatusValue)eventStaus);
    }

    public void updateCameraFail(boolean cameraFail, BAbsTime cameraTime) {
        BDynamicEnum e;
        BVideoEvent videoEvent;
        if (cameraFail) {
            videoEvent = BVideoEvent.makeOffNormalEvent();
            videoEvent.setEventType(BVideoEventTypesEnum.fault);
            e = BDynamicEnum.make((BEnum)BMaxproEventTypesEnum.cameraFail);
            videoEvent.setMetaData(BFacets.make((String)"MaxproEventType", (BIDataValue)e));
            videoEvent.setDescription(BMaxproEventTypesEnum.cameraFail.getDisplayTag(null));
            videoEvent.setTimestamp(cameraTime);
        } else {
            videoEvent = BVideoEvent.makeNormalEvent();
            videoEvent.setEventType(BVideoEventTypesEnum.fault);
            e = BDynamicEnum.make((BEnum)BMaxproEventTypesEnum.cameraRestored);
            videoEvent.setMetaData(BFacets.make((String)"MaxproEventType", (BIDataValue)e));
            videoEvent.setDescription(BMaxproEventTypesEnum.cameraRestored.getDisplayTag(null));
            videoEvent.setTimestamp(cameraTime);
        }
        BVideoEventStatus eventStaus = new BVideoEventStatus(videoEvent);
        this.readOk((BStatusValue)eventStaus);
    }
}

