/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.event;

import com.tridium.maxpro.event.BMaxproBooleanChangeOfStateAlgorithm;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BAlarmTimestamps;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BDiscretePoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="triggerAlarm", flags=4)
public class BMaxproAlarmExt
extends BAlarmSourceExt {
    public static final Topic toNormal = BMaxproAlarmExt.newTopic((int)0, null);
    public static final Action triggerAlarm = BMaxproAlarmExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BMaxproAlarmExt.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"control/controlExtension.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private static final int NON_ALARM_BITS = -139;
    private Clock.Ticket ticket;
    private Clock.Ticket inhibitTicket;
    private long timeOfLastStateChange = 0L;
    private AlarmSupport support;
    private boolean unackedAlarm = false;
    private BAbsTime lastOffnormalTime = BAbsTime.NULL;
    private BAbsTime lastFaultTime = BAbsTime.NULL;
    private BAbsTime lastToNormalTime = BAbsTime.NULL;
    private BAbsTime lastAckTime = BAbsTime.NULL;
    private static Logger log = Logger.getLogger("alarm");
    private boolean atSteadyState = false;
    BAbsTime alarmTime;

    public void triggerAlarm() {
        this.invoke(triggerAlarm, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
        this.timeOfLastStateChange = Clock.ticks();
        this.initScheduler();
        if (Sys.atSteadyState()) {
            this.atSteadyState = true;
        }
    }

    public void atSteadyState() throws Exception {
        this.atSteadyState = true;
        this.executePoint();
    }

    public boolean requiresPointSubscription() {
        return this.getAlarmEnable().isToOffnormal() || this.getAlarmEnable().isToFault();
    }

    public void checkPointSubscription() {
        BControlPoint point = this.getParentPoint();
        if (point != null) {
            point.checkExtensionsRequireSubscription();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        if (parent instanceof BControlPoint) {
            if (!this.getOffnormalAlgorithm().isGrandparentLegal(parent)) {
                return false;
            }
            return this.getFaultAlgorithm().isGrandparentLegal(parent);
        }
        return false;
    }

    protected boolean isSiblingLegal(BComponent sibling) {
        return true;
    }

    private void initScheduler() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)10000L), (Action)timerExpired, (BValue)null);
    }

    public BOrdList getSourceOrd() {
        return this.support.getSourceOrd();
    }

    public void doTimerExpired() {
        this.setTimeInCurrentState(BRelTime.make((long)(Clock.ticks() - this.timeOfLastStateChange)));
    }

    public void setAlarmTime(BAbsTime time) {
        this.alarmTime = time;
    }

    public void doTriggerAlarm() {
        BStatusBoolean val = ((BBooleanPoint)this.getParent()).getOut();
        this.onExecute((BStatusValue)val, null);
    }

    public void doInhibitTimerExpired() {
        this.inhibitTicket = null;
        this.checkPointSubscription();
        this.executePoint();
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        if (!this.isRunning()) {
            return BBoolean.make((boolean)false);
        }
        try {
            boolean validAck = this.support.ackAlarm(ackRequest);
            this.lastAckTime = ackRequest.getAckTime();
            BSourceState state = ackRequest.getAlarmTransition();
            if (validAck) {
                BAlarmTransitionBits ackedTrans = this.getAckedTransitions();
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)ackedTrans, (BAlarmTransitionBits)state.getAlarmTransitionBits(), (boolean)true));
                ackedTrans = this.getAckedTransitions();
                state = ackRequest.getSourceState();
                if (state == BSourceState.normal) {
                    this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)ackedTrans, (BAlarmTransitionBits)state.getAlarmTransitionBits(), (boolean)true));
                }
                BAlarmTimestamps alarmTimes = null;
                BSourceState initialState = ackRequest.getAlarmTransition();
                if (initialState == BSourceState.offnormal) {
                    alarmTimes = this.getToOffnormalTimes();
                } else if (initialState == BSourceState.fault) {
                    alarmTimes = this.getToFaultTimes();
                }
                if (alarmTimes != null && !alarmTimes.getAlarmTime().isNull()) {
                    alarmTimes.setAckTime(ackRequest.getAckTime());
                }
            }
            if (validAck && this.getStatus().isUnackedAlarm()) {
                this.setStatus(BStatus.makeUnackedAlarm((BStatus)this.getStatus(), (boolean)false));
            }
            this.executePoint();
            return BBoolean.make((boolean)validAck);
        }
        catch (Exception var7) {
            var7.printStackTrace();
            return BBoolean.make((boolean)false);
        }
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (this.isRunning() && this.atSteadyState) {
            boolean isWorkingVariableAlarm = out.getStatus().isAlarm();
            boolean isWorkingVariableFault = out.getStatus().isFault();
            this.checkAlarms(out);
            String inhibitFacet = Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("alarm.alarmInhibit.facet");
            BStatus s = out.getStatus();
            if (this.inhibitTicket != null && !this.inhibitTicket.isExpired()) {
                if (!this.getAlarmInhibit().getBoolean() && !this.isTimerActive()) {
                    this.setStatus(BStatus.make((BStatus)this.getStatus(), (String)inhibitFacet, (boolean)true));
                } else {
                    this.checkFacets(inhibitFacet);
                }
            } else if (!this.getAlarmInhibit().getBoolean() && !this.isTimerActive()) {
                this.checkFacets(inhibitFacet);
            } else {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (String)inhibitFacet, (boolean)true));
            }
            BControlPoint point = this.getParentPoint();
            BMaxproAlarmExt[] ext = (BMaxproAlarmExt[])point.getChildren(BMaxproAlarmExt.class);
            int bits = out.getStatus().getBits() & 0xFFFFFF75;
            boolean hasInhibit = false;
            for (int i = 0; i < ext.length; ++i) {
                bits |= ext[i].getStatus().getBits();
                if (ext[i].getStatus().getb(inhibitFacet, false)) {
                    hasInhibit = true;
                }
                if (ext[i] == this) break;
            }
            if (hasInhibit) {
                out.setStatus(BStatus.make((int)bits, (BFacets)BFacets.make((BFacets)out.getStatus().getFacets(), (String)inhibitFacet, (BIDataValue)BBoolean.TRUE)));
            } else {
                try {
                    if (out.getStatus().getFacets().encodeToString().contains(inhibitFacet)) {
                        out.setStatus(BStatus.make((int)bits, (BFacets)BFacets.makeRemove((BFacets)out.getStatus().getFacets(), (String)inhibitFacet)));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (isWorkingVariableAlarm) {
                out.setStatusInAlarm(true);
            }
            if (isWorkingVariableFault) {
                out.setStatusFault(true);
            }
        }
    }

    private void checkFacets(String inhibitFacet) {
        try {
            if (this.getStatus().getFacets().encodeToString().contains(inhibitFacet)) {
                this.setStatus(BStatus.make((int)this.getStatus().getBits(), (BFacets)BFacets.makeRemove((BFacets)this.getStatus().getFacets(), (String)inhibitFacet)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (this.isRunning()) {
            if (p.equals(alarmClass) && this.support != null) {
                this.support.setAlarmClass(this.getAlarmClass());
            } else if (p.equals(timeDelay)) {
                this.executePoint();
            } else if (p.equals(alarmInhibit)) {
                this.checkPointSubscription();
                if (this.getInhibitTime().getMillis() > 0L) {
                    if (this.inhibitTicket != null) {
                        this.inhibitTicket.cancel();
                    }
                    if (!this.getAlarmInhibit().getBoolean()) {
                        this.inhibitTicket = Clock.schedule((BComponent)this, (BRelTime)this.getInhibitTime(), (Action)inhibitTimerExpired, (BValue)null);
                    } else if (this.getParent() instanceof BDiscretePoint) {
                        this.inhibitTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)(this.getInhibitTime().getMillis() * 3L)), (Action)inhibitTimerExpired, (BValue)null);
                    }
                } else {
                    this.executePoint();
                }
            } else if (p.equals(alarmEnable)) {
                this.checkPointSubscription();
                this.executePoint();
            }
        }
    }

    protected boolean isTimerActive() {
        try {
            return !((BMaxproBooleanChangeOfStateAlgorithm)this.getOffnormalAlgorithm()).isTimerExpired();
        }
        catch (IllegalStateException var2) {
            return false;
        }
    }

    protected boolean isInhibitTimerActive() {
        try {
            return this.inhibitTicket != null && !this.inhibitTicket.isExpired();
        }
        catch (IllegalStateException var2) {
            return false;
        }
    }

    protected void checkAlarms(BStatusValue out) {
        BAlarmState newAlarmState = null;
        BAlarmState alarmState = this.getAlarmState();
        if (Sys.getService((Type)BAlarmService.TYPE) != null && !out.getStatus().isDisabled() && !out.getStatus().isStale()) {
            boolean useInhibit;
            boolean bl = useInhibit = this.getInhibitTime().getMillis() == 0L && this.getAlarmInhibit().getBoolean() || (this.inhibitTicket == null || this.inhibitTicket.isExpired()) && this.getAlarmInhibit().getBoolean() || this.inhibitTicket != null && !this.inhibitTicket.isExpired() && !this.getAlarmInhibit().getBoolean();
            if (useInhibit) {
                if (alarmState != BAlarmState.normal) {
                    newAlarmState = BAlarmState.normal;
                }
            } else {
                if (this.getAlarmEnable().isToFault()) {
                    newAlarmState = this.getFaultAlgorithm().checkFault(out);
                }
                if (alarmState == BAlarmState.fault && !this.getAlarmEnable().isToFault()) {
                    newAlarmState = BAlarmState.normal;
                }
                if (newAlarmState != BAlarmState.fault && this.getAlarmEnable().isToOffnormal()) {
                    if (newAlarmState == null) {
                        if (alarmState != BAlarmState.fault) {
                            newAlarmState = this.getOffnormalAlgorithm().checkAlarmState(out, this.getTimeDelay().getMillis(), this.getTimeDelayToNormal().getMillis());
                        }
                    } else if (newAlarmState == BAlarmState.normal && (newAlarmState = this.getOffnormalAlgorithm().checkAlarmState(out, this.getTimeDelay().getMillis(), this.getTimeDelayToNormal().getMillis())) == null) {
                        newAlarmState = BAlarmState.normal;
                    }
                }
                if (alarmState.isOffnormal() && !this.getAlarmEnable().isToOffnormal()) {
                    newAlarmState = BAlarmState.normal;
                }
            }
            boolean ackRequired = true;
            if (newAlarmState != null) {
                if (this.getAlarmEnable().isToOffnormal() && newAlarmState.isInAlarm()) {
                    this.setStatus(BStatus.makeAlarm((BStatus)this.getStatus(), (boolean)true));
                } else if (!newAlarmState.isInAlarm()) {
                    this.setStatus(BStatus.makeAlarm((BStatus)this.getStatus(), (boolean)false));
                }
                if (this.getAlarmEnable().isToFault() && newAlarmState == BAlarmState.fault) {
                    this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                } else if (newAlarmState != BAlarmState.fault) {
                    this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
                }
                if (newAlarmState != BAlarmState.normal) {
                    ackRequired = newAlarmState == BAlarmState.fault ? this.alarmStateTransition(BSourceState.fault, BAlarmState.fault, out) : this.alarmStateTransition(BSourceState.offnormal, newAlarmState, out);
                } else {
                    ackRequired = this.alarmStateTransition(BSourceState.normal, BAlarmState.normal, out);
                    if (alarmState.isOffnormal()) {
                        ackRequired = ackRequired || this.support.isAckRequired(BSourceState.offnormal);
                    } else if (alarmState.isInAlarm()) {
                        ackRequired = ackRequired || this.support.isAckRequired(BSourceState.fault);
                    }
                }
                this.setAlarmState(newAlarmState);
                this.timeOfLastStateChange = Clock.ticks();
                this.setTimeInCurrentState(BRelTime.DEFAULT);
                this.unackedAlarm = ackRequired;
            } else {
                if (this.getAlarmEnable().isToOffnormal()) {
                    this.setStatus(BStatus.makeAlarm((BStatus)this.getStatus(), (boolean)alarmState.isInAlarm()));
                }
                if (this.getAlarmEnable().isToFault()) {
                    this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (alarmState == BAlarmState.fault ? 1 : 0) != 0));
                }
                this.setTimeInCurrentState(BRelTime.make((long)(Clock.ticks() - this.timeOfLastStateChange)));
            }
            BAlarmTransitionBits ackedTrans = this.getAckedTransitions();
            if (this.getAlarmEnable().isToOffnormal() || this.getAlarmEnable().isToFault()) {
                if (!(ackedTrans.isToOffnormal() && ackedTrans.isToFault() && ackedTrans.isToNormal() || !ackRequired)) {
                    this.setStatus(BStatus.makeUnackedAlarm((BStatus)this.getStatus(), (boolean)true));
                } else {
                    this.setStatus(BStatus.makeUnackedAlarm((BStatus)this.getStatus(), (boolean)false));
                }
            }
            if ((alarmState == BAlarmState.lowLimit || alarmState == BAlarmState.highLimit) && newAlarmState == BAlarmState.normal) {
                this.checkAlarms(out);
            }
        }
    }

    private boolean alarmStateTransition(BSourceState sourceState, BAlarmState newAlarmState, BStatusValue out) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object msgText = null;
        BOrd ord = BOrd.NULL;
        Property alarmTimesProp = null;
        boolean alarmsNdx = false;
        ord = this.getHyperlinkOrd();
        if (sourceState == BSourceState.offnormal) {
            map.put("offnormalValue", BString.make((String)out.valueToString((Context)this.getPointFacets())));
            map.put("alarmValue", (BIDataValue)out.getValueValue());
        } else if (sourceState == BSourceState.fault) {
            map.put("faultValue", BString.make((String)out.valueToString((Context)this.getPointFacets())));
            map.put("alarmValue", (BIDataValue)out.getValueValue());
        }
        map.put("presentValue", BString.make((String)out.valueToString((Context)this.getPointFacets())));
        map.put("fromState", BString.make((String)this.getAlarmState().getTag()));
        map.put("toState", BString.make((String)newAlarmState.getTag()));
        map.put("sourceName", BString.make((String)this.getSourceName().format((Object)this)));
        if (!ord.isNull()) {
            map.put("hyperlinkOrd", BString.make((String)ord.toString()));
        }
        if (!this.getSoundFile().isNull()) {
            map.put("soundFile", BString.make((String)this.getSoundFile().toString()));
        }
        if (!this.getAlarmIcon().isNull()) {
            map.put("icon", BString.make((String)this.getAlarmIcon().toString()));
        }
        try {
            if (!this.getAlarmInstructions().equals((Object)BAlarmInstructions.NULL)) {
                map.put("instructions", BString.make((String)this.getAlarmInstructions().encodeToString()));
            }
        }
        catch (Exception var16) {
            log.log(Level.SEVERE, "Could not encode Alarm Instructions", var16);
        }
        BFacets alarmMetaData = this.getMetaData();
        String[] keys = alarmMetaData.list();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], (BIDataValue)alarmMetaData.get(keys[i]));
        }
        if (sourceState == BSourceState.normal) {
            map.put("msgText", BString.make((String)this.getToNormalText().getFormat()));
            if (this.getAlarmState().isInAlarm()) {
                this.getOffnormalAlgorithm().writeAlarmData(out, map);
            } else {
                this.getFaultAlgorithm().writeAlarmData(out, map);
            }
        } else if (sourceState == BSourceState.offnormal) {
            map.put("msgText", BString.make((String)this.getToOffnormalText().getFormat()));
            map.put(BAlarmTimestamps.count.getDefaultDisplayName((Context)null), BInteger.make((int)(this.getToOffnormalTimes().getCount() + 1)));
            this.getOffnormalAlgorithm().writeAlarmData(out, map);
            alarmTimesProp = toOffnormalTimes;
        } else {
            if (sourceState != BSourceState.fault) {
                throw new IllegalStateException();
            }
            map.put("msgText", BString.make((String)this.getToFaultText().getFormat()));
            map.put(BAlarmTimestamps.count.getDefaultDisplayName((Context)null), BInteger.make((int)(this.getToFaultTimes().getCount() + 1)));
            this.getFaultAlgorithm().writeAlarmData(out, map);
            alarmTimesProp = toFaultTimes;
        }
        boolean ackRequired = false;
        try {
            ackRequired = this.support.isAckRequired(sourceState);
            BAlarmRecord rec = null;
            if (sourceState == BSourceState.normal) {
                this.support.toNormal(BFacets.make(map), (Context)null);
            } else if (sourceState == BSourceState.offnormal) {
                rec = this.support.newOffnormalAlarm(BFacets.make(map));
                rec.setTimestamp(this.alarmTime);
                this.lastOffnormalTime = rec.getTimestamp();
                this.fireToOffnormal(rec);
            } else if (sourceState == BSourceState.fault) {
                rec = this.support.newFaultAlarm(BFacets.make(map));
                this.lastFaultTime = rec.getTimestamp();
                this.fireToFault(rec);
            }
            if (rec != null) {
                BAlarmTimestamps alarmTimes;
                if (sourceState == BSourceState.normal) {
                    alarmTimes = this.getToOffnormalTimes();
                    if (!alarmTimes.getAlarmTime().isNull()) {
                        alarmTimes.setNormalTime(rec.getNormalTime());
                    }
                    if (!(alarmTimes = this.getToFaultTimes()).getAlarmTime().isNull()) {
                        alarmTimes.setNormalTime(rec.getNormalTime());
                    }
                }
                if (alarmTimesProp != null) {
                    alarmTimes = (BAlarmTimestamps)this.get(alarmTimesProp);
                    alarmTimes.setAlarmTime(rec.getTimestamp());
                    alarmTimes.setAckTime(BAbsTime.NULL);
                    alarmTimes.setNormalTime(BAbsTime.NULL);
                    alarmTimes.setCount(alarmTimes.getCount() + 1);
                }
            }
            if (ackRequired) {
                BAlarmTransitionBits ackedTrans = this.getAckedTransitions();
                this.setAckedTransitions(BAlarmTransitionBits.make((BAlarmTransitionBits)ackedTrans, (BAlarmTransitionBits)sourceState.getAlarmTransitionBits(), (boolean)false));
            }
        }
        catch (ServiceNotFoundException var14) {
            log.severe("AlarmState Transition Failed - AlarmService not found.");
        }
        catch (Exception var15) {
            log.log(Level.SEVERE, "AlarmState Transition Failed: " + var15, var15);
        }
        return ackRequired;
    }

    public void fireToNormal(BAlarmRecord record) {
        this.lastToNormalTime = record.getNormalTime();
        if (record.getSourceState().getOrdinal() == 0) {
            BAlarmTimestamps alarmTimes = this.getToOffnormalTimes();
            if (!alarmTimes.getAlarmTime().isNull()) {
                alarmTimes.setNormalTime(record.getNormalTime());
            }
            if (!(alarmTimes = this.getToFaultTimes()).getAlarmTime().isNull()) {
                alarmTimes.setNormalTime(record.getNormalTime());
            }
        }
        this.fire(toNormal, (BValue)record, null);
    }

    public BAbsTime getLastOffnormalTime() {
        return this.lastOffnormalTime;
    }

    public BAbsTime getLastFaultTime() {
        return this.lastFaultTime;
    }

    public BAbsTime getLastToNormalTime() {
        return this.lastToNormalTime;
    }

    public BAbsTime getLastAckTime() {
        return this.lastAckTime;
    }

    public BIcon getIcon() {
        return icon;
    }

    private static void dump(String s) {
        System.out.println(s);
    }
}

