/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.exporters;

import com.tridium.file.exporters.BITableToText;
import com.tridium.history.BHistory;
import com.tridium.history.pdf.BHistoryTableToPdf;
import com.tridium.history.ui.BHistoryTable;
import com.tridium.history.ui.exporters.BHistoryTableToCsv;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.baja.collection.BITable;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BTextFile;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.view.BIWbViewExporter;

public class BHistoryTableToText
extends BITableToText
implements BIWbViewExporter {
    public static final Type TYPE = Sys.loadType(BHistoryTableToText.class);

    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BTextFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "txt";
    }

    public void export(ExportOp op) throws Exception {
        BHistoryTable history = (BHistoryTable)op.get();
        PrintWriter out = new PrintWriter(new OutputStreamWriter(op.getOutputStream(), "UTF-8"));
        out.println("history:" + history.getHistory().getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
        out.println(BHistoryTableToPdf.getRangeStr(history.getRange(), (Context)op));
        out.println("");
        out.flush();
        this.export((BITable)BHistoryTableToCsv.makeTable(history.getTableModel()), op);
    }
}

