/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.BHistory;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.util.BTypeSpec;

public class HistoryItem {
    public static final BTypeSpec LineChart = HistoryItem.ts("LineChart");
    public static final BTypeSpec AreaChart = HistoryItem.ts("AreaChart");
    public static final BTypeSpec BarChart = HistoryItem.ts("BarChart");
    public static final BTypeSpec PieChart = HistoryItem.ts("PieChart");
    public static final BTypeSpec StackedBarChart = HistoryItem.ts("StackedBarChart");
    public static final BTypeSpec DiscreteLineChart = HistoryItem.ts("DiscreteLineChart");
    public static final BTypeSpec DiscreteAreaChart = HistoryItem.ts("DiscreteAreaChart");
    private BIHistory history;
    private BBrush brush;
    private BTypeSpec chartType;

    public HistoryItem(BIHistory history) {
        this.history = history;
        this.brush = BColor.red.toBrush();
        this.chartType = LineChart;
    }

    public BIHistory getHistory(BHistorySpace space) {
        try (HistorySpaceConnection conn = space.getConnection(null);){
            BIHistory bIHistory = conn.getHistory(this.history.getId());
            return bIHistory;
        }
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush b) {
        this.brush = b;
    }

    public BTypeSpec getChartType() {
        return this.chartType;
    }

    public void setChartType(BTypeSpec t) {
        this.chartType = t;
    }

    public HistoryItem copy() {
        HistoryItem copy = new HistoryItem(this.history);
        copy.brush = this.brush;
        copy.chartType = this.chartType;
        return copy;
    }

    public String toString() {
        return this.history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX);
    }

    static BTypeSpec ts(String cls) {
        return BTypeSpec.make((String)"chart", (String)cls);
    }
}

