/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.rollup.BRollupInterval;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

public class BRollupEditor
extends BEdgePane {
    public static final Action modified = BRollupEditor.newAction((int)0, null);
    public static final Action periodChanged = BRollupEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BRollupEditor.class);
    static Lexicon lex = Lexicon.make((String)"history");
    private BListDropDown period = new BListDropDown();
    private BListDropDown method;

    public void modified() {
        this.invoke(modified, null, null);
    }

    public void periodChanged() {
        this.invoke(periodChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BRollupEditor() {
        BList p = this.period.getList();
        p.addItem((Object)new IntervalItem(lex.getText("rollupEditor.none"), BRollupInterval.none));
        p.addItem((Object)new IntervalItem(lex.getText("rollupEditor.1min"), BRollupInterval.oneMin));
        p.addItem((Object)new IntervalItem(lex.getText("rollupEditor.5min"), BRollupInterval.fiveMin));
        p.addItem((Object)new IntervalItem(lex.getText("rollupEditor.15min"), BRollupInterval.fifteenMin));
        p.addItem((Object)new IntervalItem(lex.getText("rollupEditor.30min"), BRollupInterval.thirtyMin));
        p.addItem((Object)new IntervalItem(lex.getText("rollupEditor.hour"), BRollupInterval.hourly));
        p.addItem((Object)new IntervalItem(lex.getText("rollupEditor.day"), BRollupInterval.daily));
        p.addItem((Object)new IntervalItem(lex.getText("rollupEditor.month"), BRollupInterval.monthly));
        p.addItem((Object)new IntervalItem(lex.getText("rollupEditor.year"), BRollupInterval.yearly));
        p.setSelectedIndex(0);
        this.method = new BListDropDown();
        BList m = this.method.getList();
        m.addItem((Object)new AlgorithmItem(lex.getText("rollupEditor.avg"), "avg"));
        m.addItem((Object)new AlgorithmItem(lex.getText("rollupEditor.min"), "min"));
        m.addItem((Object)new AlgorithmItem(lex.getText("rollupEditor.max"), "max"));
        m.addItem((Object)new AlgorithmItem(lex.getText("rollupEditor.sum"), "sum"));
        m.setSelectedIndex(0);
        this.method.setVisible(false);
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)this.period);
        grid.add(null, (BValue)this.method);
        this.setLeft((BWidget)grid);
        this.linkTo((BComponent)this.period, (Slot)BListDropDown.listActionPerformed, (Slot)modified);
        this.linkTo((BComponent)this.method, (Slot)BListDropDown.listActionPerformed, (Slot)modified);
        this.linkTo((BComponent)this.period, (Slot)BListDropDown.listActionPerformed, (Slot)periodChanged);
    }

    public boolean isRollup() {
        return this.period.getList().getSelectedIndex() > 0;
    }

    public BRollupInterval getInterval() {
        IntervalItem item = (IntervalItem)this.period.getSelectedItem();
        return item.getTimeInterval();
    }

    public String getAlgorithm() {
        AlgorithmItem item = (AlgorithmItem)this.method.getSelectedItem();
        return item.alg;
    }

    public void doModified() {
    }

    public void doPeriodChanged() {
        boolean visible;
        boolean bl = visible = this.period.getList().getSelectedIndex() > 0;
        if (visible != this.method.getVisible()) {
            this.method.setVisible(visible);
        }
        this.relayout();
    }

    int[] pickle() {
        return new int[]{this.period.getList().getSelectedIndex(), this.method.getList().getSelectedIndex()};
    }

    void unpickle(int[] i) {
        this.period.getList().setSelectedIndex(i[0]);
        this.method.getList().setSelectedIndex(i[1]);
        this.periodChanged();
    }

    class AlgorithmItem {
        public String label;
        public String alg;

        public AlgorithmItem(String label, String alg) {
            this.label = label;
            this.alg = alg;
        }

        public String toString() {
            return this.label;
        }
    }

    class IntervalItem {
        private String label;
        private long millis;
        private BRollupInterval interval;

        public IntervalItem(String label, BRollupInterval interval) {
            this.label = label;
            this.interval = interval;
        }

        public String toString() {
            return this.label;
        }

        public String getLabel() {
            return this.label;
        }

        public BRollupInterval getTimeInterval() {
            return this.interval;
        }

        public BRollupInterval getRollupInterval() {
            return this.interval;
        }
    }
}

