/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.history.ui.chart.BHistoryChartBuilder;
import com.tridium.sys.transfer.FileToFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.history.BHistoryService;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;

public class BReportViewer
extends BTransferWidget {
    public static final Action hyperlink = BReportViewer.newAction((int)20, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BReportViewer.class);
    private BHistoryChartBuilder builder;
    private BWidget root;
    private byte[] file;

    public void hyperlink(BOrd ord) {
        this.invoke(hyperlink, (BValue)ord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BReportViewer() {
        this.setCopyEnabled(true);
    }

    public BReportViewer(BHistoryChartBuilder builder) {
        this.builder = builder;
        this.setCopyEnabled(true);
    }

    public void load(int reportId) {
        if (this.root != null) {
            this.remove((BComplex)this.root);
        }
        this.root = null;
        try {
            this.root = this.loadFile(reportId);
            this.builder.setSaveReportEnabled(this.file != null);
            if (this.root != null) {
                this.add(null, (BValue)this.root);
                this.relayout();
            } else {
                BDialog.error((BWidget)this, (Object)"Page has expired.");
                this.hyperlink(this.builder.getBuilderOrd());
            }
        }
        catch (Exception e) {
            this.builder.setSaveReportEnabled(false);
            BDialog.error((BWidget)this, (String)"Cannot load view.", (Object)e);
            return;
        }
    }

    public BTransferWidget getTransferWidget() {
        return this;
    }

    public void doHyperlink(BOrd ord) {
        if (ord.isNull()) {
            return;
        }
        this.builder.getWbShell().hyperlink(ord);
    }

    public void save() throws IOException {
        FilePath pxDir;
        BFileSpace fileSpace = (BFileSpace)BOrd.make((BOrd)this.builder.getWbShell().getActiveOrd(), (String)"file:").resolve().get();
        BDirectory dir = (BDirectory)fileSpace.findFile(pxDir = new FilePath("^px"));
        if (dir == null) {
            dir = fileSpace.makeDir(pxDir);
        }
        String defName = FileToFile.getUniqueFilename((BDirectory)dir, (String)"Chart.px");
        BFileChooser fileChooser = BFileChooser.makeSave((BWidget)this);
        fileChooser.setCurrentDirectory(dir.getAbsoluteOrd());
        fileChooser.setDefaultFileName(defName);
        BOrd result = fileChooser.show();
        if (result == null) {
            return;
        }
        BIFile pxFile = (BIFile)result.resolve().get();
        pxFile.write(this.file);
        this.hyperlink(result);
    }

    public void computePreferredSize() {
        if (this.root == null) {
            this.setPreferredSize(100.0, 100.0);
        } else {
            this.root.computePreferredSize();
            this.setPreferredSize(this.root.getPreferredWidth(), this.root.getPreferredHeight());
        }
    }

    public void doLayout(BWidget[] kids) {
        if (this.root != null) {
            this.root.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    private BWidget loadFile(int id) throws Exception {
        BOrd activeOrd = this.builder.getWbShell().getActiveOrd();
        BHistoryService service = (BHistoryService)BOrd.make((BOrd)activeOrd, (String)"service:history:HistoryService").resolve().get();
        BISession session = service.getSession();
        BFoxClientConnection conn = ((BFoxSession)session).getConnection();
        BHistoryChannel channel = (BHistoryChannel)conn.getChannels().get("history", BHistoryChannel.TYPE);
        this.file = channel.getReport(id);
        if (this.file == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(this.file);
        BWidget root = new PxDecoder(activeOrd, (InputStream)bIn).decodeDocument();
        return root;
    }

    public TransferEnvelope getTransferData() {
        if (this.root == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)new Mark((BObject)this.root));
    }

    public CommandArtifact insertTransferData(TransferContext cx) {
        return null;
    }

    public CommandArtifact removeTransferData(TransferContext cx) {
        return null;
    }
}

