/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.ui.chart.BLiveHistoryChartEditor;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BChartBinding;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLiveValueChartBinding
extends BChartBinding {
    public static final Action sample = BLiveValueChartBinding.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BLiveValueChartBinding.class);
    private BLiveHistoryChartEditor historyChart;
    private Clock.Ticket ticket;
    private int index;
    private long sampleRate;
    private boolean cov = false;

    public void sample() {
        this.invoke(sample, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLiveValueChartBinding() {
        throw new UnsupportedOperationException();
    }

    public BLiveValueChartBinding(BLiveHistoryChartEditor historyChart, long sampleRate, int index) {
        this.historyChart = historyChart;
        this.index = index;
        this.sampleRate = sampleRate;
    }

    public Series createSeries() {
        return null;
    }

    protected void bound() {
        super.bound();
        if (this.sampleRate != 0L) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)this.sampleRate), (Action)sample, null);
        } else {
            this.cov = true;
        }
    }

    protected void unbound() {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        super.unbound();
    }

    protected void valueChanged() {
        if (this.cov) {
            BObject value = this.get();
            this.getSample(value);
        }
    }

    public void doSample() {
        if (this.historyChart != null && this.historyChart.getCurrentTime() != null && this.historyChart.getLastTime(this.index) != null && this.historyChart.getCurrentTime().isAfter(((BAbsTime)this.historyChart.getLastTime(this.index)).add(BRelTime.make((long)this.sampleRate)))) {
            BObject value = this.get();
            this.getSample(value);
        }
    }

    private synchronized void getSample(BObject value) {
        if (value == null) {
            return;
        }
        if (!value.isValue()) {
            return;
        }
        if (this.historyChart != null) {
            this.historyChart.valueChanged(value, this.index);
        }
    }
}

