/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.ui.chart.BLiveHistoryChart;
import com.tridium.history.ui.chart.BLiveValueChartBinding;
import com.tridium.history.ui.chart.LiveChartSeries;
import java.util.ArrayList;
import javax.baja.chart.BAbsTimeAxis;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.BChartPane;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.BDiscreteLineChart;
import javax.baja.chart.BLineChart;
import javax.baja.chart.BNumericAxis;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.SimpleChartModel;
import javax.baja.chart.TableSeries;
import javax.baja.chart.binding.BAxisBound;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BPen;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryPointList;
import javax.baja.history.BHistoryPointListItem;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BSampleRate;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.history.ext.BStringCovHistoryExt;
import javax.baja.history.ext.BStringIntervalHistoryExt;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIObject;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BLiveHistoryChartEditor
extends BWidget {
    public static final Property showTimeRangeEditor = BLiveHistoryChartEditor.newProperty((int)0, (boolean)false, null);
    public static final Property defaultTimeRange = BLiveHistoryChartEditor.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    public static final Action buildChart = BLiveHistoryChartEditor.newAction((int)0, null);
    public static final Action selectAll = BLiveHistoryChartEditor.newAction((int)0, null);
    public static final Action recalculateRange = BLiveHistoryChartEditor.newAction((int)0, null);
    public static final Action toggleItemListView = BLiveHistoryChartEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BLiveHistoryChartEditor.class);
    private static BColor DEFAULT_COLOR = BColor.blue;
    private static long DEFAULT_START_TIME = 0L;
    private static long DEFAULT_TIME_WINDOW = 600000L;
    private static double SPLIT_DEFAULT_POSITION = 20.0;
    private BLiveHistoryChart builder;
    private BCheckList historyList;
    private BSplitPane split;
    public BDynamicTimeRange timeRange;
    private BWbFieldEditor timeRangeEd;
    private BEdgePane config;
    private BEdgePane chartPane;
    private BChartPane pane;
    private static Lexicon lex = Lexicon.make((String)"history");
    private int maxSamples = 5000;
    private int maxVisible = 5000;
    private BRelTime timeWindow = BRelTime.make((long)DEFAULT_TIME_WINDOW);
    private BColor backgroundColor = BColor.NULL;
    private boolean showHorizontalGridLines = true;
    private boolean showVerticalGridLines = true;
    private ChartItems[] chartItems;
    private BTimeZone timeZone;
    private BAbsTimeAxis absTimeAxis;
    private double splitDividerPosition = SPLIT_DEFAULT_POSITION;
    private ToggleCommand deltaCmd;
    private boolean loading = false;

    public boolean getShowTimeRangeEditor() {
        return this.getBoolean(showTimeRangeEditor);
    }

    public void setShowTimeRangeEditor(boolean v) {
        this.setBoolean(showTimeRangeEditor, v, null);
    }

    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    public void setDefaultTimeRange(BDynamicTimeRange v) {
        this.set(defaultTimeRange, (BValue)v, null);
    }

    public void buildChart() {
        this.invoke(buildChart, null, null);
    }

    public void selectAll() {
        this.invoke(selectAll, null, null);
    }

    public void recalculateRange() {
        this.invoke(recalculateRange, null, null);
    }

    public void toggleItemListView() {
        this.invoke(toggleItemListView, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLiveHistoryChartEditor() {
    }

    public BLiveHistoryChartEditor(BLiveHistoryChart builder) {
        this.builder = builder;
        this.split = new BSplitPane();
        this.split.setDividerPosition(0.0);
        this.config = new BEdgePane();
        this.historyList = new BCheckList();
        this.linkTo("listLink", (BComponent)this.historyList, (Slot)BCheckList.selectionModified, (Slot)buildChart);
        this.config.setCenter((BWidget)new BScrollPane((BWidget)this.historyList));
        this.split.setWidget1((BWidget)this.config);
        this.add("split", (BValue)this.split);
        this.chartPane = new BEdgePane();
        BGridPane header = new BGridPane(2);
        header.setStretchColumn(1);
        header.setColumnGap(4.0);
        header.setHalign(BHalign.fill);
        this.timeRange = BDynamicTimeRange.DEFAULT;
        this.initCommands();
        BToggleButton deltaEd = new BToggleButton(this.deltaCmd, false, true);
        deltaEd.setSelected(false);
        deltaEd.setVisible(true);
        header.add(null, (BValue)deltaEd);
        BButton toggleItemListViewButton = new BButton(lex.getText("chartBuilder.toggleItemListView"));
        header.add(null, (BValue)toggleItemListViewButton);
        this.add("toggleItemListViewLink", (BValue)new BLink((BComponent)toggleItemListViewButton, (Slot)BButton.actionPerformed, (Slot)toggleItemListView));
        if (this.getShowTimeRangeEditor()) {
            header.add(null, (BValue)new BLabel(lex.getText("chartBuilder.timeRange")));
            this.timeRangeEd = BWbFieldEditor.makeFor((BObject)BDynamicTimeRange.DEFAULT);
            this.timeRangeEd.loadValue((BObject)this.timeRange);
            header.add(null, (BValue)this.timeRangeEd);
        }
        this.chartPane.setTop((BWidget)new BBorderPane((BWidget)header, BInsets.make((double)0.0, (double)0.0, (double)4.0, (double)0.0)));
        this.split.setWidget2((BWidget)this.chartPane);
    }

    private void initCommands() {
        this.deltaCmd = new ToggleCommand(this, BLiveHistoryChartEditor.lex.module, "command.delta"){

            public CommandArtifact doInvoke() {
                BLiveHistoryChartEditor.this.recalculateRange();
                return null;
            }
        };
    }

    public void refreshView() {
        ListSelection selection = this.historyList.getSelection();
        int i = 0;
        for (i = 0; i < this.chartItems.length; ++i) {
            if (!selection.isSelected(i) || !this.chartItems[i].enabled) continue;
            this.chartItems[i].liveChartSeries.setShowDelta(this.deltaCmd.isSelected());
            this.chartItems[i].liveChartSeries.refresh();
        }
    }

    public void load(BComponent initiatingComponent) {
        this.loading = true;
        this.buildLiveHistoryChart(initiatingComponent);
        this.historyList.relayout();
        this.loading = false;
        this.doBuildChart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildLiveHistoryChart(BComponent initiatingComponent) {
        BComponent[] historyExtensions = null;
        try {
            this.initializeChartItems(initiatingComponent);
            if (this.chartItems.length == 0) {
                return;
            }
            historyExtensions = this.getHistoryExtensions(initiatingComponent);
            if (historyExtensions == null) {
                return;
            }
            if (historyExtensions == null || historyExtensions.length == 0) {
                return;
            }
            BLiveHistoryChartEditor.lease((BComponent[])historyExtensions, (int)1);
            BatchResolve batchResolveOrds = null;
            batchResolveOrds = this.getHistories(initiatingComponent, historyExtensions);
            if (batchResolveOrds != null) {
                this.addHistoryListItems(initiatingComponent, batchResolveOrds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            historyExtensions = null;
        }
    }

    private void initializeChartItems(BComponent initiatingComponent) {
        try {
            if (initiatingComponent instanceof BHistoryPointList) {
                BHistoryPointListItem[] historyPointListItems = null;
                this.maxSamples = ((BHistoryPointList)initiatingComponent).getMaxSamples();
                this.maxVisible = ((BHistoryPointList)initiatingComponent).getMaxVisible();
                this.timeWindow = ((BHistoryPointList)initiatingComponent).getTimeWindow();
                this.backgroundColor = ((BHistoryPointList)initiatingComponent).getBackground();
                this.showHorizontalGridLines = ((BHistoryPointList)initiatingComponent).getShowHorizontalGridLines();
                this.showVerticalGridLines = ((BHistoryPointList)initiatingComponent).getShowVerticalGridLines();
                historyPointListItems = (BHistoryPointListItem[])initiatingComponent.getChildren(BHistoryPointListItem.class);
                if (historyPointListItems != null) {
                    this.chartItems = new ChartItems[historyPointListItems.length];
                    BLiveHistoryChartEditor.lease((BComponent[])historyPointListItems, (int)0);
                    for (int i = 0; i < historyPointListItems.length; ++i) {
                        try {
                            this.chartItems[i] = new ChartItems();
                            this.chartItems[i].name = SlotPath.unescape((String)historyPointListItems[i].getName());
                            this.chartItems[i].historyExtensionOrd = historyPointListItems[i].getHistoryExtension();
                            this.chartItems[i].displayOnStartup = historyPointListItems[i].getDisplayOnStartup();
                            this.chartItems[i].startTime = historyPointListItems[i].getStartTime();
                            this.chartItems[i].sampleRate = historyPointListItems[i].getSampleRate();
                            this.chartItems[i].lineColor = historyPointListItems[i].getLineColor();
                            this.chartItems[i].pen = historyPointListItems[i].getPen();
                            this.chartItems[i].minAxisBound = historyPointListItems[i].getMinValueRange();
                            this.chartItems[i].maxAxisBound = historyPointListItems[i].getMaxValueRange();
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else if (initiatingComponent instanceof BHistoryExt) {
                this.chartItems = new ChartItems[1];
                this.chartItems[0] = new ChartItems();
                this.chartItems[0].name = SlotPath.unescape((String)initiatingComponent.getName());
                this.chartItems[0].historyExtensionOrd = initiatingComponent.getAbsoluteOrd();
                this.chartItems[0].displayOnStartup = true;
                this.chartItems[0].startTime = BRelTime.make((long)BLiveHistoryChartEditor.DEFAULT_START_TIME);
                this.chartItems[0].sampleRate = BSampleRate.makeAuto();
                this.chartItems[0].lineColor = BLiveHistoryChartEditor.DEFAULT_COLOR;
                this.chartItems[0].pen = BPen.DEFAULT;
                this.chartItems[0].minAxisBound = BAxisBound.DEFAULT;
                this.chartItems[0].maxAxisBound = BAxisBound.DEFAULT;
                this.split.setDividerPosition(0.0);
                if (!this.isValidHistoryExtension((BHistoryExt)initiatingComponent)) {
                    BDialog.error((BWidget)this, (Object)lex.getText("historyChart.noChartableValue"));
                }
            } else {
                this.chartItems = new ChartItems[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.chartItems = new ChartItems[0];
        }
    }

    private BComponent[] getHistoryExtensions(BComponent initiatingComponent) {
        ArrayList<BObject> v = new ArrayList<BObject>();
        for (int i = 0; i < this.chartItems.length; ++i) {
            try {
                if (this.chartItems[i].historyExtensionOrd == null || this.chartItems[i].historyExtensionOrd.isNull()) continue;
                v.add(this.chartItems[i].historyExtensionOrd.resolve((BObject)initiatingComponent).get());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (v.isEmpty()) {
            return null;
        }
        return v.toArray(new BComponent[v.size()]);
    }

    private BatchResolve getHistories(BComponent initiatingComponent, BComponent[] historyExtensions) {
        BOrd base = null;
        ArrayList<BOrd> v = null;
        base = initiatingComponent.getNavOrd();
        v = new ArrayList<BOrd>();
        for (int i = 0; i < historyExtensions.length; ++i) {
            boolean validHistoryExt = false;
            try {
                if (historyExtensions[i].getType().is(BHistoryExt.TYPE) && this.isValidHistoryExtension((BHistoryExt)historyExtensions[i])) {
                    validHistoryExt = true;
                    BHistoryExt histExt = (BHistoryExt)historyExtensions[i];
                    BHistoryConfig cfg = histExt.getHistoryConfig();
                    BHistoryId id = cfg.getId();
                    BOrd ord = BOrd.make((BOrd)base, (String)("history: " + id));
                    v.add(ord);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (validHistoryExt) continue;
            v.add(this.chartItems[i].historyExtensionOrd);
        }
        BOrd[] historyOrds = v.toArray(new BOrd[v.size()]);
        BatchResolve batchResolveOrds = new BatchResolve(historyOrds);
        batchResolveOrds.resolve((BObject)BLocalHost.INSTANCE);
        return batchResolveOrds;
    }

    private void addHistoryListItems(BComponent initiatingComponent, BatchResolve batchResolveOrds) {
        for (int i = 0; i < this.chartItems.length; ++i) {
            boolean success = false;
            try {
                if (i < batchResolveOrds.size() && batchResolveOrds.isResolved(i)) {
                    BTypeSpec recTypeSpec;
                    Type type;
                    this.chartItems[i].history = (BIHistory)batchResolveOrds.get(i);
                    this.chartItems[i].enabled = true;
                    this.chartItems[i].isValid = true;
                    this.historyList.addItem((Object)this.chartItems[i].name);
                    if (this.chartItems[i].displayOnStartup) {
                        ListSelection selection = this.historyList.getSelection();
                        selection.select(i);
                    }
                    if ((type = (recTypeSpec = this.chartItems[i].history.getRecordType()).getResolvedType()).is(BNumericTrendRecord.TYPE)) {
                        this.chartItems[i].deltaEnabled = true;
                    }
                    if (this.timeZone == null) {
                        this.getHistoryTimeZone((BHistoryExt)this.chartItems[i].historyExtensionOrd.resolve((BObject)initiatingComponent).get());
                    }
                    success = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (success) continue;
            this.chartItems[i].enabled = false;
            this.historyList.addItem(BImage.make((String)"module://icons/x16/error.png"), (Object)this.chartItems[i].name);
        }
    }

    public BTransferWidget getTransferWidget() {
        return this.historyList;
    }

    public void doSelectAll() {
        ListSelection selection = this.historyList.getSelection();
        selection.selectAll();
        this.doBuildChart();
    }

    public void doRecalculateRange() {
        this.refreshView();
    }

    public void doToggleItemListView() {
        if (this.split.getDividerPosition() > 0.0) {
            this.splitDividerPosition = this.split.getDividerPosition();
            this.split.setDividerPosition(0.0);
        } else {
            this.split.setDividerPosition(this.splitDividerPosition);
        }
        this.split.relayout();
    }

    public void doBuildChart() {
        try {
            if (this.loading) {
                return;
            }
            BWidget root = this.buildChartPane();
            this.chartPane.setCenter(root);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)lex.getText("chartBuilder.cannotBuildChart"), (Object)lex.getText("chartBuilder.buildError"), (Throwable)e);
        }
    }

    private BWidget buildChartPane() {
        ArrayList<BChart> charts = new ArrayList<BChart>(1);
        ListSelection selection = this.historyList.getSelection();
        int i = 0;
        this.pane = new BChartPane();
        if (!this.backgroundColor.isNull()) {
            this.pane.getCanvas().setFill(this.backgroundColor.toBrush());
        }
        try {
            this.pane.getCanvas().setShowHorizontalGridLines(this.showHorizontalGridLines);
            this.pane.getCanvas().setShowVerticalGridLines(this.showVerticalGridLines);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (i = 0; i < this.chartItems.length; ++i) {
            if (!selection.isSelected(i) || !this.chartItems[i].enabled) {
                this.chartItems[i].liveChartSeries = null;
                this.chartItems[i].alreadySelected = false;
                continue;
            }
            charts.add(this.buildChart(this.pane, i));
            this.chartItems[i].alreadySelected = true;
        }
        for (i = 0; i < charts.size(); ++i) {
            if (charts == null) continue;
            this.pane.add(null, (BValue)charts.get(i));
        }
        this.pane.getCanvas().setZoomed(false);
        return this.pane;
    }

    private BChart buildChart(BChartPane pane, int index) {
        BLineChart chart = null;
        try {
            BHistoryExt historyExt;
            BITable result;
            BIHistory history;
            block44: {
                history = this.chartItems[index].history;
                result = null;
                BOrd historyOrd = history.getOrdInSession();
                BAbsTime startTime = this.getCurrentTime().subtract(this.chartItems[index].startTime);
                BOrd historyQuery = null;
                historyQuery = this.chartItems[index].startTime.getMillis() == 0L ? BOrd.make((String)(historyOrd.toString() + "?" + this.timeRange.toOrdParams())) : BOrd.make((String)(historyOrd.toString() + "?period=timeRange;start=" + startTime.encodeToString()));
                BOrd ord = BOrd.make((BOrd)history.getAbsoluteOrd(), (BOrd)historyQuery).normalize();
                result = (BITable)ord.resolve().get();
                try (TableCursor cursor = result.cursor();){
                    if (cursor.next()) break block44;
                    BOrd activeOrd = this.builder.getWbShell().getActiveOrd();
                    BHistorySpace historySpace = (BHistorySpace)BOrd.make((BOrd)activeOrd, (String)"history:").resolve().get();
                    try (HistorySpaceConnection conn = historySpace.getConnection(null);){
                        BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                        result = conn.timeQuery(history, lastTimestamp, lastTimestamp);
                    }
                }
            }
            if (!this.chartItems[index].alreadySelected) {
                this.chartItems[index].firstLiveData = true;
                TableSeries tableSeries = new TableSeries(null, result, "timestamp", "value");
                this.chartItems[index].liveChartSeries = new LiveChartSeries(this, pane, tableSeries, this.chartItems[index].name, this.maxSamples, this.chartItems[index].deltaEnabled, this.deltaCmd.isSelected());
            } else {
                this.chartItems[index].liveChartSeries.setPane(pane);
            }
            BAxis vAxis = null;
            ColumnList cols = result.getColumns();
            Column valueColumn = cols.get("value");
            if (valueColumn == null) {
                BDialog.error((BWidget)this, (Object)lex.getText("historyChart.noChartableValue"));
                return chart;
            }
            if (history.getConfig().getRecordType().equals((Object)BTypeSpec.make((Type)BNumericTrendRecord.TYPE))) {
                vAxis = this.getValueAxis(index);
                chart = new BLineChart();
            } else {
                vAxis = new BDiscreteAxis();
                ((BDiscreteAxis)vAxis).setRange((Object[])this.getEnumRange((BITable<? extends BIObject>)result, valueColumn));
                chart = new BDiscreteLineChart();
            }
            SimpleChartModel model = new SimpleChartModel();
            if (this.getShowTimeRangeEditor()) {
                try {
                    this.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((historyExt = this.getHistoryExtension(history)) == null) {
                return chart;
            }
            long frequency = 0L;
            if (this.chartItems[index].sampleRate.isAuto()) {
                BCollectionInterval cInterval = historyExt.getHistoryConfig().getInterval();
                if (!cInterval.isIrregular()) {
                    frequency = cInterval.getInterval().getMillis();
                }
            } else if (!this.chartItems[index].sampleRate.isCov()) {
                frequency = this.chartItems[index].sampleRate.getValue().getMillis();
            }
            BLiveValueChartBinding binding = new BLiveValueChartBinding(this, frequency, index);
            BControlPoint controlPoint = historyExt.getParentPoint();
            if (controlPoint != null) {
                if (!controlPoint.getSlotPathOrd().toString().contains("station:|")) {
                    binding.setOrd(BOrd.make((String)("station:|" + controlPoint.getSlotPathOrd().toString())));
                } else {
                    binding.setOrd(controlPoint.getSlotPathOrd());
                }
            } else {
                return chart;
            }
            this.chartItems[index].liveChartSeries.setBrush(this.chartItems[index].lineColor.toBrush());
            this.chartItems[index].liveChartSeries.setPen(this.chartItems[index].pen);
            this.chartItems[index].liveChartSeries.setMinAxisBound(this.chartItems[index].minAxisBound);
            this.chartItems[index].liveChartSeries.setMaxAxisBound(this.chartItems[index].maxAxisBound);
            chart.add(null, (BValue)binding);
            if (this.absTimeAxis == null) {
                this.absTimeAxis = new BAbsTimeAxis(history.getConfig().getTimeZone());
            }
            model.add(new ChartSpec((Series)this.chartItems[index].liveChartSeries, (BAxis)this.absTimeAxis, vAxis));
            chart.setModel((ChartModel)model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chart;
    }

    private BAxis getValueAxis(int index) {
        BAxis valueAxis;
        block4: {
            valueAxis = null;
            try {
                if (this.chartItems[index].minAxisBound.isAuto() || this.chartItems[index].maxAxisBound.isAuto()) break block4;
                for (int i = 0; i < index; ++i) {
                    if (!this.chartItems[i].alreadySelected || !this.chartItems[i].minAxisBound.equals((Object)this.chartItems[index].minAxisBound) || !this.chartItems[i].maxAxisBound.equals((Object)this.chartItems[index].maxAxisBound)) continue;
                    valueAxis = this.chartItems[i].valueAxis;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (valueAxis == null) {
            this.chartItems[index].valueAxis = (BAxis)new BNumericAxis();
            valueAxis = this.chartItems[index].valueAxis;
        }
        return valueAxis;
    }

    private BIObject[] getEnumRange(BITable<? extends BIObject> table, Column col) {
        BEnumRange enumRange;
        BFacets facets = col.getFacets();
        BObject range = null;
        if (facets != null) {
            range = facets.get("range");
        }
        if (range instanceof BEnumRange && (enumRange = (BEnumRange)range).getOrdinals().length != 0) {
            return BLiveHistoryChartEditor.extractEnumRange((BEnumRange)range, table, col);
        }
        try (TableCursor cursor = table.cursor();){
            if (cursor.next()) {
                BIObject value = cursor.cell(col);
                if (value instanceof BEnum) {
                    BEnumRange enumRange2 = ((BEnum)value).getRange();
                    BIObject[] bIObjectArray = BLiveHistoryChartEditor.extractEnumRange(enumRange2, table, col);
                    return bIObjectArray;
                }
                BIObject[] bIObjectArray = BLiveHistoryChartEditor.extractRange(table, col);
                return bIObjectArray;
            }
            Type type = col.getType();
            if (!type.isAbstract() && type.is(BFrozenEnum.TYPE)) {
                BIObject[] bIObjectArray = BLiveHistoryChartEditor.extractEnumRange(((BEnum)type.getInstance()).getRange(), table, col);
                return bIObjectArray;
            }
            BIObject[] bIObjectArray = new BIObject[]{};
            return bIObjectArray;
        }
    }

    private static BIObject[] extractEnumRange(BEnumRange range, BITable<? extends BIObject> table, Column column) {
        int[] ordinals = range.getOrdinals();
        IntHashMap ordMap = new IntHashMap(Math.max(7, ordinals.length));
        for (int ordinal : ordinals) {
            ordMap.put(ordinal, (Object)range.get(ordinal));
        }
        try (TableCursor cursor = table.cursor();){
            while (cursor.next()) {
                BEnum value = (BEnum)cursor.cell(column);
                if (ordMap.get(value.getOrdinal()) != null) continue;
                ordMap.put(value.getOrdinal(), (Object)value);
            }
        }
        Object[] values = (BEnum[])ordMap.toArray((Object[])new BEnum[ordMap.size()]);
        SortUtil.sort((Object[])values);
        return values;
    }

    private static BIObject[] extractRange(BITable<? extends BIObject> table, Column column) {
        ArrayList<BIObject> temp = new ArrayList<BIObject>();
        try (TableCursor cursor = table.cursor();){
            while (cursor.next()) {
                BIObject value = cursor.cell(column);
                if (temp.contains(value)) continue;
                temp.add(value);
            }
        }
        Object[] range = temp.toArray(new BIObject[temp.size()]);
        if (range[0] instanceof Comparable) {
            SortUtil.sort((Object[])range);
        }
        return range;
    }

    public BAbsTime getCurrentTime() {
        return BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)this.timeZone);
    }

    public BTimeZone getTimeZone() {
        return this.timeZone;
    }

    public Object getMinTime() {
        ListSelection selection = this.historyList.getSelection();
        int i = 0;
        boolean first = true;
        Object value = null;
        Object minValue = null;
        BAbsTime minRange = this.getCurrentTime().subtract(this.getTimeWindow());
        for (i = 0; i < this.chartItems.length; ++i) {
            if (!selection.isSelected(i) || !this.chartItems[i].enabled || this.chartItems[i] == null || this.chartItems[i].liveChartSeries == null || (value = this.chartItems[i].liveChartSeries.getMinTime()) == null) continue;
            if (first) {
                minValue = ((BAbsTime)value).isAfter(minRange) ? value : minRange;
                first = false;
                continue;
            }
            if (SortUtil.compare((Object)value, minValue) <= 0) continue;
            minValue = value;
        }
        return minValue;
    }

    public BRelTime getTimeWindow() {
        return this.timeWindow;
    }

    public Object getLastTime(int index) {
        return this.chartItems[index].liveChartSeries.getMaxTime();
    }

    public void valueChanged(BObject value, int index) {
        try {
            if (value.getType().is(BControlPoint.TYPE) && this.chartItems[index] != null && this.chartItems[index].liveChartSeries != null && this.isValidValue(value, index)) {
                this.chartItems[index].liveChartSeries.addData(this.getCurrentTime(), ((BControlPoint)value).getStatusValue().getValueValue(), ((BControlPoint)value).getStatus().getBits(), this.pane.getCanvas().isZoomed());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValidValue(BObject value, int index) {
        try {
            if (BStatus.make((int)((BControlPoint)value).getStatus().getBits()).isValid()) {
                if (!this.chartItems[index].isValid) {
                    this.historyList.setItem(index, (Object)this.chartItems[index].name);
                    this.chartItems[index].isValid = true;
                }
            } else if (this.chartItems[index].isValid) {
                this.historyList.setItem(index, BImage.make((String)"module://icons/x16/error.png"), (Object)this.chartItems[index].name);
                this.chartItems[index].isValid = false;
            }
            if (this.chartItems[index].firstLiveData) {
                this.chartItems[index].firstLiveData = false;
                return true;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    protected BHistoryExt getHistoryExtension(BIHistory history) {
        try {
            BComponent historyService;
            BHistoryConfig cfg = history.getConfig();
            BOrd ord = cfg.getSourceHandle();
            if (ord == null || ord.isNull()) {
                return null;
            }
            BWbShell shell = this.builder.getWbShell();
            if (shell != null && (historyService = (BComponent)shell.getActiveOrd().get()) != null) {
                return (BHistoryExt)ord.resolve((BObject)historyService).get();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BTimeZone getHistoryTimeZone(BHistoryExt historyExt) {
        try {
            BHistoryConfig historyConfig;
            this.timeZone = BTimeZone.DEFAULT;
            if (historyExt != null && (historyConfig = historyExt.getHistoryConfig()) != null) {
                this.timeZone = historyConfig.getTimeZone();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.timeZone;
    }

    private boolean isValidHistoryExtension(BHistoryExt component) {
        Type type = component.getType();
        return !type.is(BStringCovHistoryExt.TYPE) && !type.is(BStringIntervalHistoryExt.TYPE) && component.getEnabled();
    }

    public void computePreferredSize() {
        this.split.computePreferredSize();
        this.setPreferredSize(this.split.getPreferredWidth(), this.split.getPreferredHeight());
    }

    public void doLayout(BWidget[] kids) {
        this.split.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    private class ChartItems {
        private LiveChartSeries liveChartSeries;
        private BIHistory history;
        private boolean enabled;
        private boolean alreadySelected;
        private boolean deltaEnabled;
        private boolean firstLiveData;
        private boolean isValid;
        private String name;
        private BOrd historyExtensionOrd;
        private boolean displayOnStartup;
        private BRelTime startTime;
        private BSampleRate sampleRate;
        private BColor lineColor;
        private BPen pen;
        private BAxisBound minAxisBound;
        private BAxisBound maxAxisBound;
        private BAxis valueAxis;

        private ChartItems() {
        }
    }
}

