/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.history.nav.BFilteredHistoryNavNode;
import com.tridium.history.rollup.BRollupInterval;
import com.tridium.history.ui.chart.BHistoryChartBuilder;
import com.tridium.history.ui.chart.BHistoryList;
import com.tridium.history.ui.chart.BRollupEditor;
import com.tridium.history.ui.chart.HistoryItem;
import com.tridium.history.ui.chart.HistoryListModel;
import com.tridium.ui.theme.Theme;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.chart.BChart;
import javax.baja.chart.BChartPane;
import javax.baja.chart.binding.BAxisSpec;
import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.chart.binding.BDiscreteAxisSpec;
import javax.baja.chart.binding.BTableChartBinding;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.px.PxEncoder;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;

public class BChartEditor
extends BEdgePane {
    public static final Action buildChart = BChartEditor.newAction((int)0, null);
    public static final Action clear = BChartEditor.newAction((int)0, null);
    public static final Action stateChange = BChartEditor.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BChartEditor.class);
    private static HashMap<String, State> states = new HashMap();
    private static Lexicon lex = Lexicon.make((String)"history");
    BHistoryChartBuilder builder;
    private State state;
    private BNavTree tree;
    private BSplitPane split;
    private BWbFieldEditor timeRangeEd;
    private BTextField titleField;
    private BWbFieldEditor showGridEd;
    private BRollupEditor rollupEd;
    private BHistoryList historyList;
    private boolean ignoreChanges = false;
    private static BFacets noTimeZone = BFacets.make((String)"showTimeZone", (BIDataValue)BBoolean.FALSE);

    public void buildChart() {
        this.invoke(buildChart, null, null);
    }

    public void clear() {
        this.invoke(clear, null, null);
    }

    public void stateChange() {
        this.invoke(stateChange, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BChartEditor() {
    }

    public BChartEditor(BHistoryChartBuilder builder) {
        this.builder = builder;
        this.state = new State();
        this.state.editor = this;
        Model m = new Model();
        m.editor = this;
        this.state.model = m;
        this.state.dividerPosition = 30.0;
        this.state.timeRange = BDynamicTimeRange.make((BDynamicTimeRangeType)BDynamicTimeRangeType.today);
        this.tree = new BNavTree();
        this.tree.setController((TreeController)new Controller());
        this.historyList = new BHistoryList(this.state.model);
        this.timeRangeEd = BWbFieldEditor.makeFor((BObject)BDynamicTimeRange.DEFAULT);
        this.timeRangeEd.loadValue((BObject)this.state.timeRange, (Context)noTimeZone);
        this.showGridEd = BWbFieldEditor.makeFor((BObject)BBoolean.TRUE);
        BFacets yesNo = BFacets.makeBoolean((BString)BString.make((String)lex.getText("chartBuilder.show")), (BString)BString.make((String)lex.getText("chartBuilder.hide")));
        this.showGridEd.loadValue((BObject)BBoolean.TRUE, (Context)yesNo);
        this.rollupEd = new BRollupEditor();
        BFont font = Theme.widget().getBoldText();
        BGridPane config = new BGridPane(2);
        config.setStretchColumn(1);
        config.setColumnGap(10.0);
        config.setHalign(BHalign.fill);
        config.add(null, (BValue)new BLabel(lex.getText("chartBuilder.timeRange"), font));
        config.add(null, (BValue)this.timeRangeEd);
        config.add(null, (BValue)new BLabel(lex.getText("chartBuilder.title"), font));
        this.titleField = new BTextField("", 40);
        config.add(null, (BValue)this.titleField);
        config.add(null, (BValue)new BLabel(lex.getText("chartBuilder.gridLines"), font));
        config.add(null, (BValue)this.showGridEd);
        config.add(null, (BValue)new BLabel(lex.getText("chartBuilder.rollup"), font));
        config.add(null, (BValue)this.rollupEd);
        BGridPane buttons = new BGridPane(2);
        BButton chartButton = new BButton(lex.getText("chartBuilder.buildChart"));
        BButton clearButton = new BButton(lex.getText("chartBuilder.clear"));
        buttons.add(null, (BValue)chartButton);
        buttons.add(null, (BValue)clearButton);
        String str2 = lex.getText("chartBuilder.histories");
        String str3 = lex.getText("chartBuilder.currentCharts");
        this.split = new BSplitPane();
        this.split.setDividerPosition(this.state.dividerPosition);
        this.split.setWidget1((BWidget)new BTitlePane(str2, (BWidget)new BTreePane((BTree)this.tree)));
        this.split.setWidget2((BWidget)new BTitlePane(str3, (BWidget)new BScrollPane((BWidget)this.historyList)));
        this.setTop((BWidget)new BBorderPane((BWidget)config, BInsets.make((double)5.0)));
        this.setCenter((BWidget)new BBorderPane((BWidget)this.split, 5.0, 0.0, 0.0, 0.0));
        this.setBottom((BWidget)new BBorderPane((BWidget)buttons, 5.0, 0.0, 0.0, 0.0));
        this.add("chartLink", (BValue)new BLink((BComponent)chartButton, (Slot)BButton.actionPerformed, (Slot)buildChart));
        this.add("clearLink", (BValue)new BLink((BComponent)clearButton, (Slot)BButton.actionPerformed, (Slot)clear));
        this.add("divChange", (BValue)new BLink((BComponent)this.split, (Slot)BSplitPane.dividerMoved, (Slot)stateChange));
        this.add("titleChange", (BValue)new BLink((BComponent)this.titleField, (Slot)BTextField.textModified, (Slot)stateChange));
        this.add("gridChange", (BValue)new BLink((BComponent)this.showGridEd, (Slot)BWbFieldEditor.setModified, (Slot)stateChange));
        this.add("timeChange", (BValue)new BLink((BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)stateChange));
        this.add("rollupChange", (BValue)new BLink((BComponent)this.rollupEd, (Slot)BRollupEditor.modified, (Slot)stateChange));
    }

    public void load(BObject obj) {
        this.tree.setModel((TreeModel)new DefaultNavTreeModel((BINavNode)BFilteredHistoryNavNode.make(obj, null, new HistoryFilter(), null)));
        this.restoreState();
        this.tree.relayout();
    }

    public BTransferWidget getTransferWidget() {
        return this.historyList;
    }

    public void doBuildChart() {
        BOrd activeOrd = this.builder.getWbShell().getActiveOrd();
        BHistoryChannel channel = null;
        try {
            BHistoryService service = (BHistoryService)BOrd.make((BOrd)activeOrd, (String)"service:history:HistoryService").resolve().get();
            BISession session = service.getSession();
            BFoxClientConnection conn = ((BFoxSession)session).getConnection();
            channel = (BHistoryChannel)conn.getChannels().get("history", BHistoryChannel.TYPE);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)"Cannot build chart.", (Object)e);
        }
        try {
            BWidget root = this.buildWidgetTree();
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            PxEncoder encoder = new PxEncoder((OutputStream)out);
            encoder.encodeDocument(root);
            out.flush();
            int id = channel.postReport(out.toByteArray());
            BOrd reportOrd = BOrd.make((BOrd)activeOrd, (String)("history:|view:history:HistoryChartBuilder?id=" + id)).normalize();
            this.builder.getWbShell().hyperlink(reportOrd);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)lex.getText("chartBuilder.cannotBuildChart"), (Object)lex.getText("chartBuilder.buildError"), (Throwable)e);
        }
    }

    public void doClear() {
        this.historyList.getModel().clear();
    }

    public BWidget buildWidgetTree() {
        ArrayList<BChart> charts = new ArrayList<BChart>(1);
        BChart lastChart = null;
        for (int i = 0; i < this.state.model.size(); ++i) {
            HistoryItem item = this.state.model.get(i);
            BTypeSpec chartType = item.getChartType();
            boolean doRollup = this.rollupEd.isRollup();
            BChart chart = null;
            if (lastChart == null || !lastChart.getType().getTypeSpec().equals((Object)chartType)) {
                chart = (BChart)chartType.getInstance();
                charts.add(chart);
                lastChart = chart;
            } else {
                chart = lastChart;
            }
            BTableChartBinding binding = new BTableChartBinding();
            BDynamicTimeRange timeRange = null;
            try {
                timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (String)lex.getText("timerange.error"), (Object)lex.getText("timerange.checkRange"), (Throwable)e);
                throw new BajaRuntimeException((Throwable)e);
            }
            StringBuffer buf = new StringBuffer();
            BIHistory history = item.getHistory(this.builder.getHistorySpace());
            buf.append(history.getOrdInSession().toString());
            buf.append("?").append(this.toOrdParams(timeRange, history.getConfig().getTimeZone()));
            if (doRollup) {
                BRollupInterval interval = this.rollupEd.getInterval();
                if (interval instanceof BRelTime) {
                    BRelTime relInterval = (BRelTime)interval;
                    buf.append("|bql:history:HistoryRollup.rollup(baja:RelTime");
                    buf.append(" '").append(relInterval.getMillis()).append("')");
                } else if (interval instanceof BRollupInterval) {
                    try {
                        BRollupInterval rollInterval = interval;
                        buf.append("|bql:history:HistoryRollup.rollup(history:RollupInterval");
                        buf.append(" '").append(rollInterval.encodeToString()).append("')");
                    }
                    catch (IOException ioe) {
                        Logger.getLogger("history").log(Level.SEVERE, "Failed to encode BRollupInterval to String", ioe);
                    }
                }
            }
            binding.setOrd(BOrd.make((String)buf.toString()));
            binding.setXColumn(BColumnIdentifier.makeTableColumn((String)"timestamp"));
            binding.setYColumn(BColumnIdentifier.makeTableColumn((String)(doRollup ? this.rollupEd.getAlgorithm() : "value")));
            binding.setBrush(item.getBrush());
            if (doRollup) {
                binding.setXAxis((BAxisSpec)new BDiscreteAxisSpec());
            }
            chart.add(null, (BValue)binding);
        }
        BChartPane pane = new BChartPane();
        String title = this.titleField.getText().trim();
        if (title.length() != 0) {
            pane.getHeader().setTitle(title);
        }
        try {
            if (this.showGridEd.saveValue() == BBoolean.TRUE) {
                pane.getCanvas().setShowHorizontalGridLines(true);
                pane.getCanvas().setShowVerticalGridLines(true);
            }
        }
        catch (Exception chartType) {
            // empty catch block
        }
        for (int i = 0; i < charts.size(); ++i) {
            pane.add(null, (BValue)charts.get(i));
        }
        return pane;
    }

    public String toOrdParams(BDynamicTimeRange timeRange, BTimeZone timeZone) {
        BAbsTime end;
        BDynamicTimeRangeType rangeType = timeRange.getRangeType();
        if (rangeType != BDynamicTimeRangeType.timeRange) {
            return "period=" + rangeType.getTag();
        }
        StringBuffer s = new StringBuffer(32);
        s.append("period=").append(rangeType.getTag());
        BAbsTime start = timeRange.getFixedStartTime();
        if (start != null && !start.isNull()) {
            start = BAbsTime.make((long)start.getMillis(), (BTimeZone)timeZone);
            s.append(';').append("start=").append(start.encodeToString());
        }
        if ((end = timeRange.getFixedEndTime()) != null && !end.isNull()) {
            end = BAbsTime.make((long)end.getMillis(), (BTimeZone)timeZone);
            s.append(';').append("end=").append(end.encodeToString());
        }
        return s.toString();
    }

    private String toKey() {
        BWbShell shell = this.builder.getWbShell();
        if (shell == null) {
            return null;
        }
        return "" + shell.getActiveOrdTarget().getOrdWithoutViewQuery();
    }

    public void doStateChange() {
        if (this.ignoreChanges) {
            return;
        }
        try {
            this.state.showGridLines = this.showGridEd.saveValue() == BBoolean.TRUE;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.state.dividerPosition = this.split.getDividerPosition();
        this.state.title = this.titleField.getText();
        this.state.rollup = this.rollupEd.pickle();
        try {
            this.state.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreState() {
        String key = this.toKey();
        if (key == null) {
            return;
        }
        this.ignoreChanges = true;
        try {
            State oldState = states.get(key);
            if (oldState != null) {
                oldState.editor = this;
                if (oldState.model instanceof Model) {
                    ((Model)oldState.model).editor = this;
                }
                this.state = oldState.copy();
                this.titleField.setText(this.state.title);
                this.timeRangeEd.loadValue((BObject)this.state.timeRange, (Context)noTimeZone);
                this.historyList.setModel(this.state.model);
                block3: for (String nodeText : this.state.expandedDevices) {
                    TreeModel model = this.tree.getModel();
                    int rootCount = model.getRootCount();
                    for (int r = 0; r < rootCount; ++r) {
                        TreeNode node = model.getRoot(r);
                        if (!nodeText.equals(node.getText())) continue;
                        this.tree.setExpanded(node, true);
                        continue block3;
                    }
                }
                BFacets yesNo = BFacets.makeBoolean((BString)BString.make((String)lex.getText("chartBuilder.show")), (BString)BString.make((String)lex.getText("chartBuilder.hide")));
                this.showGridEd.loadValue((BObject)BBoolean.make((boolean)this.state.showGridLines), (Context)yesNo);
                this.split.setDividerPosition(this.state.dividerPosition);
                this.rollupEd.unpickle(this.state.rollup);
            } else if (this.tree.getModel().getRootCount() == 1) {
                this.tree.setExpanded(this.tree.getModel().getRoot(0), true);
            }
        }
        finally {
            this.ignoreChanges = false;
        }
        states.put(key, this.state);
    }

    static class Model
    extends HistoryListModel {
        BChartEditor editor;

        Model() {
        }

        @Override
        public void changed() {
            super.changed();
            this.editor.doStateChange();
        }

        @Override
        public void add(BIHistory[] histories) {
            int i;
            for (i = 0; i < histories.length; ++i) {
                if (this.isHistoryValidToAdd(histories[i])) continue;
                return;
            }
            for (i = 0; i < histories.length; ++i) {
                this.doAdd(new HistoryItem(histories[i]));
            }
            this.changed();
        }

        @Override
        public void add(HistoryItem[] items) {
            int i;
            for (i = 0; i < items.length; ++i) {
                if (this.isHistoryValidToAdd(items[i].getHistory(this.editor.builder.getHistorySpace()))) continue;
                return;
            }
            for (i = 0; i < items.length; ++i) {
                this.doAdd(items[i]);
            }
            this.changed();
        }

        @Override
        public void add(BIHistory history) {
            if (!this.isHistoryValidToAdd(history)) {
                return;
            }
            this.doAdd(new HistoryItem(history));
            this.changed();
        }

        @Override
        public void add(HistoryItem item) {
            if (!this.isHistoryValidToAdd(item.getHistory(this.editor.builder.getHistorySpace()))) {
                return;
            }
            this.doAdd(item);
            this.changed();
        }

        @Override
        public HistoryListModel copy() {
            Model copy = new Model();
            copy.editor = this.editor;
            for (int i = 0; i < this.size(); ++i) {
                copy.list.add(this.get(i).copy());
            }
            return copy;
        }

        private final boolean isHistoryValidToAdd(BIHistory history) {
            try (HistorySpaceConnection conn = this.editor.builder.getHistorySpace().getConnection(null);){
                boolean bl = conn.exists(history.getId());
                return bl;
            }
        }
    }

    private class HistoryFilter
    implements IFilter {
        private HistoryFilter() {
        }

        public boolean accept(Object o) {
            if (!(o instanceof BIHistory)) {
                return false;
            }
            BIHistory history = (BIHistory)o;
            try {
                BTypeSpec recTypeSpec = history.getRecordType();
                Type type = recTypeSpec.getResolvedType();
                if (!type.is(BTrendRecord.TYPE)) {
                    return false;
                }
                BTrendRecord rec = (BTrendRecord)type.getInstance();
                return rec.getValueProperty().getType() != BString.TYPE;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    private class Controller
    extends TreeController {
        private Controller() {
        }

        public void expanded(TreeNode node) {
            ((BChartEditor)BChartEditor.this).state.expandedDevices.add(node.getText());
        }

        public void collapsed(TreeNode node) {
            ((BChartEditor)BChartEditor.this).state.expandedDevices.remove(node.getText());
        }

        public void nodeDoubleClicked(BMouseEvent event, TreeNode node) {
            BINavNode navNode = ((NavTreeNode)node).getNavNode();
            if (navNode instanceof BIHistory) {
                BChartEditor.this.historyList.getModel().add((BIHistory)navNode);
            }
        }
    }

    static class State {
        BChartEditor editor;
        public HistoryListModel model;
        public BDynamicTimeRange timeRange;
        public String title = "";
        public Set<String> expandedDevices = new HashSet<String>();
        public boolean showGridLines = true;
        public double dividerPosition;
        public int[] rollup = new int[]{0, 0};

        State() {
        }

        public State copy() {
            State copy = new State();
            copy.editor = this.editor;
            copy.model = this.model.copy();
            copy.title = this.title;
            copy.timeRange = this.timeRange;
            copy.expandedDevices = new HashSet<String>(this.expandedDevices);
            copy.showGridLines = this.showGridLines;
            copy.dividerPosition = this.dividerPosition;
            System.arraycopy(this.rollup, 0, copy.rollup, 0, this.rollup.length);
            return copy;
        }
    }
}

