/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.workbench.fieldeditors.BRelTimeFE;
import javax.baja.data.BIDataValue;
import javax.baja.history.BSampleRate;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BSampleRateFE
extends BWbFieldEditor {
    public static final Action updateLayout = BSampleRateFE.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BSampleRateFE.class);
    private static final int UNKNOWN = -1;
    private static final int AUTO = 0;
    private static final int FIXED = 1;
    private static final int COV = 2;
    private static final double GAP = 4.0;
    private static final Lexicon lex = Lexicon.make((String)"chart");
    private BSampleRate sampleRate;
    private BListDropDown typeSelect = new BListDropDown();
    private BRelTimeFE valueEditor;

    public void updateLayout() {
        this.invoke(updateLayout, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSampleRateFE() {
        BList typeList = this.typeSelect.getList();
        typeList.addItem((Object)lex.getText("auto"));
        typeList.addItem((Object)lex.getText("fixed"));
        typeList.addItem((Object)lex.getText("cov"));
        this.add("typeSelect", (BValue)this.typeSelect);
        this.valueEditor = new BRelTimeFE();
        this.add("valueEditor", (BValue)this.valueEditor);
        this.add("typeLink", (BValue)new BLink((BComponent)this.typeSelect, (Slot)BListDropDown.valueModified, (Slot)setModified));
        this.add("layoutLink", (BValue)new BLink((BComponent)this.typeSelect, (Slot)BListDropDown.valueModified, (Slot)updateLayout));
        this.linkTo("valueEditorModified", (BComponent)this.valueEditor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
    }

    public void doLoadValue(BObject value, Context cx) {
        this.sampleRate = (BSampleRate)value;
        this.showValue(this.sampleRate);
        this.relayout();
    }

    private void showValue(BSampleRate sampleRate) {
        BList typeList = this.typeSelect.getList();
        if (typeList.getSelectedIndex() == -1) {
            if (sampleRate.isAuto()) {
                this.typeSelect.setSelectedIndex(0);
            } else if (sampleRate.isCov()) {
                this.typeSelect.setSelectedIndex(2);
            } else {
                this.typeSelect.setSelectedIndex(1);
            }
        }
        if (typeList.getSelectedIndex() == 1) {
            BFacets facets = BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1));
            BRelTime val = sampleRate.getValue();
            this.valueEditor.loadValue((BObject)val, (Context)facets);
        }
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        int type = this.typeSelect.getSelectedIndex();
        if (type == 0) {
            this.sampleRate = BSampleRate.makeAuto();
        } else if (type == 2) {
            this.sampleRate = BSampleRate.makeCov();
        } else {
            BRelTime fixed = (BRelTime)this.valueEditor.saveValue(cx);
            this.sampleRate = BSampleRate.make((BRelTime)fixed);
        }
        return this.sampleRate;
    }

    public void doSetReadonly(boolean ro) {
        this.typeSelect.setEnabled(!ro);
        this.valueEditor.setReadonly(ro);
    }

    public void computePreferredSize() {
        double pw = 0.0;
        double ph = 0.0;
        this.typeSelect.computePreferredSize();
        this.valueEditor.computePreferredSize();
        pw = this.typeSelect.getPreferredWidth() + 4.0 + this.valueEditor.getPreferredWidth();
        ph = Math.max(this.typeSelect.getPreferredHeight(), this.valueEditor.getPreferredHeight());
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        double h = this.getHeight();
        this.typeSelect.computePreferredSize();
        this.valueEditor.computePreferredSize();
        this.typeSelect.setBounds(0.0, (h - this.typeSelect.getPreferredHeight()) / 2.0, this.typeSelect.getPreferredWidth(), this.typeSelect.getPreferredHeight());
        int type = this.typeSelect.getSelectedIndex();
        if (type == 1) {
            this.valueEditor.setBounds(this.typeSelect.getPreferredWidth() + 4.0, (h - this.valueEditor.getPreferredHeight()) / 2.0, this.valueEditor.getPreferredWidth(), this.valueEditor.getPreferredHeight());
        } else {
            this.valueEditor.setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    public void doUpdateLayout() {
        this.showValue(this.sampleRate);
        this.relayout();
    }
}

