/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.history.BIHistoryNavSupport;
import com.tridium.ui.UiEnv;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavListener;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.tree.TreeModel;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;

public final class BHistoryNavSupport
extends BSingleton
implements BIHistoryNavSupport {
    public static final BHistoryNavSupport INSTANCE = new BHistoryNavSupport();
    public static final Type TYPE = Sys.loadType(BHistoryNavSupport.class);

    private BHistoryNavSupport() {
    }

    public Type getType() {
        return TYPE;
    }

    public boolean performingRefresh(BINavNode navNode) {
        return NavTreeNode.performingRefresh((BINavNode)navNode);
    }

    public Runnable makeNavTreeWork(BINavNode navNode) {
        return new NavTreeWork(navNode);
    }

    public void runNavTreeWork(Runnable navTreeWork) {
        UiEnv.get().invokeLater(navTreeWork);
    }

    static class NavTreeWork
    implements Runnable {
        BINavNode navNode;

        public NavTreeWork(BINavNode navNode) {
            this.navNode = navNode;
        }

        @Override
        public void run() {
            NavListener[] listeners = BNavRoot.INSTANCE.getNavListeners();
            if (listeners != null) {
                BOrd navOrd = this.navNode.getNavOrd();
                for (int i = 0; i < listeners.length; ++i) {
                    NavTreeNode node;
                    BNavTree navTree;
                    TreeModel model;
                    if (!(listeners[i] instanceof BNavTree) || !((model = (navTree = (BNavTree)listeners[i]).getModel()) instanceof NavTreeModel) || (node = ((NavTreeModel)model).lookup(navOrd)) == null) continue;
                    node.refresh();
                }
            }
        }
    }
}

