/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.workbench.util.CollectionTableModel;
import javax.baja.collection.BITable;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BHistoryNameDialog
extends BDialog {
    public static final Action ok = BHistoryNameDialog.newAction((int)0, null);
    public static final Action cancel = BHistoryNameDialog.newAction((int)0, null);
    public static final Action toggleList = BHistoryNameDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BHistoryNameDialog.class);
    private static Lexicon lex = Lexicon.make((String)"history");
    private static Lexicon bajauiLex = Lexicon.make((String)"bajaui");
    private static final int MAX_LIST_HEIGHT = 200;
    private static final int MIN_LIST_HEIGHT = 100;
    private String deviceName;
    private String initName;
    private BTextField nameField;
    private BToggleButton listButton;
    private BWidget nameList;
    private BEdgePane main;
    private boolean cancelled = false;
    private String historyName;
    private BEdgePane extra = new BEdgePane();

    public void ok() {
        this.invoke(ok, null, null);
    }

    public void cancel() {
        this.invoke(cancel, null, null);
    }

    public void toggleList() {
        this.invoke(toggleList, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHistoryNameDialog() {
        throw new UnsupportedOperationException();
    }

    public BHistoryNameDialog(BWidget owner) {
        this(owner, "", null);
        this.setResizable(false);
    }

    public BHistoryNameDialog(BWidget owner, String initName, String deviceName) {
        super(owner, lex.getText("historyName.set.title"), true);
        this.setResizable(false);
        this.deviceName = deviceName;
        this.initName = initName;
        this.nameField = new BTextField(SlotPath.unescape((String)initName), 24);
        BLabel icon = new BLabel(BImage.make((BOrd)BOrd.make((String)"module://icons/x32/question.png")));
        BGridPane labelAndField = new BGridPane(1);
        labelAndField.add("label", (BValue)new BLabel(lex.getText("enter.historyName")));
        labelAndField.add("nameField", (BValue)this.nameField);
        BFlowPane top = new BFlowPane();
        top.add("icon", (BValue)icon);
        top.add("name", (BValue)labelAndField);
        BButton okButton = new BButton(bajauiLex.getText("action.ok"));
        this.listButton = new BToggleButton(lex.getText("action.listHistories"));
        BButton cancelButton = new BButton(bajauiLex.getText("action.cancel"));
        BGridPane buttons = new BGridPane(3);
        buttons.add("ok", (BValue)okButton);
        buttons.add("cancel", (BValue)cancelButton);
        buttons.add("list", (BValue)this.listButton);
        BEdgePane collapsed = new BEdgePane();
        collapsed.setTop((BWidget)new BBorderPane((BWidget)top, 0.0, 40.0, 0.0, 0.0));
        collapsed.setBottom((BWidget)new BBorderPane((BWidget)buttons, 4.0, 0.0, 0.0, 0.0));
        this.main = new BEdgePane();
        this.main.setCenter((BWidget)new BBorderPane((BWidget)collapsed, 0.0, 0.0, 4.0, 2.0));
        this.extra = new BEdgePane();
        this.main.setBottom((BWidget)this.extra);
        this.setContent((BWidget)this.main);
        this.add("okLink", (BValue)new BLink((BComponent)okButton, (Slot)BButton.actionPerformed, (Slot)ok));
        this.add("cancelLink", (BValue)new BLink((BComponent)cancelButton, (Slot)BButton.actionPerformed, (Slot)cancel));
        this.add("listLink", (BValue)new BLink((BComponent)this.listButton, (Slot)BButton.actionPerformed, (Slot)toggleList));
        this.getShell().setDefaultButton(okButton);
    }

    public void windowOpened(BWindowEvent event) {
        this.historyName = null;
        this.cancelled = false;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getHistoryName() {
        return this.historyName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUnique(String testName) {
        if (this.deviceName == null) {
            return true;
        }
        BOrd authority = ((BWbShell)this.getOwner().getShell()).getActiveOrd();
        BOrd historySpaceOrd = BOrd.make((BOrd)authority, (String)"history:").normalize();
        BHistorySpace space = (BHistorySpace)historySpaceOrd.get();
        if (space == null) {
            return true;
        }
        try (HistorySpaceConnection conn = space.getConnection(null);){
            boolean bl = !conn.exists(BHistoryId.make((String)this.deviceName, (String)testName));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public void doOk() {
        String entry = SlotPath.escape((String)this.nameField.getText().trim());
        if (this.initName != null && this.initName.equals(entry)) {
            this.cancelled = true;
            this.close();
            return;
        }
        if (!BHistoryId.isValidName((String)entry)) {
            BLabel label = new BLabel(lex.getText("historyName.error.invalid", new Object[]{entry}));
            label.setForeground(BColor.red.toBrush());
            this.extra.setTop((BWidget)label);
            this.setScreenSizeToPreferredSize();
            return;
        }
        if (!this.isUnique(entry)) {
            BLabel label = new BLabel(lex.getText("historyName.error.notUnique", new Object[]{entry}));
            label.setForeground(BColor.red.toBrush());
            this.extra.setTop((BWidget)label);
            this.setScreenSizeToPreferredSize();
            return;
        }
        this.historyName = entry;
        this.close();
    }

    public void doCancel() {
        this.cancelled = true;
        this.close();
    }

    public void doToggleList() {
        boolean show = this.listButton.isSelected();
        if (show) {
            this.extra.setBottom(this.getNameList());
        } else {
            this.extra.setBottom((BWidget)new BNullWidget());
        }
        this.setScreenSizeToPreferredSize();
    }

    private BWidget getNameList() {
        if (this.nameList == null || this.nameList.isNull()) {
            try {
                BOrd authority = ((BWbShell)this.getOwner().getShell()).getActiveOrd();
                StringBuffer s = new StringBuffer(128);
                s.append("history:|bql:select id.historyName from sys.histories");
                if (this.deviceName != null) {
                    s.append(" where id.deviceName='").append(this.deviceName).append("'");
                }
                BOrd bqlOrd = BOrd.make((BOrd)authority, (String)s.toString()).normalize();
                BITable nameTable = (BITable)bqlOrd.resolve().get();
                NameListTableModel model = new NameListTableModel((BITable<? extends BIObject>)nameTable);
                this.nameList = new BConstrainedPane((BWidget)new BTable((TableModel)model));
                ((BConstrainedPane)this.nameList).setMinHeight(100.0);
                ((BConstrainedPane)this.nameList).setMaxHeight(200.0);
                this.nameList = new BBorderPane(this.nameList, 4.0, 4.0, 4.0, 4.0);
            }
            catch (Exception e) {
                this.nameList = new BNullWidget();
            }
        }
        return this.nameList;
    }

    private class NameListTableModel
    extends CollectionTableModel {
        public NameListTableModel(BITable<? extends BIObject> table) {
            super(table, null);
        }

        public Object getValueAt(int row, int col) {
            String s = (String)super.getValueAt(row, col);
            return SlotPath.unescape((String)s);
        }
    }
}

