/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.pdf;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.pdf.BHistoryTableToPdf;
import com.tridium.history.ui.BHistoryChart;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import javax.baja.gx.BFont;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.util.Lexicon;

public abstract class BAbstractHistoryChartToPdf
extends BPdfExporter {
    public static final Type TYPE = Sys.loadType(BAbstractHistoryChartToPdf.class);
    private static Lexicon lex = Lexicon.make((String)"pdf");

    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp op) throws Exception {
        PdfDocument doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
        BHistoryChart history = this.getHistoryChart(op);
        BWidgetToPdf exporter = new BWidgetToPdf();
        exporter.renderDocument((BWidget)history, doc, op);
    }

    public static BPdfFlowPane createPdfComposite(PdfOp op, BHistoryChart history) throws Exception, InterruptedException {
        BDynamicTimeRange range = history.getRange();
        boolean isDelta = history.isDelta();
        BLabel lblName = new BLabel("history:" + history.getHistory().getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
        BLabel lblRange = new BLabel(BHistoryTableToPdf.getRangeStr(range, (Context)op));
        lblName.setFont(BFont.make((String)lex.getText("pdf.propertySheetToPdf.font")));
        lblName.setHalign(BHalign.left);
        lblRange.setHalign(BHalign.left);
        BAbsTime now = BAbsTime.now();
        BTimeZone timeZone = (BTimeZone)history.getCurrentContext().getFacet("TimeZone");
        BAbsTime start = range.getStartTime(now, timeZone);
        BAbsTime end = range.getEndTime(now, timeZone);
        BIHistory h = history.getHistory();
        try (HistorySpaceConnection conn = ((BHistorySpace)h.getSpace()).getConnection(null);){
            if (start == null || start.isNull()) {
                start = conn.getFirstTimestamp(h);
            }
            if (end == null || end.isNull()) {
                end = conn.getLastTimestamp(h);
            }
        }
        range = BDynamicTimeRange.make((BAbsTime)start, (BAbsTime)end);
        BHistoryChart chart = new BHistoryChart();
        chart.setDefaultTimeRange(range);
        chart.setDefaultDelta(isDelta);
        chart.loadValue((BObject)history.getHistory(), (Context)op);
        while (!chart.isReady()) {
            Thread.sleep(1000L);
        }
        BPdfFlowPane flow = new BPdfFlowPane();
        flow.add(null, (BValue)lblName);
        flow.add(null, (BValue)lblRange);
        flow.add(null, (BValue)new BLabel(""));
        flow.add(null, (BValue)chart.popChartPane());
        flow.setupPane();
        return flow;
    }

    protected abstract BHistoryChart getHistoryChart(PdfOp var1);
}

