/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.nav;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.history.BHistory;
import com.tridium.history.ui.BHistoryNameDialog;
import com.tridium.workbench.file.BExportDialog;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.nav.menu.BNavMenuAgent;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class BHistoryMenuAgent
extends BNavMenuAgent {
    public static final BHistoryMenuAgent INSTANCE = new BHistoryMenuAgent();
    public static final Type TYPE = Sys.loadType(BHistoryMenuAgent.class);
    static final Version DISPLAY_NAME_VERSION_START = new Version("3.6");

    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BMenu menu = new BMenu();
        BMenu views = NavMenuUtil.makeViewsMenu((BWidget)owner, (BObject)target);
        menu.add(null, (BValue)new BSubMenuItem((BIMenu)views));
        if (target instanceof BIHistory) {
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)new CopyCommand((BTransferWidget)owner));
            if (((BIHistory)target).getPermissions(cx).hasAdminWrite() && BHistoryMenuAgent.displayNameVersionCheck((BIHistory)target)) {
                menu.add(null, (Command)new DisplayNameCommand(owner, (BIHistory)target, cx));
            }
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)new ExportCommand(owner, (BIHistory)target));
        }
        return menu;
    }

    static boolean displayNameVersionCheck(BIHistory history) {
        BISession session = history.getSession();
        if (session instanceof BFoxSession) {
            try {
                return ((BFoxSession)session).getConnection().getRemoteVersion().compareTo(DISPLAY_NAME_VERSION_START) >= 0;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    class DisplayNameArtifact
    implements CommandArtifact {
        private BIHistory history;
        private BFormat oldValue;
        private BFormat newValue;
        private Context cx;

        public DisplayNameArtifact(BIHistory history, BFormat oldValue, BFormat newValue, Context cx) {
            this.history = history;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.cx = cx;
        }

        public void redo() {
            BHistory.setHistoryDisplayNameFormat((BIHistory)this.history, (BFormat)this.newValue, (Context)this.cx);
            BHistorySpace space = (BHistorySpace)this.history.getSpace();
            BHistoryDevice device = space.getDevice(this.history.getId().getDeviceName());
            String historyName = this.history.getId().getHistoryName();
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRenamed((BINavNode)device, (String)historyName, (String)historyName, (Context)this.cx));
        }

        public void undo() {
            BHistory.setHistoryDisplayNameFormat((BIHistory)this.history, (BFormat)this.oldValue, (Context)this.cx);
            BHistorySpace space = (BHistorySpace)this.history.getSpace();
            BHistoryDevice device = space.getDevice(this.history.getId().getDeviceName());
            String historyName = this.history.getId().getHistoryName();
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRenamed((BINavNode)device, (String)historyName, (String)historyName, (Context)this.cx));
        }
    }

    public class DisplayNameCommand
    extends Command {
        BIHistory history;
        Context cx;

        public DisplayNameCommand(BWidget owner, BIHistory history, Context cx) {
            super(owner, UiLexicon.bajaui().module, "commands.setDisplayName");
            this.history = history;
            this.cx = cx;
        }

        public CommandArtifact doInvoke() {
            String newDisplayName;
            BFormat currName = BHistory.getHistoryDisplayNameFormat((BIHistory)this.history);
            String initVal = "";
            if (currName != null) {
                initVal = currName.getFormat();
            }
            if ((newDisplayName = BDialog.prompt((BWidget)this.getOwner(), (String)this.getLabel(), (String)initVal, (int)20)) == null) {
                return null;
            }
            DisplayNameArtifact artifact = new DisplayNameArtifact(this.history, currName, BFormat.make((String)newDisplayName), this.cx);
            artifact.redo();
            return artifact;
        }
    }

    public class ExportCommand
    extends Command {
        BIHistory history;

        public ExportCommand(BWidget owner, BIHistory history) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.export");
            this.history = history;
        }

        public CommandArtifact doInvoke() {
            try {
                BExportDialog.invoke((BWidget)this.getOwner(), (BOrd)this.history.getAbsoluteOrd(), (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public class RenameCommand
    extends Command {
        BIHistory history;

        public RenameCommand(BWidget owner, BIHistory history) {
            super(owner, UiLexicon.bajaui().module, "commands.rename");
            this.history = history;
        }

        public CommandArtifact doInvoke() {
            BHistoryId id = this.history.getId();
            BHistoryNameDialog d = new BHistoryNameDialog((BWidget)this.getShell(), id.getHistoryName(), id.getDeviceName());
            d.setBoundsCenteredOnOwner();
            d.open();
            if (d.isCancelled()) {
                return null;
            }
            try (HistorySpaceConnection conn = ((BHistorySpace)this.history.getSpace()).getConnection(null);){
                conn.renameHistory(id, d.getHistoryName());
            }
            return null;
        }
    }
}

