/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.hx;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.hx.BHxHistoryChartPxView;
import com.tridium.history.nav.BFilteredHistoryNavNode;
import com.tridium.history.nav.BFilteredHistorySpace;
import com.tridium.hx.fieldeditors.BHxDynamicTimeRangeFE;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.baja.agent.BAbstractPxView;
import javax.baja.chart.BChart;
import javax.baja.chart.BChartPane;
import javax.baja.chart.binding.BAxisSpec;
import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.chart.binding.BDiscreteAxisSpec;
import javax.baja.chart.binding.BTableChartBinding;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.px.BHxPxView;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.IFilter;
import javax.baja.security.BIProtected;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxEncoder;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class BHxHistoryChartBuilder
extends BHxView {
    public static final BHxHistoryChartBuilder INSTANCE = new BHxHistoryChartBuilder();
    public static final Type TYPE = Sys.loadType(BHxHistoryChartBuilder.class);
    private static BImage warningIcon = BImage.make((String)"module://icons/x16/warning.png");
    private static final int CacheSize = 10;
    private static int lastId = 0;
    private static List<CacheItem> cache = new ArrayList<CacheItem>();
    private Build build = new Build(this);

    public Type getType() {
        return TYPE;
    }

    protected BHxHistoryChartBuilder() {
        this.registerEvent((Event)this.build);
    }

    public void write(HxOp op) throws Exception {
        boolean expired = false;
        try {
            ViewQuery query = op.getViewQuery();
            String id = query.getParameter("id", null);
            String xml = this.getFromCache(Integer.parseInt(id));
            if (xml != null) {
                BHxPxView hxView = new BHxPxView((BAbstractPxView)new BHxHistoryChartPxView(xml));
                hxView.write(op.make("historyChartPxView", (OrdTarget)op));
                return;
            }
            expired = true;
        }
        catch (Exception query) {
            // empty catch block
        }
        Lexicon lex = op.getLexicon("history");
        HtmlWriter out = op.getHtmlWriter();
        op.addStyleSheet("module://history/com/tridium/history/hx/TreeNode.css");
        op.addJavaScript(BOrd.make((String)"module://hx/com/tridium/hx/ColorChooser.js"));
        op.addJavaScript(BOrd.make((String)"module://history/com/tridium/history/hx/HistoryChartBuilder.js"));
        out.w((Object)"<div class='window-bg' style='padding:10px; border: 1px solid #999;'>");
        if (expired) {
            out.w((Object)"<div style='background: #ffffee; border: 1px solid #808000;");
            out.w((Object)" padding:10px; margin-bottom:10px'>");
            HxUtil.makeImageJS((BImage)warningIcon, null, null, null, (HxOp)op);
            out.w((Object)" ").safe((Object)lex.getText("chartBuilder.expired"));
            out.w((Object)"</div>");
        }
        this.writeConfig(op);
        out.w((Object)"<div style='padding-top:10px;'></div>");
        out.w((Object)"<table width='100%' style='background: black; table-layout: fixed;' cellpadding='0' cellspacing='1'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td valign='top' style='background:#fff; width:50%; overflow: hidden;'>");
        this.writeHistoryList(op);
        out.w((Object)"</td>");
        out.w((Object)"<td valign='top' style='background:#fff; width:50%; overflow: hidden;'>");
        this.writeSelectionList(op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        out.w((Object)"<div style='padding-top: 10px; text-align:center;'>");
        out.w((Object)" <input type='button' class='button' value='Build'");
        out.w((Object)" onclick='chartBuilder.build(\"").w((Object)op.getPath()).w((Object)"\");' />");
        out.w((Object)" <input type='button' class='button' value='Clear'");
        out.w((Object)" onclick='chartBuilder.clear();' />");
        out.w((Object)"</div>");
        out.w((Object)"</div>");
    }

    public void update(HxOp op) throws Exception {
        try {
            ViewQuery query = op.getViewQuery();
            String id = query.getParameter("id", null);
            String xml = this.getFromCache(Integer.parseInt(id));
            if (xml != null) {
                BHxPxView hxView = new BHxPxView((BAbstractPxView)new BHxHistoryChartPxView(xml));
                hxView.update(op.make("historyChartPxView", (OrdTarget)op));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean process(HxOp op) throws Exception {
        if (BHxDynamicTimeRangeFE.INSTANCE.process(op.make("timeRange", new OrdTarget((OrdTarget)op, (BObject)BDynamicTimeRange.DEFAULT)))) {
            return true;
        }
        return super.process(op);
    }

    private void writeConfig(HxOp op) throws Exception {
        Lexicon lex = op.getLexicon("history");
        HtmlWriter out = op.getHtmlWriter();
        String str1 = lex.getText("chartBuilder.timeRange");
        String str2 = lex.getText("chartBuilder.title");
        String str3 = lex.getText("chartBuilder.gridLines");
        String str4 = lex.getText("chartBuilder.rollup");
        String str5 = lex.getText("chartBuilder.hide");
        String str6 = lex.getText("chartBuilder.show");
        String str7 = lex.getText("rollupEditor.none");
        String str8 = lex.getText("rollupEditor.1min");
        String str9 = lex.getText("rollupEditor.5min");
        String str10 = lex.getText("rollupEditor.15min");
        String str11 = lex.getText("rollupEditor.30min");
        String str12 = lex.getText("rollupEditor.hour");
        String str13 = lex.getText("rollupEditor.day");
        String str14 = lex.getText("rollupEditor.month");
        String str15 = lex.getText("rollupEditor.year");
        String str16 = lex.getText("rollupEditor.avg");
        String str17 = lex.getText("rollupEditor.min");
        String str18 = lex.getText("rollupEditor.max");
        String str19 = lex.getText("rollupEditor.sum");
        out.w((Object)"<table>");
        out.w((Object)"<tr>");
        out.w((Object)"<td style='font-weight:bold;'>").safe((Object)str1).w((Object)"</td>");
        out.w((Object)"<td>");
        HxOp timeRangeOp = op.make("timeRange", new OrdTarget((OrdTarget)op, (BObject)BDynamicTimeRange.DEFAULT));
        BHxDynamicTimeRangeFE.INSTANCE.write(timeRangeOp);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td style='font-weight:bold;'>").safe((Object)str2).w((Object)"</td>");
        out.w((Object)"<td><input name='").w((Object)op.scope("title"));
        out.w((Object)"' type='text' size='60' /></td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td style='font-weight:bold;'>").safe((Object)str3).w((Object)"</td>");
        out.w((Object)"<td>");
        out.w((Object)"<select name='").w((Object)op.scope("showGrid")).w((Object)"'>");
        out.w((Object)"<option value='false'>").safe((Object)str5).w((Object)"</option>");
        out.w((Object)"<option value='true' selected='selected'>").safe((Object)str6).w((Object)"</option>");
        out.w((Object)"</select>");
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td style='font-weight:bold;'>").safe((Object)str4).w((Object)"</td>");
        out.w((Object)"<td>");
        out.w((Object)"<select name='").w((Object)op.scope("rollupInterval")).w((Object)"'>");
        out.w((Object)"<option value='-1' selected='selected'>").safe((Object)str7).w((Object)"</option>");
        out.w((Object)"<option value='60000'>").safe((Object)str8).w((Object)"</option>");
        out.w((Object)"<option value='300000'>").safe((Object)str9).w((Object)"</option>");
        out.w((Object)"<option value='900000'>").safe((Object)str10).w((Object)"</option>");
        out.w((Object)"<option value='1800000'>").safe((Object)str11).w((Object)"</option>");
        out.w((Object)"<option value='3600000'>").safe((Object)str12).w((Object)"</option>");
        out.w((Object)"<option value='86400000'>").safe((Object)str13).w((Object)"</option>");
        out.w((Object)"<option value='2592000000'>").safe((Object)str14).w((Object)"</option>");
        out.w((Object)"<option value='31536000000'>").safe((Object)str15).w((Object)"</option>");
        out.w((Object)"</select> ");
        out.w((Object)"<select name='").w((Object)op.scope("rollupAlg")).w((Object)"'>");
        out.w((Object)"<option value='avg' selected='selected'>").safe((Object)str16).w((Object)"</option>");
        out.w((Object)"<option value='min'>").safe((Object)str17).w((Object)"</option>");
        out.w((Object)"<option value='max'>").safe((Object)str18).w((Object)"</option>");
        out.w((Object)"<option value='sum'>").safe((Object)str19).w((Object)"</option>");
        out.w((Object)"</select>");
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
    }

    private void writeHistoryList(HxOp op) throws Exception {
        Lexicon lex = op.getLexicon("history");
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div class='controlShadow-bg'");
        out.w((Object)" style='font-weight: bold; color:white; padding: 5px; width: 100%;'>");
        out.safe((Object)lex.getText("chartBuilder.histories"));
        out.w((Object)"</div>");
        out.w((Object)"<div style='padding: 5px; overflow: auto;'>");
        BObject obj = op.get();
        BFilteredHistoryNavNode filtered = obj instanceof BHistorySpace ? this.getHistoryNavRoot((BHistorySpace)obj, null, new HistoryFilter(op), op) : BFilteredHistoryNavNode.make(obj, null, new HistoryFilter(op), null);
        BINavNode[] kids = filtered.getNavChildren();
        for (int i = 0; i < kids.length; ++i) {
            this.writeNode(kids[i], op);
        }
        out.w((Object)"</div>");
    }

    protected BINavNode getHistoryNavRoot(BHistorySpace space, IFilter deviceFilter, IFilter historyFilter, HxOp op) {
        return new BFilteredHistorySpace(space, deviceFilter, new HistoryFilter(op));
    }

    private void writeNode(BINavNode node, HxOp op) throws Exception {
        boolean link = node instanceof BIHistory;
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div class='treeNode'>");
        if (!link) {
            out.w((Object)"<span class='treeNodeExpander' onclick='chartBuilder.onTreeExpanderClick(this);'></span>");
        } else {
            out.w((Object)"<span class='treeNodeExpanderEmpty'></span>");
        }
        HxUtil.makeImageJS((BImage)BImage.make((BIcon)node.getNavIcon()), (HxOp)op);
        String displayName = node.getNavDisplayName((Context)op);
        if (link) {
            String id = ((BIHistory)node).getId().toString();
            out.w((Object)"<a href='#' onclick='chartBuilder.add(\"").w((Object)id);
            out.w((Object)"\", \"").safe((Object)displayName).w((Object)"\"); return false;'>");
        }
        out.safe((Object)displayName);
        if (link) {
            out.w((Object)"</a>");
        }
        BINavNode[] kids = node.getNavChildren();
        for (int i = 0; i < kids.length; ++i) {
            this.writeNode(kids[i], op);
        }
        out.w((Object)"</div>");
    }

    private void writeSelectionList(HxOp op) throws Exception {
        Lexicon lex = op.getLexicon("history");
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div class='controlShadow-bg'");
        out.w((Object)" style='font-weight: bold; color:white; padding: 5px; width: 100%;'>");
        out.safe((Object)lex.getText("chartBuilder.currentCharts"));
        out.w((Object)"</div>");
        out.w((Object)"<div style='padding: 5px; overflow: auto;'>");
        out.w((Object)"<table id='selectionList' width='100%' cellpadding='2'>");
        out.w((Object)"<tr><td></td></tr>");
        out.w((Object)"</table>");
        out.w((Object)"</div>");
    }

    public BWidget buildWidgetTree(Config config, HistoryItem[] items) {
        int i;
        boolean doRollup;
        BChartPane pane = new BChartPane();
        ArrayList<BChart> charts = new ArrayList<BChart>();
        BChart lastChart = null;
        boolean bl = doRollup = config.rollupInterval > 0L;
        if (config.title != null && config.title.length() > 0) {
            pane.getHeader().setTitle(config.title);
        }
        if (config.showGrid) {
            pane.getCanvas().setShowHorizontalGridLines(true);
            pane.getCanvas().setShowVerticalGridLines(true);
        }
        for (i = 0; i < items.length; ++i) {
            HistoryItem item = items[i];
            BTypeSpec chartType = BTypeSpec.make((String)item.chartType);
            BChart chart = null;
            if (lastChart == null || !lastChart.getType().getTypeSpec().equals((Object)chartType)) {
                chart = (BChart)chartType.getInstance();
                charts.add(chart);
                lastChart = chart;
            } else {
                chart = lastChart;
            }
            BTableChartBinding binding = new BTableChartBinding();
            BDynamicTimeRange timeRange = config.timeRange;
            StringBuffer buf = new StringBuffer();
            buf.append("history:" + item.historyId);
            buf.append("?").append(timeRange.toOrdParams());
            if (doRollup) {
                buf.append("|bql:history:HistoryRollup.rollup(baja:RelTime");
                buf.append(" '").append(config.rollupInterval).append("')");
            }
            binding.setOrd(BOrd.make((String)buf.toString()));
            binding.setXColumn(BColumnIdentifier.makeTableColumn((String)"timestamp"));
            binding.setYColumn(BColumnIdentifier.makeTableColumn((String)(doRollup ? config.rollupAlg : "value")));
            binding.setBrush(item.brush);
            if (doRollup) {
                binding.setXAxis((BAxisSpec)new BDiscreteAxisSpec());
            }
            chart.add(null, (BValue)binding);
        }
        for (i = 0; i < charts.size(); ++i) {
            pane.add(null, (BValue)charts.get(i));
        }
        return pane;
    }

    private String getFromCache(int key) {
        for (int i = 0; i < cache.size(); ++i) {
            CacheItem item = cache.get(i);
            if (item.key != key) continue;
            ++item.accessed;
            return item.xml;
        }
        return null;
    }

    private String pushInCache(int key, String xml) {
        CacheItem item = new CacheItem();
        item.key = key;
        item.xml = xml;
        while (cache.size() >= 10) {
            int index = -1;
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < cache.size(); ++i) {
                CacheItem check = cache.get(i);
                if (check.accessed >= min) continue;
                min = check.accessed;
                index = i;
            }
            cache.remove(index);
        }
        cache.add(item);
        return null;
    }

    public static void test() {
        BHxHistoryChartBuilder b = new BHxHistoryChartBuilder();
        BHxHistoryChartBuilder.verify(b.getFromCache(0) == null);
        b.pushInCache(0, "foo0");
        BHxHistoryChartBuilder.verify(b.getFromCache(0) != null);
        BHxHistoryChartBuilder.verifyAccess(0, 1);
        b.getFromCache(0);
        BHxHistoryChartBuilder.verifyAccess(0, 2);
        b.getFromCache(0);
        BHxHistoryChartBuilder.verifyAccess(0, 3);
        b.getFromCache(0);
        BHxHistoryChartBuilder.verifyAccess(0, 4);
        for (int i = 1; i < 100; ++i) {
            b.pushInCache(i, "foo" + i);
            BHxHistoryChartBuilder.verify(cache.size() <= 10);
        }
        CacheItem item = cache.get(0);
        BHxHistoryChartBuilder.verify(item.key == 0);
        BHxHistoryChartBuilder.verify(item.xml == "foo0");
        BHxHistoryChartBuilder.verify(item.accessed == 4);
        b.getFromCache(0);
        b.getFromCache(91);
        b.getFromCache(93);
        b.getFromCache(94);
        b.getFromCache(95);
        b.getFromCache(96);
        b.getFromCache(97);
        b.getFromCache(98);
        b.getFromCache(99);
        b.pushInCache(500, "foo500");
        BHxHistoryChartBuilder.verify(b.getFromCache(92) == null);
        BHxHistoryChartBuilder.verify(b.getFromCache(0) != null);
        BHxHistoryChartBuilder.verify(b.getFromCache(91) != null);
        BHxHistoryChartBuilder.verify(b.getFromCache(93) != null);
        BHxHistoryChartBuilder.verify(b.getFromCache(94) != null);
        BHxHistoryChartBuilder.verify(b.getFromCache(95) != null);
        BHxHistoryChartBuilder.verify(b.getFromCache(96) != null);
        BHxHistoryChartBuilder.verify(b.getFromCache(97) != null);
        BHxHistoryChartBuilder.verify(b.getFromCache(98) != null);
        BHxHistoryChartBuilder.verify(b.getFromCache(99) != null);
        BHxHistoryChartBuilder.verify(b.getFromCache(500) != null);
    }

    static void verify(boolean v) {
        if (!v) {
            throw new RuntimeException("Test failed!");
        }
    }

    static void verifyAccess(int index, int verifyCount) {
        BHxHistoryChartBuilder.verify(BHxHistoryChartBuilder.cache.get((int)index).accessed == verifyCount);
    }

    private class CacheItem {
        public int key;
        public String xml;
        public int accessed = 0;

        private CacheItem() {
        }
    }

    private class HistoryFilter
    implements IFilter {
        HxOp op;

        public HistoryFilter(HxOp op) {
            this.op = op;
        }

        public boolean accept(Object o) {
            if (!(o instanceof BIHistory)) {
                return false;
            }
            BIHistory history = (BIHistory)o;
            try {
                if (!this.op.getUser().getPermissionsFor((BIProtected)history).hasOperatorRead()) {
                    return false;
                }
                BTypeSpec recTypeSpec = history.getRecordType();
                Type type = recTypeSpec.getResolvedType();
                if (!type.is(BTrendRecord.TYPE)) {
                    return false;
                }
                BTrendRecord rec = (BTrendRecord)type.getInstance();
                return rec.getValueProperty().getType() != BString.TYPE;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    class Config {
        public BDynamicTimeRange timeRange;
        public String title;
        public boolean showGrid;
        public long rollupInterval;
        public String rollupAlg;

        Config() {
        }
    }

    class HistoryItem {
        public String historyId;
        public BBrush brush;
        public String chartType;
        public BAbsTime first;
        public BAbsTime last;

        HistoryItem() {
        }
    }

    class Build
    extends Command {
        public Build(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            int count = Integer.parseInt(op.getFormValue("count"));
            Config config = new Config();
            HistoryItem[] items = new HistoryItem[count];
            config.title = op.getFormValue("title");
            config.showGrid = op.getFormValue("showGrid").equals("true");
            config.timeRange = (BDynamicTimeRange)BHxDynamicTimeRangeFE.INSTANCE.save(op.make("timeRange", new OrdTarget((OrdTarget)op, (BObject)BDynamicTimeRange.DEFAULT)));
            config.rollupInterval = Long.parseLong(op.getFormValue("rollupInterval"));
            config.rollupAlg = op.getFormValue("rollupAlg");
            for (int i = 0; i < count; ++i) {
                String id = op.getFormValue(i + ".id");
                String col = op.getFormValue(i + ".color");
                String type = op.getFormValue(i + ".type");
                items[i] = new HistoryItem();
                items[i].historyId = id;
                items[i].brush = BBrush.make((String)col);
                items[i].chartType = type;
                if (config.timeRange != null) continue;
                BIHistory h = (BIHistory)BOrd.make((String)("history:" + id)).get();
                try (HistorySpaceConnection conn = ((BHistorySpace)h.getSpace()).getConnection(null);){
                    items[i].first = conn.getFirstTimestamp(h);
                    items[i].last = conn.getLastTimestamp(h);
                    continue;
                }
            }
            if (config.timeRange == null) {
                BAbsTime first = null;
                BAbsTime last = null;
                for (int i = 0; i < items.length; ++i) {
                    if (i == 0) {
                        first = items[i].first;
                        last = items[i].last;
                        continue;
                    }
                    first = items[i].first.isBefore(first) ? items[i].first : first;
                    last = items[i].last.isAfter(last) ? items[i].last : last;
                }
                config.timeRange = BDynamicTimeRange.make(first, last);
            }
            BWidget w = BHxHistoryChartBuilder.this.buildWidgetTree(config, items);
            if (lastId > 500000) {
                lastId = 0;
            }
            int id = lastId++;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PxEncoder encoder = new PxEncoder((OutputStream)out);
            encoder.encodeDocument(w);
            String xml = new String(out.toByteArray());
            BHxHistoryChartBuilder.this.pushInCache(id, xml);
            BOrd ord = BOrd.make((BOrd)op.getOrd(), (String)("view:history:HistoryChartBuilder?id=" + id));
            this.redirect(op, op.toUri(ord));
        }
    }
}

