/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.SigningUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JarFileSigner {
    private KeyStore keyStore;
    private String alias;
    private char[] password;
    private String tsa;

    public JarFileSigner(KeyStore keyStore, String alias, String password, String tsa) {
        this.keyStore = keyStore;
        this.alias = alias;
        this.password = password.toCharArray();
        this.tsa = tsa;
    }

    public void signFile(Path src) throws Exception {
        Path dest = Files.createTempFile("signjar_", ".working", new FileAttribute[0]);
        this.signFile(src, dest);
        Path bu = src.resolveSibling(src.getFileName() + ".bu");
        Files.move(src, bu, StandardCopyOption.REPLACE_EXISTING);
        try {
            Files.move(dest, src, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            Files.move(bu, src, StandardCopyOption.REPLACE_EXISTING);
            throw e;
        }
        finally {
            Files.deleteIfExists(bu);
        }
    }

    public void signFile(Path src, Path dest) throws Exception {
        try {
            Manifest manifest = new Manifest();
            byte[] mfBytes = null;
            boolean wasSigned = false;
            boolean mfModified = false;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            try (JarFile jarFile = new JarFile(src.toFile());
                 OutputStream out = Files.newOutputStream(dest, new OpenOption[0]);
                 BufferedOutputStream bout = new BufferedOutputStream(out);
                 ZipOutputStream zos = new ZipOutputStream(bout);){
                String bkFileName;
                String sfFileName;
                Key key;
                JarEntry mfEntry = jarFile.getJarEntry("META-INF/MANIFEST.MF");
                if (mfEntry != null) {
                    mfBytes = this.getBytes(jarFile, mfEntry);
                    manifest.read(new ByteArrayInputStream(mfBytes));
                } else {
                    Attributes mainAttr = manifest.getMainAttributes();
                    mainAttr.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
                    String javaVendor = System.getProperty("java.vendor");
                    String jdkVersion = System.getProperty("java.version");
                    mainAttr.putValue("Created-By", jdkVersion + " (" + javaVendor + ")");
                    mfEntry = new JarEntry("META-INF/MANIFEST.MF");
                    mfModified = true;
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName().toUpperCase();
                    if (name.startsWith("META-INF/") && (name.endsWith(".SF") || name.endsWith(".DSA") || name.endsWith(".RSA") || name.endsWith(".EC"))) {
                        wasSigned = true;
                        continue;
                    }
                    if (name.equals("META-INF/MANIFEST.MF") || entry.isDirectory()) continue;
                    if (manifest.getAttributes(entry.getName()) != null) {
                        if (!this.updateDigest(entry, manifest, jarFile, digest)) continue;
                        mfModified = true;
                        continue;
                    }
                    this.addDigest(entry, manifest, jarFile, digest);
                    mfModified = true;
                }
                if (mfModified) {
                    mfEntry = new JarEntry("META-INF/MANIFEST.MF");
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    manifest.write(bos);
                    if (wasSigned) {
                        byte[] newBytes = bos.toByteArray();
                        if (mfBytes != null) {
                            int origMainEnd;
                            int newMainEnd = this.getNextSectionEnd(newBytes, 0);
                            if (newMainEnd == (origMainEnd = this.getNextSectionEnd(mfBytes, 0))) {
                                System.arraycopy(mfBytes, 0, newBytes, 0, origMainEnd);
                            } else {
                                byte[] lastBytes = new byte[origMainEnd + newBytes.length - newMainEnd];
                                System.arraycopy(mfBytes, 0, lastBytes, 0, origMainEnd);
                                System.arraycopy(newBytes, newMainEnd, lastBytes, origMainEnd, newBytes.length - newMainEnd);
                                newBytes = lastBytes;
                            }
                        }
                        mfBytes = newBytes;
                    } else {
                        mfBytes = bos.toByteArray();
                    }
                }
                Manifest sigFile = this.generateSigFile(mfBytes, digest);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                sigFile.write(bos);
                byte[] sfBytes = bos.toByteArray();
                byte[] bkBytes = SigningUtil.generateSignature((byte[])sfBytes, (String)this.alias, (String)this.tsa, (char[])this.password, (KeyStore)this.keyStore);
                zos.putNextEntry(mfEntry);
                zos.write(mfBytes);
                try {
                    key = AccessController.doPrivileged(() -> this.keyStore.getKey(this.alias, this.password));
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
                if (!(key instanceof PrivateKey)) {
                    throw new SecurityException("not private key");
                }
                PrivateKey privateKey = (PrivateKey)key;
                String keyAlg = privateKey.getAlgorithm();
                int i = 0;
                do {
                    String sigFileBaseName = this.getSigFileName(this.alias, i);
                    sfFileName = "META-INF/" + sigFileBaseName + ".SF";
                    bkFileName = "META-INF/" + sigFileBaseName + "." + keyAlg;
                    ++i;
                } while (jarFile.getEntry(sfFileName) != null);
                ZipEntry sfFile = new ZipEntry(sfFileName);
                ZipEntry bkFile = new ZipEntry(bkFileName);
                long time = System.currentTimeMillis();
                sfFile.setTime(time);
                bkFile.setTime(time);
                zos.putNextEntry(sfFile);
                sigFile.write(zos);
                zos.putNextEntry(bkFile);
                zos.write(bkBytes);
                Enumeration<JarEntry> entries2 = jarFile.entries();
                while (entries2.hasMoreElements()) {
                    JarEntry entry = entries2.nextElement();
                    if (entry.getName().startsWith("META-INF/MANIFEST.MF") || entry.getName().equalsIgnoreCase(sfFileName) || entry.getName().equalsIgnoreCase(bkFileName)) continue;
                    this.writeEntry(jarFile, entry, zos);
                }
            }
        }
        catch (Exception e) {
            Files.deleteIfExists(dest);
            throw e;
        }
    }

    private synchronized byte[] getBytes(JarFile jarFile, JarEntry entry) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        try (BufferedInputStream is = new BufferedInputStream(jarFile.getInputStream(entry));){
            int n;
            baos.reset();
            for (long left = entry.getSize(); left > 0L && (n = ((InputStream)is).read(buffer, 0, buffer.length)) != -1; left -= (long)n) {
                baos.write(buffer, 0, n);
            }
        }
        return baos.toByteArray();
    }

    private boolean updateDigest(JarEntry entry, Manifest manifest, JarFile jarFile, MessageDigest digest) throws IOException {
        String digestName;
        String digestStr;
        Attributes attributes = manifest.getAttributes(entry.getName());
        String base64Digest = this.getDigest(entry, jarFile, digest);
        if (!base64Digest.equalsIgnoreCase(digestStr = attributes.getValue(digestName = digest.getAlgorithm() + "-Digest"))) {
            attributes.putValue(digestName, base64Digest);
            return true;
        }
        return false;
    }

    private String getDigest(JarEntry entry, JarFile jarFile, MessageDigest digest) throws IOException {
        byte[] buffer = new byte[8192];
        int n = 0;
        try (BufferedInputStream is = new BufferedInputStream(jarFile.getInputStream(entry));){
            for (long left = entry.getSize(); left > 0L && (n = ((InputStream)is).read(buffer, 0, buffer.length)) != -1; left -= (long)n) {
                digest.update(buffer, 0, n);
            }
        }
        return Base64.getEncoder().encodeToString(digest.digest());
    }

    private void addDigest(JarEntry entry, Manifest manifest, JarFile jarFile, MessageDigest digest) throws IOException {
        String base64Digest = this.getDigest(entry, jarFile, digest);
        Attributes attributes = new Attributes();
        attributes.putValue(digest.getAlgorithm() + "-Digest", base64Digest);
        manifest.getEntries().put(entry.getName(), attributes);
    }

    private int getNextSectionEnd(byte[] mfBytes, int offset) {
        int len = mfBytes.length;
        boolean allBlank = true;
        block4: for (int i = offset; i < len; ++i) {
            byte b = mfBytes[i];
            switch (b) {
                case 13: {
                    if (i < len && mfBytes[i + 1] == 10) {
                        ++i;
                    }
                    if (allBlank || i == len - 1) {
                        return i + 1;
                    }
                    allBlank = true;
                    continue block4;
                }
                case 10: {
                    if (allBlank || i == len - 1) {
                        return i + 1;
                    }
                    allBlank = true;
                    continue block4;
                }
                default: {
                    allBlank = false;
                }
            }
        }
        return -1;
    }

    private Manifest generateSigFile(byte[] mfBytes, MessageDigest digest) {
        Manifest sigFile = new Manifest();
        Attributes mainAttributes = sigFile.getMainAttributes();
        mainAttributes.putValue(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0");
        String version = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vendor");
        mainAttributes.putValue("Created-By", version + " (" + javaVendor + ")");
        mainAttributes.putValue(digest.getAlgorithm() + "-Digest-Manifest", this.getManifestDigest(mfBytes, digest));
        Map<String, Attributes> digests = this.getManifestEntryDigests(mfBytes, digest);
        Attributes mainAttributeDigest = digests.remove("Manifest-Main-Attributes");
        mainAttributes.putValue(digest.getAlgorithm() + "-Digest-Manifest-Main-Attributes", mainAttributeDigest.getValue(digest.getAlgorithm() + "-Digest"));
        Map<String, Attributes> entries = sigFile.getEntries();
        for (Map.Entry<String, Attributes> entry : digests.entrySet()) {
            entries.put(entry.getKey(), entry.getValue());
        }
        return sigFile;
    }

    private Map<String, Attributes> getManifestEntryDigests(byte[] mfBytes, MessageDigest digest) {
        HashMap<String, Attributes> digests = new HashMap<String, Attributes>();
        int len = 0;
        for (int offset = 0; offset < mfBytes.length && offset > -1; offset += len) {
            len = this.getNextSectionEnd(mfBytes, offset) - offset;
            String sectionName = this.extractSectionName(mfBytes, offset, len);
            if (sectionName == null) continue;
            digest.update(mfBytes, offset, len);
            String digestString = Base64.getEncoder().encodeToString(digest.digest());
            Attributes attr = new Attributes();
            attr.putValue(digest.getAlgorithm() + "-Digest", digestString);
            digests.put(sectionName, attr);
        }
        return digests;
    }

    private String extractSectionName(byte[] mfBytes, int offset, int len) {
        if (offset == 0) {
            return "Manifest-Main-Attributes";
        }
        if (!this.isNameAttr(mfBytes, offset, len)) {
            return null;
        }
        int nameLen = this.getEndOfFirstLine(mfBytes, offset) - offset + 1;
        StringBuilder nameBuilder = new StringBuilder(len);
        nameBuilder.append(new String(mfBytes, offset + 6, nameLen - 6, StandardCharsets.UTF_8));
        int i = offset + nameLen;
        i += mfBytes[i] == 13 ? 2 : 1;
        while (i - offset < len && mfBytes[i++] == 32) {
            int wrapStart = i;
            while (i - offset < len && mfBytes[i++] != 10) {
            }
            int wrapLen = i - wrapStart - (mfBytes[i - 2] == 13 ? 2 : 1);
            nameBuilder.append(new String(mfBytes, wrapStart, wrapLen, StandardCharsets.UTF_8));
        }
        return nameBuilder.toString();
    }

    private boolean isNameAttr(byte[] bytes, int start, int len) {
        if (len <= 6) {
            return false;
        }
        return !(bytes[start] != 78 && bytes[start] != 110 || bytes[start + 1] != 97 && bytes[start + 1] != 65 || bytes[start + 2] != 109 && bytes[start + 2] != 77 || bytes[start + 3] != 101 && bytes[start + 3] != 69 || bytes[start + 4] != 58 || bytes[start + 5] != 32);
    }

    private int getEndOfFirstLine(byte[] mfBytes, int offset) {
        int len = mfBytes.length;
        for (int i = offset; i < len; ++i) {
            if (mfBytes[i] != 13 && mfBytes[i] != 10) continue;
            return i - 1;
        }
        return -1;
    }

    private String getManifestDigest(byte[] mfBytes, MessageDigest digest) {
        digest.update(mfBytes, 0, mfBytes.length);
        return Base64.getEncoder().encodeToString(digest.digest());
    }

    private String getSigFileName(String alias, int index) {
        if (alias.length() > 8) {
            alias = alias.substring(0, 8);
        }
        alias = alias.toUpperCase();
        if (index > 0) {
            String indexString = String.valueOf(index);
            alias = alias.substring(0, alias.length() - indexString.length()) + indexString;
        }
        StringBuilder builder = new StringBuilder(alias.length());
        for (int j = 0; j < alias.length(); ++j) {
            int c = alias.charAt(j);
            if (!(c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 45 || c == 95)) {
                c = 95;
            }
            builder.append((char)c);
        }
        return builder.toString();
    }

    private void writeEntry(JarFile jarFile, JarEntry entry, ZipOutputStream zos) throws IOException {
        zos.putNextEntry(entry);
        try (BufferedInputStream in = new BufferedInputStream(jarFile.getInputStream(entry));){
            int n;
            byte[] buffer = new byte[8192];
            for (long left = entry.getSize(); left > 0L && (n = ((InputStream)in).read(buffer, 0, buffer.length)) != -1; left -= (long)n) {
                zos.write(buffer, 0, n);
            }
        }
    }
}

