/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.platcrypto.ui.BCertExportDialog;
import com.tridium.platcrypto.ui.BCertImportChooserDialog;
import com.tridium.platcrypto.ui.BCertImportDialog;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BExportResponse;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.workbench.util.WbUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.platCrypto.certs.BPEMCertificateHandler;
import javax.baja.security.PermissionException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.util.LexiconModule;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;

@NiagaraType
public class BTrustCertsTable
extends BCertsTable {
    public static final Type TYPE = Sys.loadType(BTrustCertsTable.class);
    protected ICoreTrustStore untrustedStore;
    private static final LexiconModule LEX = LexiconModule.make((String)"platCrypto");

    @Override
    public Type getType() {
        return TYPE;
    }

    public BTrustCertsTable() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BTrustCertsTable(ICoreCryptoManager mgr, ICoreTrustStore store) throws Exception {
        super(mgr, store);
    }

    public BTrustCertsTable(ICoreCryptoManager mgr, ICoreTrustStore store, ICoreTrustStore untrustedStore) throws Exception {
        super(mgr, store, new TrustCertModel(store, untrustedStore));
        this.untrustedStore = untrustedStore;
    }

    @Override
    protected void initCommands() {
        this.getCommandBindings().setSupport((CommandBindings.Support)this);
        BCertsTable.ViewCommand view = new BCertsTable.ViewCommand();
        this.addCommand(view, BCommandEnablePolicy.singleSelection);
        this.setDoubleClickCommand(view);
        try {
            if (!this.trustStore.isReadOnly()) {
                this.addCommand(new DeleteCommand(), BCommandEnablePolicy.anySelection);
                this.addCommand(new TrustImportCommand(), BCommandEnablePolicy.always);
                this.addCommand(new ApproveCommand(), BCommandEnablePolicy.anySelection);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addCommand(new ExportCommand(), BCommandEnablePolicy.singleSelection);
    }

    @Override
    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        int[] selectedRows = this.getSelection().getRows();
        if (command instanceof ApproveCommand && selectedRows.length > 0) {
            if (this.untrustedStore == null) {
                command.setEnabled(false);
                return;
            }
            for (int selectedRow : selectedRows) {
                if (((TrustCertModel)this.certModel()).untrustedCerts.contains(this.certModel().certs.get(selectedRow))) continue;
                command.setEnabled(false);
                return;
            }
            command.setEnabled(true);
        } else {
            command.setEnabled(bindingBasedState);
        }
    }

    protected static class TrustCertModel
    extends BCertsTable.CertModel {
        ICoreTrustStore untrusted;
        List<BCertsTable.CertificateRow> untrustedCerts;

        public TrustCertModel(ICoreTrustStore mgr, ICoreTrustStore untrusted) {
            super(mgr);
            this.untrusted = untrusted;
        }

        @Override
        public BImage getRowIcon(int row) {
            if (this.untrustedCerts.contains(this.certs.get(row))) {
                return BCertsTable.securityLow;
            }
            if (!this.cert(row).getCertificate(0).checkValidity()) {
                return BCertsTable.securityLow;
            }
            return BCertsTable.securityHigh;
        }

        @Override
        public void load() throws Exception {
            Enumeration e = this.mgr.getCertificates();
            this.certs = new Array(BCertsTable.CertificateRow.class);
            this.untrustedCerts = new ArrayList<BCertsTable.CertificateRow>();
            while (e.hasMoreElements()) {
                this.certs.add((Object)new BCertsTable.CertificateRow((NX509CertificateEntry)e.nextElement()));
            }
            if (this.untrusted != null) {
                e = this.untrusted.getCertificates();
                while (e.hasMoreElements()) {
                    BCertsTable.CertificateRow row = new BCertsTable.CertificateRow((NX509CertificateEntry)e.nextElement());
                    this.certs.add((Object)row);
                    this.untrustedCerts.add(row);
                }
            }
            this.updateTable(true);
        }
    }

    protected class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BTrustCertsTable.this, BCertsTable.lex, "cert.button.delete");
        }

        public CommandArtifact doInvoke() {
            if (!WbUtil.isSuperUser((BWidget)this.getOwner())) {
                throw new PermissionException(LEX.getText("cert.userTrustStore.superUserPermissionException", null, new Object[]{LEX.getText("cert.userTrustStore.deleteCommand", null)}));
            }
            try {
                if (4 == BDialog.confirm((BWidget)BTrustCertsTable.this, (String)BCertsTable.lex.getText("cert.delete.dialog.title"), (Object)BCertsTable.lex.getText("cert.delete.dialog.info"), (int)12)) {
                    int[] rows = BTrustCertsTable.this.getSelection().getRows();
                    NX509CertificateEntry[] certs = new NX509CertificateEntry[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        NX509CertificateEntry entry = BTrustCertsTable.this.certModel().cert(rows[i]);
                        String alias = entry.getAlias();
                        X509Certificate cert = entry.getCertificate(0).getCertificate();
                        BCertsTable.log.fine("request to delete alias " + alias);
                        if (alias.equals(BTrustCertsTable.this.trustStore.getCertificateAlias(cert))) {
                            BTrustCertsTable.this.trustStore.deleteEntry(entry.getAlias());
                        }
                        if (BTrustCertsTable.this.untrustedStore == null || !alias.equals(BTrustCertsTable.this.untrustedStore.getCertificateAlias(cert))) continue;
                        BTrustCertsTable.this.untrustedStore.deleteEntry(alias);
                    }
                    BTrustCertsTable.this.trustStore.save();
                    if (BTrustCertsTable.this.untrustedStore != null) {
                        BTrustCertsTable.this.untrustedStore.save();
                    }
                    BTrustCertsTable.this.certModel().load();
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class ApproveCommand
    extends Command {
        public ApproveCommand() {
            super((BWidget)BTrustCertsTable.this, BCertsTable.lex, "exemption.button.approve");
        }

        public String getTitle() {
            return "exempt.approve.dialog.title";
        }

        public String getInfo() {
            return "exempt.approve.dialog.info";
        }

        public CommandArtifact doInvoke() {
            int[] rows = BTrustCertsTable.this.getSelection().getRows();
            try {
                for (int i = 0; i < rows.length; ++i) {
                    this.importCertData(BTrustCertsTable.this.certModel().cert(rows[i]).getCertificates(), BTrustCertsTable.this.certModel().cert(rows[i]).getAlias());
                }
                BTrustCertsTable.this.trustStore.save();
                if (BTrustCertsTable.this.untrustedStore != null) {
                    BTrustCertsTable.this.untrustedStore.save();
                }
                BTrustCertsTable.this.certModel().load();
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }

        protected void importCertData(X509Certificate[] certs, String defaultAlias) throws Exception {
            for (X509Certificate cert : certs) {
                if (!NX509Certificate.isSelfSigned((X509Certificate)cert)) {
                    throw new IOException("certificate in the trust store must be root certificates");
                }
                String alias = BTrustCertsTable.this.trustStore.findCertificate(cert);
                if (alias == null) {
                    alias = defaultAlias;
                }
                NX509Certificate ncert = NX509Certificate.make((X509Certificate)cert);
                alias = BCertImportDialog.prompt(this.getOwner(), ncert, alias, BTrustCertsTable.this.trustStore, false);
                if (alias == null) continue;
                BTrustCertsTable.this.trustStore.setCertificateEntry(alias, cert);
            }
        }
    }

    protected class TrustImportCommand
    extends BCertsTable.ImportCommand {
        protected TrustImportCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CommandArtifact doInvoke() {
            block21: {
                if (!WbUtil.isSuperUser((BWidget)this.getOwner())) {
                    throw new PermissionException(LEX.getText("cert.userTrustStore.superUserPermissionException", null, new Object[]{LEX.getText("cert.userTrustStore.importCommand", null)}));
                }
                try {
                    BFileChooser chooser = BFileChooser.makeOpen((BWidget)this.getOwner());
                    chooser.setTitle(BCertsTable.lex.getText("cert.import.chooser.title"));
                    chooser.addFilter((IFileFilter)new ExtFileFilter(BCertsTable.lex.getText("cert.extension.info"), "pem,p12,crt,cer,cert"));
                    chooser.setCurrentDirectory(BOrd.make((String)("file:/" + BCertsTable.getCertsDirectoryPath())));
                    BOrd ord = chooser.show();
                    if (ord == null) {
                        return null;
                    }
                    BIFile importFile = (BIFile)ord.get();
                    if (importFile == null) break block21;
                    Array certs = new Array(X509Certificate.class);
                    InputStreamReader isr = new InputStreamReader(importFile.getInputStream());
                    FriendlyPemReader fpr = new FriendlyPemReader((Reader)isr);
                    PEMParser pr = new PEMParser((Reader)fpr);
                    try {
                        Object obj;
                        do {
                            try {
                                obj = pr.readObject();
                                if (obj != null) {
                                    if (obj instanceof X509Certificate) {
                                        certs.add((Object)((X509Certificate)obj));
                                    } else if (obj instanceof X509CertificateHolder) {
                                        X509Certificate cert = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)obj);
                                        certs.add((Object)cert);
                                    } else if (!(obj instanceof PEMKeyPair || obj instanceof PEMEncryptedKeyPair || obj instanceof PKCS8EncryptedPrivateKeyInfo)) {
                                        throw new IOException("unsupported object type: " + obj.getClass().getName());
                                    }
                                }
                            }
                            catch (PasswordException pe) {
                                BCertsTable.log.fine("skipping private key during trust store import");
                                obj = new Object();
                            }
                        } while (obj != null);
                    }
                    finally {
                        try {
                            pr.close();
                        }
                        catch (Exception obj) {}
                    }
                    String defAlias = importFile.getFileName();
                    defAlias = defAlias.substring(0, defAlias.length() - importFile.getExtension().length() - 1);
                    this.importCertData((Array<X509Certificate>)certs, null, defAlias);
                    BTrustCertsTable.this.trustStore.save();
                    BTrustCertsTable.this.certModel().load();
                }
                catch (EncryptionException ee) {
                    BDialog.error((BWidget)this.getOwner(), (Object)BCertsTable.lex.get("cert.import.privatekey.badpassword"));
                    return null;
                }
                catch (Exception e) {
                    CommandUtil.error((Command)this, (Throwable)e);
                }
            }
            return null;
        }

        @Override
        protected void importCertData(Array<X509Certificate> certs, PrivateKey pkey, String defaultAlias) throws Exception {
            List<Object> certificatesToAdd = new ArrayList();
            if (certs.size() > 1) {
                certificatesToAdd = BCertImportChooserDialog.prompt(this.getOwner(), certs);
            } else if (certs.size() == 1) {
                certificatesToAdd.add(NX509Certificate.make((X509Certificate)((X509Certificate)certs.first())));
            }
            for (NX509Certificate nX509Certificate : certificatesToAdd) {
                String alias = BTrustCertsTable.this.trustStore.findCertificate(nX509Certificate.getCertificate());
                if (alias == null) {
                    alias = nX509Certificate.getSubject();
                }
                if ((alias = BCertImportDialog.prompt(this.getOwner(), nX509Certificate, alias, BTrustCertsTable.this.trustStore, false)) == null) continue;
                BTrustCertsTable.this.trustStore.setCertificateEntry(alias, nX509Certificate.getCertificate());
            }
        }
    }

    protected class ExportCommand
    extends Command {
        public ExportCommand() {
            super((BWidget)BTrustCertsTable.this, BCertsTable.lex, "cert.button.export");
        }

        public CommandArtifact doInvoke() {
            try {
                int row = BTrustCertsTable.this.getSelection().getRow();
                try {
                    String alias = BTrustCertsTable.this.certModel().cert(row).getAlias();
                    X509Certificate cert = BTrustCertsTable.this.certModel().cert(row).getCertificate(0).getCertificate();
                    NX509Certificate ncert = NX509Certificate.make((X509Certificate)cert);
                    X509Certificate[] chain = BTrustCertsTable.this.trustStore.getCertificateChain(alias);
                    int keyMode = 0;
                    BExportResponse response = BCertExportDialog.show(this.getOwner(), ncert, keyMode);
                    if (response == null) {
                        return null;
                    }
                    BICertificateFormatHandler certFormatHandler = response.getCertFormatHandler();
                    if (certFormatHandler == null) {
                        certFormatHandler = BPEMCertificateHandler.INSTANCE;
                    }
                    BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
                    String fileName = alias + "." + certFormatHandler.getDefaultFileExtension();
                    chooser.setCurrentDirectory(BOrd.make((String)("file:/" + BCertsTable.certsDirectoryPath)));
                    chooser.setDefaultFileName(fileName);
                    chooser.setTitle(BCertsTable.lex.getText("cert.export.dialog.title"));
                    chooser.addFilter((IFileFilter)new ExtFileFilter(certFormatHandler.getCertificateFormatFileTypeName(null), String.join((CharSequence)",", certFormatHandler.getSupportedFileExtensions())));
                    BOrd ord = chooser.show();
                    if (ord == null) {
                        return null;
                    }
                    BAbstractFile target = (BAbstractFile)ord.get();
                    if (response.getExportCert()) {
                        if (chain == null) {
                            chain = new X509Certificate[]{cert};
                        }
                        certFormatHandler.writeCertToFile(chain, target);
                    }
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this.getOwner(), (String)BCertsTable.lex.getText("cert.export.error.title"), (Object)BCertsTable.lex.getText("cert.export.error.msg"), (Throwable)e);
                    e.printStackTrace();
                    return null;
                }
                BDialog.message((BWidget)this.getOwner(), (String)BCertsTable.lex.getText("cert.export.success.title"), (Object)BCertsTable.lex.getText("cert.export.success.msg"));
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }
}

