/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.platcrypto.ui.BExemptionChangedDialog;
import com.tridium.platcrypto.ui.BExemptionViewDialog;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.workbench.util.WbUtil;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.PermissionException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

public class BExemptionTable
extends BCommandBoundTable
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType(BExemptionTable.class);
    public static final int COL_HOST = 0;
    public static final int COL_SUBJECT = 1;
    public static final int COL_STATUS = 2;
    public static final int COL_CREATED = 3;
    public static final int COL_ISSUER = 4;
    public static final int COL_NOT_BEFORE = 5;
    public static final int COL_NOT_AFTER = 6;
    public static final int COL_KEY_ALG = 7;
    public static final int COL_KEY_SIZE = 8;
    public static final int COL_SIG_ALG = 9;
    public static final int COL_SIG_SIZE = 10;
    public static final int COL_VALID = 11;
    protected static Logger log = Logger.getLogger("crypto");
    public static final Lexicon lex = Lexicon.make((String)"platCrypto");
    private static final LexiconModule LEX = LexiconModule.make((String)"platCrypto");
    static final BImage securityHigh = BImage.make((String)lex.get("security.high.x16.icon", "module://icons/x16/security-high.png"));
    static final BImage securityMedium = BImage.make((String)lex.get("security.medium.x16.icon", "module://icons/x16/security-medium.png"));
    static final BImage securityLow = BImage.make((String)lex.get("security.low.x16.icon", "module://icons/x16/security-low.png"));
    protected ICoreExemptionStore store = null;
    protected boolean readonly = false;

    public Type getType() {
        return TYPE;
    }

    public BExemptionTable() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BExemptionTable(ICoreCryptoManager mgr, ICoreExemptionStore store) throws Exception {
        super((TableModel)new DynamicTableModel((TableModel)new ExemptionModel(mgr.getExemptionStore()), new int[]{0, 1, 2, 3, 4, 5, 6}));
        this.store = store;
        this.initCommands();
    }

    public void load() throws Exception {
        this.exemptModel().load();
    }

    protected void initCommands() {
        this.getCommandBindings().setSupport((CommandBindings.Support)this);
        ViewCommand view = new ViewCommand();
        this.addCommand(view, BCommandEnablePolicy.singleSelection);
        this.setDoubleClickCommand(view);
        this.addCommand(new ApproveCommand(), BCommandEnablePolicy.anySelection);
        this.addCommand(new UnapproveCommand(), BCommandEnablePolicy.anySelection);
        this.addCommand(new DeleteCommand(), BCommandEnablePolicy.anySelection);
    }

    protected ExemptionModel exemptModel() {
        DynamicTableModel model = (DynamicTableModel)this.getModel();
        return (ExemptionModel)model.getRootModel();
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean value) {
        this.readonly = value;
        this.setCommandEnabledStates();
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        if (this.readonly && (command instanceof ApproveCommand || command instanceof UnapproveCommand || command instanceof DeleteCommand)) {
            command.setEnabled(false);
        } else {
            CommandBindings.TableSelection table = (CommandBindings.TableSelection)this.getSelection();
            int[] selectedRows = table.getRows();
            if (selectedRows.length > 0 && command instanceof ApprovalCommand) {
                ApprovalCommand ac = (ApprovalCommand)command;
                DynamicTableModel model = (DynamicTableModel)this.getModel();
                ExemptionModel em = (ExemptionModel)model.getRootModel();
                boolean approve = true;
                for (int selectedRow : selectedRows) {
                    NHostExemption exemption = (NHostExemption)em.exemptions.get(selectedRow);
                    approve &= exemption.getApproved();
                }
                command.setEnabled(ac.isApproved() != approve);
            } else {
                command.setEnabled(bindingBasedState);
            }
        }
    }

    protected abstract class ApprovalCommand
    extends Command {
        public ApprovalCommand(BWidget owner, Lexicon lexicon, String keyBase) {
            super(owner, lexicon, keyBase);
        }

        public abstract String getTitle();

        public abstract String getInfo();

        public abstract boolean isApproved();

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BExemptionTable.this, (String)lex.getText(this.getTitle()), (Object)lex.getText(this.getInfo()), (int)12)) {
                    int[] rows = BExemptionTable.this.getSelection().getRows();
                    boolean madeChanges = false;
                    for (int row : rows) {
                        NHostExemption exemption = BExemptionTable.this.exemptModel().exemption(row);
                        boolean approved = this.isApproved();
                        if (approved == exemption.getApproved()) continue;
                        NHostExemption tExemption = NHostExemption.make((String)exemption.encodeToString());
                        tExemption.setApproved(approved);
                        BExemptionTable.this.store.setExemption(tExemption);
                        madeChanges = true;
                        exemption.setApproved(approved);
                    }
                    if (madeChanges) {
                        BExemptionTable.this.store.save();
                    }
                    BExemptionTable.this.exemptModel().load();
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class UnapproveCommand
    extends ApprovalCommand {
        public UnapproveCommand() {
            super((BWidget)BExemptionTable.this, lex, "exemption.button.unapprove");
        }

        @Override
        public String getTitle() {
            return "exempt.unapprove.dialog.title";
        }

        @Override
        public String getInfo() {
            return "exempt.unapprove.dialog.info";
        }

        @Override
        public boolean isApproved() {
            return false;
        }

        @Override
        public CommandArtifact doInvoke() {
            if (!WbUtil.isSuperUser((BWidget)this.getOwner())) {
                throw new PermissionException(LEX.getText("cert.exemptionStore.superUserPermissionException", null, new Object[]{LEX.getText("cert.exemptionStore.unapproveCommand", null)}));
            }
            return super.doInvoke();
        }
    }

    protected class ApproveCommand
    extends ApprovalCommand {
        public ApproveCommand() {
            super((BWidget)BExemptionTable.this, lex, "exemption.button.approve");
        }

        @Override
        public String getTitle() {
            return "exempt.approve.dialog.title";
        }

        @Override
        public String getInfo() {
            return "exempt.approve.dialog.info";
        }

        @Override
        public boolean isApproved() {
            return true;
        }

        @Override
        public CommandArtifact doInvoke() {
            if (!WbUtil.isSuperUser((BWidget)this.getOwner())) {
                throw new PermissionException(LEX.getText("cert.exemptionStore.superUserPermissionException", null, new Object[]{LEX.getText("cert.exemptionStore.approveCommand", null)}));
            }
            return super.doInvoke();
        }
    }

    protected class ViewCommand
    extends Command {
        public ViewCommand() {
            super((BWidget)BExemptionTable.this, lex, "exemption.button.view");
        }

        public CommandArtifact doInvoke() {
            try {
                int row = BExemptionTable.this.exemptModel().getSelection().getRow();
                NHostExemption exemption = BExemptionTable.this.exemptModel().exemption(row);
                if (exemption.getChanged() != null) {
                    if (BExemptionChangedDialog.show((BWidget)BExemptionTable.this, exemption)) {
                        exemption.approveChanged();
                        BExemptionTable.this.store.setExemption(exemption);
                        BExemptionTable.this.store.save();
                    }
                } else {
                    BExemptionViewDialog.show((BWidget)BExemptionTable.this, exemption);
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BExemptionTable.this, lex, "exemption.button.delete");
        }

        public CommandArtifact doInvoke() {
            if (!WbUtil.isSuperUser((BWidget)this.getOwner())) {
                throw new PermissionException(LEX.getText("cert.exemptionStore.superUserPermissionException", null, new Object[]{LEX.getText("cert.exemptionStore.deleteCommand", null)}));
            }
            try {
                if (4 == BDialog.confirm((BWidget)BExemptionTable.this, (String)lex.getText("exempt.delete.dialog.title"), (Object)lex.getText("exempt.delete.dialog.info"), (int)12)) {
                    int[] rows;
                    for (int row : rows = BExemptionTable.this.getSelection().getRows()) {
                        String host = BExemptionTable.this.exemptModel().exemption(row).getHost();
                        BExemptionTable.this.store.deleteExemption(host);
                    }
                    BExemptionTable.this.store.save();
                    BExemptionTable.this.exemptModel().load();
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    static class ExemptionModel
    extends TableModel {
        private Array<NHostExemption> exemptions = null;
        private ICoreExemptionStore mgr = null;

        public ExemptionModel(ICoreExemptionStore mgr) {
            this.mgr = mgr;
        }

        public BImage getRowIcon(int row) {
            if (!this.exemption(row).getApproved()) {
                return securityLow;
            }
            if (this.exemption(row).getChanged() != null || this.exemption(row).isTransient()) {
                return securityMedium;
            }
            return securityHigh;
        }

        public void load() throws Exception {
            Enumeration e = this.mgr.exemptions();
            this.exemptions = new Array(NHostExemption.class);
            while (e.hasMoreElements()) {
                this.exemptions.add(e.nextElement());
            }
            this.updateTable(true);
            this.getSelection().deselectAll();
        }

        public int getColumnCount() {
            return 12;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("exempt.field.host");
                }
                case 2: {
                    return lex.getText("exempt.field.approved");
                }
                case 3: {
                    return lex.getText("exempt.field.created");
                }
                case 4: {
                    return lex.getText("cert.field.issuedBy");
                }
                case 1: {
                    return lex.getText("cert.field.subject");
                }
                case 5: {
                    return lex.getText("cert.field.notBefore");
                }
                case 6: {
                    return lex.getText("cert.field.notAfter");
                }
                case 7: {
                    return lex.getText("cert.field.keyAlgorithm");
                }
                case 8: {
                    return lex.getText("cert.field.keySize");
                }
                case 9: {
                    return lex.getText("cert.field.signatureAlgorithm");
                }
                case 10: {
                    return lex.getText("cert.field.signatureSize");
                }
                case 11: {
                    return lex.getText("cert.field.valid");
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Object[] keys = this.getColumnValues(col);
            Object[] certs = (NHostExemption[])this.exemptions.trim();
            SortUtil.sort((Object[])keys, (Object[])certs, (boolean)ascending);
            this.exemptions.clear();
            this.exemptions.addAll(certs);
            this.updateTable(false);
        }

        public int getRowCount() {
            return this.exemptions != null ? this.exemptions.size() : 0;
        }

        public NHostExemption exemption(int row) {
            return (NHostExemption)this.exemptions.get(row);
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.exemption(row).getHost();
                }
                case 2: {
                    if (this.exemption(row).getApproved()) {
                        if (this.exemption(row).isTransient()) {
                            return lex.getText("exempt.field.approved.transient");
                        }
                        return lex.getText("exempt.field.approved.true");
                    }
                    return lex.getText("exempt.field.approved.false");
                }
                case 3: {
                    return this.exemption(row).getCreated();
                }
                case 4: {
                    return this.exemption(row).getCertificate().getIssuer();
                }
                case 1: {
                    return this.exemption(row).getCertificate().getSubject();
                }
                case 5: {
                    return this.exemption(row).getCertificate().getNotBefore();
                }
                case 6: {
                    return this.exemption(row).getCertificate().getNotAfter();
                }
                case 7: {
                    return this.exemption(row).getCertificate().getKeyAlgorithm();
                }
                case 8: {
                    return this.exemption(row).getCertificate().getKeySize() + "";
                }
                case 9: {
                    return this.exemption(row).getCertificate().getSignatureAlgorithm();
                }
                case 10: {
                    return this.exemption(row).getCertificate().getSignatureSize() + "";
                }
                case 11: {
                    return this.exemption(row).getCertificate().checkValidity() ? lex.getText("cert.field.valid.true") : lex.getText("cert.field.valid.false");
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

