/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NSigningParameters;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.platcrypto.ui.BCertificateExtension;
import com.tridium.platcrypto.ui.BCertificateExtensionFolderFE;
import com.tridium.platcrypto.ui.BCertificateSignerMultipleSelection;
import com.tridium.platcrypto.ui.BCertificateSigningRequest;
import com.tridium.platcrypto.ui.BCertificateSigningRequestManagerTable;
import com.tridium.platform.ui.util.CommandUtil;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BFileSpace;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTagDictionary;

@NiagaraType
public class BCertificateSigningRequestManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType(BCertificateSigningRequestManager.class);
    private static final Logger LOGGER = Logger.getLogger("CertificateGeneration");
    private static final Lexicon LEXICON = Lexicon.make((String)"platCrypto");
    private static final NX509Certificate[] EMPTY_NX509_CERTIFICATE_ARRAY = new NX509Certificate[0];
    private final BCertificateSignerMultipleSelection parent;
    private GenerateCmd generateCmd;

    public Type getType() {
        return TYPE;
    }

    public BCertificateSigningRequestManager(BCertificateSignerMultipleSelection parent) {
        this.parent = parent;
    }

    protected MgrTagDictionary makeTagDictionary() {
        return null;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public class GenerateCmd
    extends MgrController.MgrCommand {
        public GenerateCmd(BWidget owner) {
            super(owner, LEXICON.getText("bulk.cert.signer.tool.generate.command.label"));
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                NX509CertificateEntry certificateAuthority = this.makeCertificateAuthority();
                BDirectoryChooser directoryChooser = BDirectoryChooser.make((BWidget)this.getOwner());
                directoryChooser.setTitle(LEXICON.getText("bulk.cert.signer.tool.manager.directory.chooser.title"));
                BOrd ord = directoryChooser.show();
                if (ord == null) {
                    return null;
                }
                BAbstractFile csrOutputDirectory = (BAbstractFile)ord.get();
                BGridPane grid = new BGridPane(1);
                grid.add(null, (BValue)new BLabel(String.format(LEXICON.getText("bulk.cert.signer.tool.confirm.save.dialog.message"), csrOutputDirectory.getFilePath().getBody(), this.getRowCount())));
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)LEXICON.getText("bulk.cert.signer.tool.confirm.save.dialog.title"), (Object)new BBorderPane((BWidget)grid), (int)3)) {
                    int failureCount = this.generateCertificates(certificateAuthority, csrOutputDirectory);
                    BGridPane successGrid = new BGridPane(1);
                    if (failureCount > 0) {
                        successGrid.add(null, (BValue)new BLabel(String.format(LEXICON.getText("bulk.cert.signer.tool.save.dialog.result.message"), this.getRowCount(), this.getRowCount() - failureCount, failureCount)));
                    } else {
                        successGrid.add(null, (BValue)new BLabel(LEXICON.getText("bulk.cert.signer.tool.save.dialog.success.message")));
                    }
                    BDialog.open((BWidget)this.getOwner(), (String)LEXICON.getText("bulk.cert.signer.tool.save.dialog.result.title"), (Object)new BBorderPane((BWidget)successGrid), (int)1);
                }
            }
            catch (UnrecoverableKeyException e) {
                this.badPassword();
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }

        private int generateCertificates(NX509CertificateEntry certificateAuthority, BAbstractFile csrOutputDirectory) {
            int failureCount = 0;
            BICertificateFormatHandler certificateFormatHandler = BCertificateSigningRequestManager.this.parent.getCertificateFormatHandlerMap().get(BCertificateSigningRequestManager.this.parent.getSaveAsTypeText());
            for (BCertificateSigningRequest certificateSigningRequest : (BCertificateSigningRequest[])BCertificateSigningRequestManager.this.getModel().getTarget().getChildren(BCertificateSigningRequest.class)) {
                try {
                    this.generateCertificate(certificateSigningRequest, certificateAuthority, csrOutputDirectory, certificateFormatHandler);
                }
                catch (Exception e) {
                    String cause = String.format(LEXICON.getText("bulk.cert.signer.tool.save.dialog.warning.message"), certificateSigningRequest.getFilename(), e.getLocalizedMessage());
                    LOGGER.log(Level.WARNING, cause);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Cause is: " + cause, e);
                    }
                    ++failureCount;
                }
            }
            return failureCount;
        }

        private void generateCertificate(BCertificateSigningRequest certificateSigningRequest, NX509CertificateEntry certificateAuthority, BAbstractFile csrOutputDirectory, BICertificateFormatHandler certificateFormatHandler) throws Exception {
            Date notBefore = new Date(certificateSigningRequest.getNotBefore().getMillis());
            Date notAfter = new Date(certificateSigningRequest.getNotAfter().getMillis());
            NSigningParameters signingParameters = NSigningParameters.make((Date)notBefore, (Date)notAfter);
            for (BCertificateExtension certificateExtension : (BCertificateExtension[])certificateSigningRequest.getExtensions().getChildren(BCertificateExtension.class)) {
                if (!certificateExtension.getInclude()) continue;
                signingParameters.addExtension(certificateExtension.getNx509Extension());
            }
            NX509Certificate[] certificateChain = this.makeCertificateChain(certificateAuthority, certificateSigningRequest, signingParameters);
            BAbstractFile certificateFile = this.makeCertificateFile(csrOutputDirectory, certificateSigningRequest);
            if (certificateFile != null) {
                certificateFormatHandler.writeCertToFile(certificateChain, certificateFile);
            }
        }

        private NX509CertificateEntry makeCertificateAuthority() throws Exception {
            X509Certificate caCertificate = BCertificateSigningRequestManager.this.parent.getKeyStore().getCertificate(BCertificateSigningRequestManager.this.parent.getCaText());
            PrivateKey privateKey = (PrivateKey)BCertificateSigningRequestManager.this.parent.getKeyStore().getKey(BCertificateSigningRequestManager.this.parent.getCaText(), BCertificateSigningRequestManager.this.parent.getCaPasswordText().toCharArray());
            NX509CertificateEntry certificateAuthority = NX509CertificateEntry.make(null, (X509Certificate[])new X509Certificate[]{caCertificate}, (PrivateKey)privateKey);
            return certificateAuthority;
        }

        private NX509Certificate[] makeCertificateChain(NX509CertificateEntry certificateAuthority, BCertificateSigningRequest certificateSigningRequest, NSigningParameters signingParameters) throws Exception {
            X509Certificate[] certificateAuthorityChain = BCertificateSigningRequestManager.this.parent.getKeyStore().getCertificateChain(BCertificateSigningRequestManager.this.parent.getCaText());
            ArrayList<NX509Certificate> certificateChain = new ArrayList<NX509Certificate>();
            certificateChain.add(CertUtils.signCertificate((NPKCS10CertificationRequest)certificateSigningRequest.getCertificationRequest(), (NX509CertificateEntry)certificateAuthority, (NSigningParameters)signingParameters));
            for (X509Certificate certificate : certificateAuthorityChain) {
                certificateChain.add(NX509Certificate.make((X509Certificate)certificate));
            }
            return certificateChain.toArray(EMPTY_NX509_CERTIFICATE_ARRAY);
        }

        private BAbstractFile makeCertificateFile(BAbstractFile csrOutputDirectory, BCertificateSigningRequest certificateSigningRequest) throws IOException {
            BFileSpace fileSpace = (BFileSpace)csrOutputDirectory.getSpace();
            FilePath filePath = csrOutputDirectory.getFilePath();
            BAbstractFile certificateFile = (BAbstractFile)fileSpace.makeFile(new FilePath(filePath.getBody() + '/' + certificateSigningRequest.getFilename()));
            return certificateFile;
        }

        private void badPassword() {
            BDialog.error((BWidget)this.getOwner(), (String)LEXICON.getText("bulk.cert.signer.tool.password.error.title"), (Object)LEXICON.getText("bulk.cert.signer.tool.password.error.message"));
        }

        private int getRowCount() {
            return BCertificateSigningRequestManager.this.getModel().getTable().getModel().getRowCount();
        }
    }

    public static class ExtensionsColumnProperty
    extends MgrColumnProperty {
        public ExtensionsColumnProperty(Property prop, int flags) {
            super(prop, flags);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BCertificateExtensionFolderFE editor = (BCertificateExtensionFolderFE)ExtensionsColumnProperty.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])this.props);
            if (rows.length != 1) {
                editor.disable();
            }
            return editor;
        }
    }

    static class MgrColumnProperty
    extends MgrColumn.Prop {
        public MgrColumnProperty(Property prop, int flags) {
            super(prop, flags);
        }

        public Property getProperty() {
            return this.prop;
        }
    }

    class Edit
    extends MgrEdit {
        BCertificateSigningRequestManager manager;

        Edit(BAbstractManager manager, String label) {
            super(manager, label);
            this.manager = (BCertificateSigningRequestManager)manager;
        }

        public CommandArtifact commit() throws Exception {
            MgrEditRow[] rows = this.getRows();
            if (rows.length == 0) {
                return null;
            }
            BComponent container = this.getAddContainer();
            Context tx = Transaction.start((BComponent)container, null);
            for (MgrEditRow row : rows) {
                row.commit(tx);
            }
            Transaction.end((BComponent)container, (Context)tx);
            BCertificateSigningRequestManager.this.parent.setDuplicateFilenames((BCertificateSigningRequest[])this.manager.getModel().getTarget().getChildren(BCertificateSigningRequest.class));
            this.manager.getModel().getTable().reload();
            return null;
        }

        public boolean isReadonly(MgrEditRow[] selectedRows, MgrColumn col) {
            return false;
        }
    }

    class Controller
    extends MgrController {
        Controller(BCertificateSigningRequestManager manager) {
            super((BAbstractManager)manager);
            BCertificateSigningRequestManager.this.generateCmd = new GenerateCmd((BWidget)manager);
            BCertificateSigningRequestManager.this.generateCmd.setFlags(15);
        }

        public MgrEdit makeEdit(String label) {
            return new Edit(this.getManager(), label);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.edit, BCertificateSigningRequestManager.this.generateCmd};
        }

        public void updateCommands() {
            boolean hasSelections = this.getSelectedRows().length > 0;
            this.edit.setEnabled(hasSelections);
            BCertificateSigningRequestManager.this.generateCmd.setEnabled(!BCertificateSigningRequestManager.this.parent.hasWarnings());
        }
    }

    static class Model
    extends MgrModel {
        Model(BCertificateSigningRequestManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected BMgrTable makeTable() {
            return new BCertificateSigningRequestManagerTable(this);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            MgrColumn[] columns = new MgrColumn[]{new MgrColumnProperty(BCertificateSigningRequest.filename, 1), new MgrColumnProperty(BCertificateSigningRequest.subject, 1), new MgrColumnProperty(BCertificateSigningRequest.subjectDN, 4), new MgrColumnProperty(BCertificateSigningRequest.keyAlgorithm, 4), new MgrColumnProperty(BCertificateSigningRequest.keySize, 4), new MgrColumnProperty(BCertificateSigningRequest.signatureAlgorithm, 4), new MgrColumnProperty(BCertificateSigningRequest.signatureSize, 4), new MgrColumnProperty(BCertificateSigningRequest.verify, 4), new MgrColumnProperty(BCertificateSigningRequest.notBefore, 1), new MgrColumnProperty(BCertificateSigningRequest.notAfter, 1), new ExtensionsColumnProperty(BCertificateSigningRequest.extensions, 1)};
            return columns;
        }

        public int getSubscribeDepth() {
            return 3;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BCertificateSigningRequest.TYPE};
        }
    }
}

