/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.platcrypto.ui.BCertificateExtension;
import com.tridium.platcrypto.ui.BCertificateExtensionFolder;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.style.IStylable;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public final class BCertificateExtensionFolderFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BCertificateExtensionFolderFE.class);
    private static final Lexicon LEXICON = Lexicon.make((String)"platCrypto");

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        BScrollPane pane = new BScrollPane();
        pane.getHscrollBar().setUnitIncrement(15);
        pane.getHscrollBar().setBlockIncrement(150);
        pane.getVscrollBar().setUnitIncrement(15);
        pane.getVscrollBar().setBlockIncrement(150);
        BGridPane grid = new BGridPane(2);
        grid.setStretchColumn(1);
        grid.setColorRows(true);
        StyleUtils.addStyleClass((IStylable)grid, (String)"scrolled");
        grid.setColumnAlign(BHalign.fill);
        grid.setHalign(BHalign.left);
        if (value instanceof BCertificateExtensionFolder) {
            for (final BCertificateExtension certificateExtension : (BCertificateExtension[])((BCertificateExtensionFolder)value).getChildren(BCertificateExtension.class)) {
                Property include = certificateExtension.getProperty("include");
                boolean readonly = Flags.isReadonly((BComplex)certificateExtension, (Slot)include);
                BCheckBox checkBox = new BCheckBox("", certificateExtension.getInclude()){

                    public void changed(Property prop, Context cx) {
                        super.changed(prop, cx);
                        if (prop.getName() == "selected") {
                            certificateExtension.setInclude(this.isSelected());
                        }
                    }
                };
                checkBox.setEnabled(!readonly);
                grid.add(null, (BValue)new BBorderPane((BWidget)checkBox, 0.0, 10.0, 0.0, 10.0));
                grid.add(null, (BValue)BCertificateExtensionFolderFE.createExtensionPane(certificateExtension));
            }
        }
        pane.setContent((BWidget)new BBorderPane((BWidget)grid, 4.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)pane);
    }

    public void disable() {
        BGridPane grid = new BGridPane(1);
        grid.setHalign(BHalign.center);
        grid.setValign(BValign.center);
        BLabel label = new BLabel(LEXICON.getText("bulk.cert.signer.tool.cannot.edit.message"));
        grid.add("disabled", (BValue)new BBorderPane((BWidget)label, 0.0, 10.0, 0.0, 10.0));
        this.setContent((BWidget)new BBorderPane((BWidget)grid, 150.0, 0.0, 150.0, 0.0));
    }

    private static BEdgePane createExtensionPane(BCertificateExtension certificateExtension) {
        String[] extensionData;
        BEdgePane extensionDataPane = new BEdgePane();
        extensionDataPane.setTop(BCertificateExtensionFolderFE.createPaddedLabel(LEXICON.getText("bulk.cert.signer.tool.certificate.extension.identifier.label") + ' ' + certificateExtension.getIdentifier()));
        StringBuilder buf = new StringBuilder(LEXICON.getText("bulk.cert.signer.tool.certificate.extension.is.critical.label") + ' ' + (certificateExtension.getCritical() ? "true" : "false"));
        for (String data : extensionData = BCertificateExtension.EXTENSION_DATA_SPLIT_PATTERN.split(certificateExtension.getData())) {
            buf.append('\n');
            buf.append(data);
        }
        extensionDataPane.setCenter(BCertificateExtensionFolderFE.createPaddedLabel(buf.toString()));
        BConstrainedPane spacer = new BConstrainedPane();
        spacer.setMinWidth(16.0);
        extensionDataPane.setLeft((BWidget)spacer);
        return extensionDataPane;
    }

    private static BWidget createPaddedLabel(String text) {
        BLabel label = new BLabel(text, BHalign.left);
        label.setFont(Theme.label().getFixedWidthFont((IStylable)label));
        return new BBorderPane((BWidget)label, 2.0, 4.0, 2.0, 4.0);
    }
}

