/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Extension;
import com.tridium.platcrypto.ui.BCertificateExtensionFolder;
import java.util.Base64;
import java.util.regex.Pattern;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="include", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="identifier", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="critical", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="data", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="oid", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="octets", type="BString", defaultValue="", flags=1)})
public final class BCertificateExtension
extends BComponent {
    public static final Property include = BCertificateExtension.newProperty((int)1, (boolean)true, null);
    public static final Property identifier = BCertificateExtension.newProperty((int)1, (String)"", null);
    public static final Property critical = BCertificateExtension.newProperty((int)1, (boolean)false, null);
    public static final Property data = BCertificateExtension.newProperty((int)1, (String)"", null);
    public static final Property oid = BCertificateExtension.newProperty((int)1, (String)"", null);
    public static final Property octets = BCertificateExtension.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BCertificateExtension.class);
    private NX509Extension nx509Extension;
    public static final Pattern EXTENSION_DATA_SPLIT_PATTERN = Pattern.compile("::");

    public boolean getInclude() {
        return this.getBoolean(include);
    }

    public void setInclude(boolean v) {
        this.setBoolean(include, v, null);
    }

    public String getIdentifier() {
        return this.getString(identifier);
    }

    public void setIdentifier(String v) {
        this.setString(identifier, v, null);
    }

    public boolean getCritical() {
        return this.getBoolean(critical);
    }

    public void setCritical(boolean v) {
        this.setBoolean(critical, v, null);
    }

    public String getData() {
        return this.getString(data);
    }

    public void setData(String v) {
        this.setString(data, v, null);
    }

    public String getOid() {
        return this.getString(oid);
    }

    public void setOid(String v) {
        this.setString(oid, v, null);
    }

    public String getOctets() {
        return this.getString(octets);
    }

    public void setOctets(String v) {
        this.setString(octets, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCertificateExtension() {
    }

    public BCertificateExtension(NX509Extension nx509Extension) throws Exception {
        this.nx509Extension = nx509Extension;
        this.setIdentifier(nx509Extension.getIdentifier());
        this.setCritical(nx509Extension.isCritical());
        this.setData(String.join((CharSequence)EXTENSION_DATA_SPLIT_PATTERN.pattern(), nx509Extension.getExtensionText()));
        String oid = nx509Extension.getOid().getId();
        this.setOid(oid);
        byte[] octets = nx509Extension.getExtension().getExtnValue().getOctets();
        this.setOctets(Base64.getEncoder().encodeToString(octets));
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BCertificateExtensionFolder.TYPE);
    }

    public NX509Extension getNx509Extension() throws Exception {
        if (this.nx509Extension == null) {
            ASN1ObjectIdentifier asn1ObjectIdentifier = new ASN1ObjectIdentifier(this.getOid()).intern();
            byte[] octets = Base64.getDecoder().decode(this.getOctets());
            Extension extension = new Extension(asn1ObjectIdentifier, this.getCritical(), octets);
            this.nx509Extension = new NX509Extension(extension);
        }
        return this.nx509Extension;
    }
}

