/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509Extension;
import com.tridium.platcrypto.ui.BCryptoDialog;
import com.tridium.platcrypto.ui.BX509CertificatePane;
import com.tridium.platcrypto.ui.BX509ExtensionPane;
import java.security.cert.X509Certificate;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.util.ASN1Dump;

public class BCertViewDialog
extends BCryptoDialog {
    public static final Type TYPE = Sys.loadType(BCertViewDialog.class);
    protected static Lexicon lex = Lexicon.make((String)"platCrypto");
    protected static BImage logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    protected NX509Certificate cert;
    protected BButton okButton;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static void show(BWidget owner, NX509Certificate cert) throws Exception {
        BCertViewDialog dialog = new BCertViewDialog(owner, cert);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
    }

    protected BCertViewDialog(BWidget parent, String title) throws Exception {
        super(parent, title);
    }

    protected BCertViewDialog(BWidget parent, NX509Certificate cert) throws Exception {
        this(parent, lex.getText("cert.view.dialog.title"));
        this.cert = cert;
        ASN1Dump asn1 = new ASN1Dump();
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    @Override
    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.cert.getSubject(), lex.getText("cert.view.dialog.info", new Object[]{this.cert.getSubject()}));
    }

    @Override
    protected BWidget buildBody() throws Exception {
        BGridPane body = new BGridPane(1);
        body.setStyleClasses("scrolled");
        body.setStretchColumn(0);
        body.setColumnAlign(BHalign.fill);
        body.add(null, (BValue)new BBorderPane(this.createHeaderLabel(lex.getText("cert.dialog.properties") + ":")));
        body.add(null, (BValue)new BBorderPane(this.buildProperties(), 0.0, 0.0, 0.0, 0.0));
        NX509Extension[] extensions = this.cert.getExtensions();
        if (extensions.length > 0) {
            body.add(null, (BValue)new BBorderPane(this.createHeaderLabel(lex.getText("cert.dialog.extensions") + ":")));
            body.add(null, (BValue)new BBorderPane(this.buildExtensions(), 0.0, 0.0, 0.0, 0.0));
        }
        BScrollPane scroll = new BScrollPane((BWidget)body);
        Size size = this.getCertViewSize();
        BTabbedPane tabs = new BTabbedPane();
        tabs.addPane(lex.getText("cert.view.dialog.tab.table"), (BWidget)scroll);
        tabs.addPane(lex.getText("cert.view.dialog.tab.asn1"), (BWidget)new BTextEditorPane(new BTextEditor(NX509Certificate.getASN1String((X509Certificate)this.cert.getCertificate()), false)));
        tabs.addPane(lex.getText("cert.view.dialog.tab.pem"), (BWidget)new BTextEditorPane(new BTextEditor(this.cert.encodeToString(), false)));
        BConstrainedPane constrained = new BConstrainedPane((BWidget)tabs, size.width, size.height);
        constrained.setMinWidth(500.0);
        return constrained;
    }

    protected Size getCertViewSize() {
        return new Size(600.0, 400.0);
    }

    protected BWidget buildProperties() {
        BX509CertificatePane certPane = new BX509CertificatePane(this.cert);
        return certPane;
    }

    protected BWidget buildExtensions() throws Exception {
        BX509ExtensionPane extensionPane = new BX509ExtensionPane();
        extensionPane.setExtensions(this.cert.getExtensions(), false);
        return extensionPane;
    }

    @Override
    protected BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(1);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    @Override
    public void doOkButtonPressed(BWidgetEvent event) {
        this.close();
    }
}

