/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.core.ICryptoManagerProvider;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platcrypto.ui.BExemptionTable;
import com.tridium.platcrypto.ui.BLocalCertsTable;
import com.tridium.platcrypto.ui.BTrustCertsTable;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.shell.BScrollingWidgetPane;
import com.tridium.workbench.shell.WbMain;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BISession;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.tool.BWbTool;
import javax.baja.workbench.view.BWbComponentView;

public class BCertManagerView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BCertManagerView.class);
    private static final int BUTTONS_PER_ROW = 4;
    public static final Lexicon lex = Lexicon.make((String)"platCrypto");
    protected BLabel titleLabel;
    protected BLabel systemCaDescription;
    protected BLabel userCaDescription;
    protected BEdgePane systemCaCertsPane;
    protected BEdgePane userCaCertsPane;
    protected BGridPane userCaCertsButtons;
    protected BGridPane systemCaCertsButtons;
    protected BLabel serverCertsDescription;
    protected BEdgePane serverCertsPane;
    protected BGridPane serverCertsButtons;
    protected BEdgePane exemptionsPane;
    protected BLabel exemptionsDescription;
    protected BGridPane exemptionsButtons;
    protected BLabel clientKeysDescription;
    protected BEdgePane clientKeysPane;
    protected BGridPane clientKeysButtons;
    protected BTabbedPane tabbedPane = new BTabbedPane();
    ICoreCryptoManager mgr = null;

    public Type getType() {
        return TYPE;
    }

    public BCertManagerView() {
        this.systemCaCertsButtons = new BGridPane(1);
        this.userCaCertsButtons = new BGridPane(1);
        this.serverCertsButtons = new BGridPane(1);
        this.exemptionsButtons = new BGridPane(1);
        this.systemCaDescription = new BLabel(lex.getText("systemcacert.view.tab.description"), Theme.widget().getBoldText());
        this.systemCaCertsPane = new BEdgePane();
        this.systemCaCertsPane.setTop((BWidget)new BBorderPane(this.left((BWidget)this.systemCaDescription)));
        this.userCaDescription = new BLabel(lex.getText("usercacert.view.tab.description"), Theme.widget().getBoldText());
        this.userCaCertsPane = new BEdgePane();
        this.userCaCertsPane.setTop((BWidget)new BBorderPane(this.left((BWidget)this.userCaDescription)));
        this.serverCertsDescription = new BLabel(lex.getText("cert.view.tab.description"), Theme.widget().getBoldText());
        this.serverCertsPane = new BEdgePane();
        this.serverCertsPane.setTop((BWidget)new BBorderPane(this.left((BWidget)this.serverCertsDescription)));
        this.exemptionsDescription = new BLabel(lex.getText("exempt.view.tab.description"), Theme.widget().getBoldText());
        this.exemptionsPane = new BEdgePane();
        this.exemptionsPane.setTop((BWidget)new BBorderPane(this.left((BWidget)this.exemptionsDescription)));
        BEdgePane viewPane = new BEdgePane();
        this.titleLabel = new BLabel("", BHalign.left);
        viewPane.setTop((BWidget)new BBorderPane((BWidget)this.titleLabel, 0.0, 0.0, 10.0, 0.0));
        this.titleLabel.setFont(Theme.label().getLargeBoldFont());
        viewPane.setCenter((BWidget)this.tabbedPane);
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(null), (BWidget)new BBorderPane((BWidget)viewPane)));
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BTrustCertsTable userCaCerts;
        int rc;
        String label = "";
        if (value instanceof ICryptoManagerProvider) {
            ICryptoManagerProvider icmp = (ICryptoManagerProvider)value;
            this.mgr = icmp.getCoreCryptoManager();
            if (value instanceof BCertManagerService) {
                ((BCertManagerService)value).poll();
            }
            if (icmp instanceof BWbTool) {
                label = lex.get("CertManagerView.longTitle") + " " + WbMain.brandTitle;
            } else if (icmp instanceof BComponent) {
                BISession session = ((BComponent)icmp).getSession();
                label = lex.get("CertManagerView.longTitle") + " \"" + session.getHost() + "\"";
            } else {
                label = lex.get("CertManagerView.shortTitle");
            }
        } else if (value instanceof BDaemonSession) {
            this.mgr = new BPlatCryptoManager((BDaemonSession)value);
            label = lex.get("CertManagerView.longTitle") + " \"" + ((BDaemonSession)value).getHost() + "\"";
        }
        if (!this.mgr.isSecure() && (rc = BDialog.open((BWidget)this, (String)lex.getText("nonsecure.warning.dialog.title"), (Object)lex.getText("nonsecure.warning.dialog.msg"), (int)12, (BImage)BDialog.WARNING_ICON, (String)null)) == 8) {
            throw new Exception("non-secure connection aborted");
        }
        if (!CertUtils.hasUnrestrictedPolicyFiles()) {
            BDialog.warning((BWidget)this, (String)lex.getText("unlimited.strength.title"), (Object)lex.getText("unlimited.strength.msg"));
        }
        this.titleLabel.setText(label);
        BLocalCertsTable serverCerts = new BLocalCertsTable(this.mgr, this.mgr.getKeyStore());
        this.loadPane(this.serverCertsPane, serverCerts, this.serverCertsButtons, this.tabbedPane, "cert.view.tab.title", cx);
        serverCerts.load();
        BTrustCertsTable systemCaCerts = new BTrustCertsTable(this.mgr, this.mgr.getSystemTrustStore());
        this.loadPane(this.systemCaCertsPane, systemCaCerts, this.systemCaCertsButtons, this.tabbedPane, "systemcacert.view.tab.title", cx);
        systemCaCerts.load();
        ICoreTrustStore untrustedStore = this.mgr.getUserUntrustedStore();
        try {
            untrustedStore.size();
            userCaCerts = new BTrustCertsTable(this.mgr, this.mgr.getUserTrustStore(), this.mgr.getUserUntrustedStore());
        }
        catch (Exception e) {
            userCaCerts = new BTrustCertsTable(this.mgr, this.mgr.getUserTrustStore());
        }
        this.loadPane(this.userCaCertsPane, userCaCerts, this.userCaCertsButtons, this.tabbedPane, "usercacert.view.tab.title", cx);
        userCaCerts.load();
        BExemptionTable exemptions = new BExemptionTable(this.mgr, this.mgr.getExemptionStore());
        this.loadPane(this.exemptionsPane, exemptions, this.exemptionsButtons, this.tabbedPane, "exempt.view.tab.title", cx);
        exemptions.load();
    }

    private void loadPane(BEdgePane pane, BCommandBoundTable table, BGridPane buttons, BTabbedPane tabbedPane, String title, Context cx) throws Exception {
        BGridPane commandPane = this.buildCommandPane(buttons, table.getCommands());
        BTitlePane titlePane = BTitlePane.makePane((String)lex.getText(title), (BTable)table);
        this.makeButtonBorder(titlePane, commandPane);
        pane.setCenter((BWidget)new BBorderPane((BWidget)titlePane, BInsets.make((double)0.0, (double)7.0, (double)7.0, (double)7.0)));
        this.addTab(tabbedPane, (BWidget)pane, title, cx);
    }

    private void addTab(BTabbedPane pane, BWidget widget, String title, Context cx) {
        pane.addPane(new BLabel(LexiconText.make((Type)TYPE, (String)title).getText(cx), Theme.widget().getBoldText()), widget);
    }

    private void makeButtonBorder(BTitlePane title, BGridPane buttons) {
        BBorderPane buttonBorder = new BBorderPane((BWidget)buttons);
        buttonBorder.setPadding(BInsets.make((double)5.0, (double)0.0, (double)5.0, (double)0.0));
        title.setBottom((BWidget)new BScrollingWidgetPane((BWidget)buttonBorder));
    }

    private BGridPane buildCommandPane(BGridPane gridPane, Command[] commands) {
        gridPane.removeAll();
        BButtonPane buttons = new BButtonPane();
        gridPane.setColumnAlign(BHalign.center);
        gridPane.add("buttons0", (BValue)buttons);
        for (int i = 0; i < commands.length; ++i) {
            if (i > 0 && i % 4 == 0) {
                buttons = new BButtonPane();
                gridPane.add("buttons" + i, (BValue)buttons);
            }
            buttons.add(commands[i]);
        }
        return gridPane;
    }

    private BWidget left(BWidget content) {
        BGridPane result = new BGridPane(1);
        result.setHalign(BHalign.left);
        result.setColumnAlign(BHalign.left);
        result.add(null, (BValue)content);
        return result;
    }
}

