/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.comm.protocol;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.comm.tcp.TcpLinkLayer;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.flag.MicrosMessageFlag;
import com.tridiumemea.micros.datatype.BMicrosIpAddress;
import com.tridiumemea.micros.enums.BMicrosLinkStatusEnum;
import com.tridiumemea.micros.message.linkdown.MicrosLinkEndRequest;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinkShutdownUtil {
    private final BMicrosNetwork network;
    private static final String SEND_LE = "Sending shutdown LE to server ";
    private static final String ME = "sendLinkEndToConnectedServer:";

    private LinkShutdownUtil() {
        throw new IllegalArgumentException("Needs Network");
    }

    public LinkShutdownUtil(BMicrosNetwork network) {
        Objects.requireNonNull(network);
        this.network = network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLinkEndToConnectedServer() {
        Logger log = this.network.log();
        boolean linkWasActive = this.network.getLinkStatus().isLinkActive() || this.network.getLinkStatus().isLinkActivating();
        log.finest(() -> "sendLinkEndToConnectedServer:linkWasActive: " + linkWasActive);
        if (this.network.getLinkConfig().getInhibitLinkEndNextShutdown()) {
            log.info("sendLinkEndToConnectedServer:Not sending LinkEnd [LE] whilst InhibitLinkEndNextShutdown property is true");
        } else if (this.network.getEnabled() && linkWasActive) {
            BMicrosIpAddress addr = this.network.getDevice().getCurrentAddress();
            if (addr == null) {
                throw new IllegalStateException("Cannot LinkEnd, Current IP Address Unknown");
            }
            MicrosLinkEndRequest LE_request = new MicrosLinkEndRequest(addr);
            if (log.isLoggable(Level.FINE)) {
                log.fine(SEND_LE + (Object)((Object)addr) + ':' + (Object)((Object)LE_request));
            }
            this.network.getEventListener().factoryFlags.raise(MicrosMessageFlag.Flag.LINK_END);
            try {
                this.network.getTcpConfig().tcomm().sendRequest((NMessage)LE_request);
            }
            catch (Exception e) {
                String s = SEND_LE + ' ' + (Object)((Object)LE_request) + ' ' + (Object)((Object)addr);
                log.log(Level.WARNING, s, e);
            }
            finally {
                this.network.getEventListener().factoryFlags.lower(MicrosMessageFlag.Flag.LINK_END);
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("sendLinkEndToConnectedServer:Not if network is " + (this.network.getEnabled() ? "enabled" : "disabled") + " & link is " + (Object)((Object)this.network.getLinkStatus()));
        }
    }

    public void commonLinkDownSteps(String pingFailText) {
        this.network.log().fine(() -> "commonLinkDownSteps: " + pingFailText);
        this.closeCurrentSession();
        this.network.getDsUtil().cancelAnyActiveJob();
        this.network.getSockUtil().cancelCommInhibitTimer();
        this.network.getSockUtil().raiseSocketHandshakeRequiredFlags();
        this.network.setLinkStatus(BMicrosLinkStatusEnum.notActive);
        this.network.getDevice().pingFail(pingFailText);
    }

    private void closeCurrentSession() {
        if (this.network.isDisabled()) {
            return;
        }
        TcpLinkLayer linkLayer = (TcpLinkLayer)this.network.getTcpConfig().tcomm().getLinkLayer();
        int sessionId = this.network.getDevice().getAddress().getSessionId();
        try {
            linkLayer.closeSession(sessionId);
        }
        catch (Exception e) {
            this.network.log().log(Level.INFO, "Closing current session", e);
        }
        this.network.log().finest(() -> "Closed session: {" + sessionId + '}');
    }
}

