/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.comm.protocol;

import com.tridiumemea.micros.BMicrosNetwork;
import java.util.Objects;
import java.util.logging.Level;
import javax.baja.util.Lexicon;

public class LinkRestartUtil {
    private Thread oldRestartReference;
    private static final Lexicon lex = Lexicon.make(BMicrosNetwork.class);
    private final BMicrosNetwork net;
    private static final String NIAGARA_RESTARTS_LINK = lex.getText("network.restart");
    private static final long ONE_SECOND = 1000L;

    private LinkRestartUtil() {
        throw new IllegalArgumentException("Needs Network");
    }

    public LinkRestartUtil(BMicrosNetwork net) {
        Objects.requireNonNull(net);
        this.net = net;
    }

    public void restartLink() {
        if (!this.net.isDisabled()) {
            Thread newLinkRestartAttempt = new Thread(this.net.getNetworkName() + ":restartMicrosLink"){

                @Override
                public void run() {
                    try {
                        LinkRestartUtil.this.net.log().fine(Thread.currentThread().getName() + ": ending link");
                        LinkRestartUtil.this.net.getShutdownUtil().sendLinkEndToConnectedServer();
                        LinkRestartUtil.this.net.getShutdownUtil().commonLinkDownSteps(NIAGARA_RESTARTS_LINK);
                        Thread.sleep(1000L);
                        if (LinkRestartUtil.this.net.getLinkStatus().isLinkActivating() && LinkRestartUtil.this.oldRestartReference != null) {
                            LinkRestartUtil.this.net.log().fine("Interrupting last connection attempt " + LinkRestartUtil.this.oldRestartReference);
                            LinkRestartUtil.this.oldRestartReference.interrupt();
                        }
                        LinkRestartUtil.this.oldRestartReference = this;
                        Thread.sleep(1000L);
                        LinkRestartUtil.this.net.log().fine(Thread.currentThread().getName() + " :restartLink: Calls socket handshake");
                        if (LinkRestartUtil.this.net.isDisabled() || LinkRestartUtil.this.net.isFatalFault()) {
                            LinkRestartUtil.this.net.log().info("LinkRestartUtil: Cannot reactivate link whilst disabled or fatal fault");
                            return;
                        }
                        try {
                            LinkRestartUtil.this.net.getSockUtil().socketHandshake();
                        }
                        catch (Exception e) {
                            LinkRestartUtil.this.net.getShutdownUtil().commonLinkDownSteps("socketHandshake: " + e.getMessage());
                        }
                        LinkRestartUtil.this.oldRestartReference = null;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }

                @Override
                public void interrupt() {
                    super.interrupt();
                    if (LinkRestartUtil.this.net.log().isLoggable(Level.FINE)) {
                        LinkRestartUtil.this.net.log().log(Level.FINE, "Interrupted Link Restart", new Exception());
                    }
                    LinkRestartUtil.this.net.getShutdownUtil().commonLinkDownSteps("Restart Attempt Interrupted");
                }
            };
            this.net.getAsync().post((Runnable)newLinkRestartAttempt);
        }
    }
}

