/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.comm;

import com.tridium.ndriver.comm.IMessageFactory;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.datatypes.BTcpCommConfig;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.MicrosLinkMessage;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.message.MicrosMessage;
import com.tridiumemea.micros.message.MicrosMessageFactory;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
public final class BMicrosTcpCommConfig
extends BTcpCommConfig {
    public static final Property serverSocketTO = BMicrosTcpCommConfig.newProperty((int)5, (int)0, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"second")));
    public static final Property address = BMicrosTcpCommConfig.newProperty((int)5, (BValue)new BIpAddress("local", 0), null);
    public static final Property sendSocketTO = BMicrosTcpCommConfig.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"second")));
    public static final Type TYPE = Sys.loadType(BMicrosTcpCommConfig.class);
    private BMicrosNetwork network;

    public Type getType() {
        return TYPE;
    }

    public int getMaxOutstandingTransactions() {
        return 1;
    }

    protected NLinkMessageFactory makeLinkMessageFactory() {
        return new NLinkMessageFactory(138){

            protected LinkMessage createLinkMessage() {
                return new MicrosLinkMessage();
            }
        };
    }

    protected IMessageFactory makeMessageFactory() {
        return new MicrosMessageFactory((BMicrosNetwork)this.getParent());
    }

    public NComm tcomm() {
        return (NComm)this.comm();
    }

    public void ccStarted() {
        this.network = (BMicrosNetwork)this.getParent();
    }

    public void checkAndFormatMsg(MicrosMessage msg) {
        if (this.network.getDsUtil().isCachedJobAlive()) {
            throw new IllegalStateException("Database Sync Currently Active");
        }
        msg.setResponseTimeOut((int)this.network.getLinkConfig().getMsgResponseTimeout().getMillis());
        msg.setRetryCount(this.network.getLinkConfig().getMsgRetryCount());
    }

    public boolean isParentLegal(BComponent parent) {
        return CommonUtil.isParentLegal((BComplex)parent, (BComplex)this, BMicrosNetwork.TYPE);
    }
}

