/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.messages.LonIpMessage;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class SendList
extends LonIpMessage {
    public BDateTime dateTime;
    public BIpAddress[] ips;
    public int[] ports;

    public SendList() {
        this.packetType = 6;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("dateTime=").append((Object)this.dateTime).append("\n");
        for (int i = 0; i < this.ips.length; ++i) {
            sb.append((Object)this.ips[i]).append(":").append(this.ports[i]);
        }
        return sb.toString();
    }

    @Override
    public void fromInputStream(LonInputStream in) throws LonException {
        this.dateTime = BDateTime.fromInputStream(in);
        int numPairs = in.readUnsigned8();
        in.readUnsigned8();
        in.readUnsigned16();
        this.ips = new BIpAddress[numPairs];
        this.ports = new int[numPairs];
        for (int i = 0; i < numPairs; ++i) {
            this.ips[i] = BIpAddress.fromInputStream(in);
            this.ports[i] = in.readUnsigned16();
            in.readUnsigned16();
        }
    }

    @Override
    public void toOutputStream(LonOutputStream out) {
        this.dateTime.toOutputStream(out);
        int numPairs = this.ips.length;
        out.writeUnsigned8(numPairs);
        out.writeUnsigned8(0);
        out.writeUnsigned16(0);
        for (int i = 0; i < numPairs; ++i) {
            this.ips[i].toOutputStream(out);
            out.writeUnsigned16(this.ports[i]);
            out.writeUnsigned16(0);
        }
    }
}

