/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonIp.BLonIpNetwork;
import com.tridium.lonIp.ConfigServer;
import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonCommConfig;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.util.MemberAction;
import com.tridium.lonworks.util.NmUtil;
import java.net.InetAddress;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMemberTable
extends BComponent {
    public static final Property timeStamp = BMemberTable.newProperty((int)1, (BValue)BDateTime.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BMemberTable.class);
    private MemberAction ma = null;
    public static final Context internalChange = new BasicContext();

    public BDateTime getTimeStamp() {
        return (BDateTime)this.get(timeStamp);
    }

    public void setTimeStamp(BDateTime v) {
        this.set(timeStamp, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void added(Property p, Context cx) {
        if (!this.isRunning() || cx == internalChange) {
            return;
        }
        BChannelMember newCm = (BChannelMember)this.get(p);
        ConfigServer cs = ((BIpChannel)this.getParent()).getConfigServer();
        cs.addMember(newCm);
    }

    public void removed(Property p, BValue oldValue, Context cx) {
        if (!this.isRunning() || cx == internalChange) {
            return;
        }
        BChannelMember newCm = (BChannelMember)oldValue;
        ConfigServer cs = ((BIpChannel)this.getParent()).getConfigServer();
        cs.removeMember(newCm);
    }

    public BChannelMember[] getChannelMembers() {
        BChannelMember[] temp = new BChannelMember[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BChannelMember.class)) {
            BValue kid = c.get();
            temp[count++] = (BChannelMember)kid;
        }
        BChannelMember[] result = new BChannelMember[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public void clearEntries() {
        this.removeAll(null);
    }

    public Property addMember(BChannelMember entry, Context cx) {
        return this.add("cm?", (BValue)entry, cx);
    }

    public void removeMember(BChannelMember entry, Context cx) {
        SlotCursor c = this.getProperties();
        while (c.next(BChannelMember.class)) {
            BChannelMember mem = (BChannelMember)c.get();
            if (!mem.equals((Object)entry)) continue;
            this.remove(mem.getPropertyInParent(), cx);
            break;
        }
    }

    public BChannelMember findEntry(InetAddress ip, int port) {
        return this.findEntry(BIpAddress.make(ip), port);
    }

    public BChannelMember findEntry(BIpAddress ip, int port) {
        SlotCursor c = this.getProperties();
        while (c.next(BChannelMember.class)) {
            BChannelMember e = (BChannelMember)c.get();
            if (!e.getIpUcAddress().equals((Object)ip) && !e.getNatIpAddress().equals((Object)ip) || port != 0 && e.getIpUcPort() != port) continue;
            return e;
        }
        return null;
    }

    public BChannelMember findSegmentMember(BIpAddress ip, int port, BChannelMember refMem) {
        SlotCursor c = this.getProperties();
        while (c.next(BChannelMember.class)) {
            BChannelMember e = (BChannelMember)c.get();
            if (!e.getSegmentIp(refMem).equals((Object)ip) || port != 0 && e.getIpUcPort() != port) continue;
            return e;
        }
        return null;
    }

    public boolean hasDuplicateSegmentIp(BIpAddress ip, BIpLonNetworkConfig netCfg) {
        boolean found = false;
        SlotCursor c = this.getProperties();
        while (c.next(BChannelMember.class)) {
            BChannelMember e = (BChannelMember)c.get();
            if (!ip.equals((Object)e.getSegmentIp(netCfg))) continue;
            if (found) {
                return true;
            }
            found = true;
        }
        return false;
    }

    MemberAction memberAction() {
        if (this.ma == null) {
            BLonIpNetwork net = (BLonIpNetwork)NmUtil.getLonNetwork((BComponent)this);
            this.ma = new MemberAction(net, ((BIpLonCommConfig)net.getLonCommConfig()).ipLinkLayer);
        }
        return this.ma;
    }
}

