/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.net.InetAddress;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BIpLonNetworkConfig
extends BComponent {
    private static String NONE = Lexicon.make((String)"lonIp").getText("adapter.none");
    private static String[] noAdapterArray = new String[]{NONE};
    private static int[] noneOrdinals = new int[]{-1};
    public static final Property isConfigServer = BIpLonNetworkConfig.newProperty((int)0, (boolean)true, null);
    public static final Property rcvPort = BIpLonNetworkConfig.newProperty((int)0, (int)1628, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)65535)));
    public static final Property configServerIp = BIpLonNetworkConfig.newProperty((int)0, (BValue)BIpAddress.DEFAULT, null);
    public static final Property configServerPort = BIpLonNetworkConfig.newProperty((int)0, (int)1629, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)65535)));
    public static final Property netName = BIpLonNetworkConfig.newProperty((int)0, (String)"Niagara", null);
    public static final Property useExtendedNat = BIpLonNetworkConfig.newProperty((int)0, (boolean)false, null);
    public static final Property adapter = BIpLonNetworkConfig.newProperty((int)64, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterArray)), null);
    public static final Property myIpAddress = BIpLonNetworkConfig.newProperty((int)1, (BValue)BIpAddress.DEFAULT, null);
    public static final Property natIpAddress = BIpLonNetworkConfig.newProperty((int)0, (BValue)BIpAddress.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BIpLonNetworkConfig.class);
    private Logger log;

    public boolean getIsConfigServer() {
        return this.getBoolean(isConfigServer);
    }

    public void setIsConfigServer(boolean v) {
        this.setBoolean(isConfigServer, v, null);
    }

    public int getRcvPort() {
        return this.getInt(rcvPort);
    }

    public void setRcvPort(int v) {
        this.setInt(rcvPort, v, null);
    }

    public BIpAddress getConfigServerIp() {
        return (BIpAddress)this.get(configServerIp);
    }

    public void setConfigServerIp(BIpAddress v) {
        this.set(configServerIp, (BValue)v, null);
    }

    public int getConfigServerPort() {
        return this.getInt(configServerPort);
    }

    public void setConfigServerPort(int v) {
        this.setInt(configServerPort, v, null);
    }

    public String getNetName() {
        return this.getString(netName);
    }

    public void setNetName(String v) {
        this.setString(netName, v, null);
    }

    public boolean getUseExtendedNat() {
        return this.getBoolean(useExtendedNat);
    }

    public void setUseExtendedNat(boolean v) {
        this.setBoolean(useExtendedNat, v, null);
    }

    public BEnum getAdapter() {
        return (BEnum)this.get(adapter);
    }

    public void setAdapter(BEnum v) {
        this.set(adapter, (BValue)v, null);
    }

    public BIpAddress getMyIpAddress() {
        return (BIpAddress)this.get(myIpAddress);
    }

    public void setMyIpAddress(BIpAddress v) {
        this.set(myIpAddress, (BValue)v, null);
    }

    public BIpAddress getNatIpAddress() {
        return (BIpAddress)this.get(natIpAddress);
    }

    public void setNatIpAddress(BIpAddress v) {
        this.set(natIpAddress, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context c) {
        super.changed(prop, c);
        if (!this.isRunning()) {
            return;
        }
        if (prop == isConfigServer) {
            this.setFlag(c);
        }
        if (c == BMemberTable.internalChange) {
            return;
        }
        if (prop == adapter) {
            this.resetIp();
            this.restart();
        } else if (prop == myIpAddress) {
            this.restart();
        } else {
            ((BComponent)this.getParent()).changed(BIpChannel.networkConfig, c);
        }
    }

    public void started() throws Exception {
        this.log = Logger.getLogger(this.getLonNetwork().getLogName());
        this.setFlag(null);
        this.initAdapter();
    }

    private void setFlag(Context c) {
        int f = this.getFlags((Slot)configServerIp);
        f = this.getIsConfigServer() ? f | 4 : f & 0xFFFFFFFB;
        this.setFlags((Slot)configServerIp, f, c);
    }

    public BIpAddress getSegmentConfigServerIp(BChannelMember cm) {
        BIpAddress myNat = this.getNatIpAddress();
        BIpAddress myIp = this.getMyIpAddress();
        if (myNat.equals((Object)BIpAddress.DEFAULT)) {
            return myIp;
        }
        if (!myNat.equals((Object)cm.getNatIpAddress())) {
            return myNat;
        }
        return myIp;
    }

    public BIpAddress getMyNetworkIp() {
        BIpAddress natIp = this.getNatIpAddress();
        return natIp.equals((Object)BIpAddress.DEFAULT) ? this.getMyIpAddress() : natIp;
    }

    public boolean isLocal(BChannelMember cm) {
        return cm.getIpUcAddress().equals((Object)this.getMyIpAddress()) && cm.getNatIpAddress().equals((Object)this.getNatIpAddress()) && cm.getIpUcPort() == this.getRcvPort();
    }

    private void initAdapter() {
        BTcpIpPlatformService svc = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        svc.lease();
        BDynamicEnum currAdapt = (BDynamicEnum)this.getAdapter();
        BTcpIpHostSettings hostSettings = svc.getSettings();
        Array a = new Array(String.class);
        Array aIp = new Array(String.class);
        SlotCursor c = hostSettings.getAdapters().getProperties();
        while (c.next(BTcpIpAdapterSettings.class)) {
            BTcpIpAdapterSettings as = (BTcpIpAdapterSettings)c.get();
            if (!as.getIsAdapterEnabled()) continue;
            String adptNam = SlotPath.escape((String)as.getDescription());
            a.add((Object)adptNam);
            aIp.add((Object)as.getIpAddress());
        }
        String[] adptDscps = (String[])a.trim();
        String[] adptIps = (String[])aIp.trim();
        boolean rebuild = false;
        BEnumRange origEnmRng = currAdapt.getRange();
        int[] origOds = origEnmRng.getOrdinals();
        if (origOds.length != adptDscps.length) {
            rebuild = true;
        } else {
            for (int i = 0; i < origOds.length; ++i) {
                if (origEnmRng.getTag(origOds[i]).equals(adptDscps[i])) continue;
                rebuild = true;
                break;
            }
        }
        String currIp = this.getMyIpAddress().getInetAddress().getHostAddress();
        int currAdp = 0;
        boolean ipFound = false;
        for (int i = 0; i < adptIps.length; ++i) {
            if (!currIp.equals(adptIps[i])) continue;
            currAdp = i;
            ipFound = true;
            break;
        }
        if (rebuild) {
            this.setAdapter((BEnum)BDynamicEnum.make((int)currAdp, (BEnumRange)BEnumRange.make((String[])adptDscps)));
        }
        if (!ipFound) {
            this.updateMyIp(adptIps[0]);
        }
    }

    private void resetIp() {
        BTcpIpPlatformService svc = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        svc.lease();
        String adpt = this.getAdapter().getTag();
        BTcpIpHostSettings hostSettings = svc.getSettings();
        SlotCursor c = hostSettings.getAdapters().getProperties();
        while (c.next(BTcpIpAdapterSettings.class)) {
            String adptNam;
            BTcpIpAdapterSettings as = (BTcpIpAdapterSettings)c.get();
            if (!as.getIsAdapterEnabled() || !adpt.equals(adptNam = SlotPath.escape((String)as.getDescription()))) continue;
            this.updateMyIp(as.getIpAddress());
            break;
        }
    }

    private void updateMyIp(String ip) {
        try {
            BChannelMember locMem = this.getIpChannel().getMemberTable().findEntry(this.getMyIpAddress(), 0);
            BIpAddress newIp = BIpAddress.make(InetAddress.getByName(ip));
            this.set(myIpAddress, (BValue)newIp, BMemberTable.internalChange);
            if (locMem != null) {
                locMem.setIpUcAddress(newIp);
            }
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
        }
    }

    private void restart() {
        try {
            NLonComm lc = (NLonComm)this.getLonNetwork().lonComm();
            lc.stop();
            lc.start();
            this.log.config("IpLonNetworkConfig myIp address changed");
        }
        catch (Throwable e) {
            this.log.severe(e.getMessage());
        }
    }

    private BLonNetwork getLonNetwork() {
        return (BLonNetwork)this.getParent().getParent();
    }

    private BIpChannel getIpChannel() {
        return (BIpChannel)this.getParent();
    }
}

