/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp;

import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonworks.netmessages.ServicePin;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.LonListener;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonMfgId;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BIpLocalDevice
extends BLocalLonDevice {
    public static final Type TYPE = Sys.loadType(BIpLocalDevice.class);
    private static final BProgramId IpLonProgramId = BProgramId.make((int)9, (BLonMfgId)BLonMfgId.tridium, (int)259, (int)32768, (int)4);

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.updateFaultCause();
        BDeviceData dd = this.getDeviceData();
        if (dd.getNeuronId().equals((Object)BNeuronId.DEFAULT)) {
            dd.setNeuronId(this.createNeuronId());
            dd.setProgramId(IpLonProgramId);
            dd.setNodeState(BLonNodeState.configOnline);
            dd.setSubnetNodeId(BSubnetNode.make((int)1, (int)127));
            dd.setChannelId(1);
        }
        dd.setAddressCount(15);
        this.lonNetwork().addressManager().registerLonDevice((BLonDevice)this);
        this.lonNetwork().lonComm().registerLonListener((LonListener)this.lonNetwork().netMessageReceiver(), 127, null, ServicePin.class);
    }

    private BNeuronId createNeuronId() {
        double rdm = Math.random();
        long lg = Double.doubleToLongBits(rdm);
        byte[] nid = new byte[6];
        for (int i = 0; i < nid.length; ++i) {
            nid[i] = (byte)(lg & 0xFFL);
            lg >>= 8;
        }
        return BNeuronId.make((byte[])nid);
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        AgentInfo[] aia = list.list();
        for (int i = 0; i < aia.length; ++i) {
            if (!aia[i].getAgentType().getTypeName().equals("LocalNvManager")) continue;
            list.remove(i);
        }
        return list;
    }

    public void added(Property prop, Context context) {
    }

    public void removed(Property prop, BValue value, Context context) {
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
    }

    public void renamed(Property prop, String oldName, Context context) {
    }

    public void doPing() {
        this.pingOk();
    }

    public void forceStart() {
    }

    public void deviceDataChanged(Property prop, Context context) {
        if (prop == BDeviceData.neuronId || prop == BDeviceData.subnetNodeId || prop == BDeviceData.channelId || prop == BDeviceData.addressTable) {
            BIpChannel ipChan = (BIpChannel)this.getNetwork().get("ipChannel");
            if (ipChan == null) {
                return;
            }
            BChannelMember locMem = ipChan.getLocalMember();
            if (locMem != null) {
                locMem.updateLocalRoutes(this, true);
            }
        }
    }

    public void updateDomainTable() {
    }

    public void updateNodeState() {
    }

    public void bindComplete() {
        BIpChannel ipChan = (BIpChannel)this.getNetwork().get("ipChannel");
        if (ipChan == null) {
            return;
        }
        BChannelMember locMem = ipChan.getLocalMember();
        if (locMem != null) {
            locMem.updateLocalRoutes(this, true);
        }
    }
}

