/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys.spy;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxSession;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.util.ThrowableUtil;
import java.io.Writer;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;

public class FoxLog {
    static int nextWhoId;
    static final int SERVER = 1;
    static final int ERROR;
    static final int WARNING;
    static final int MESSAGE;
    static final int TRACE;
    static final int OPENED = 10;
    static final int CLOSED = 11;
    static final int REJECTED = 12;
    static DateFormat format;
    static Object lock;
    static final int max;
    static int size;
    static Rec head;
    static Rec tail;
    static HashMap<String, Who> whoHistory;
    Logger log;
    String logName;
    FoxSession session;

    public static FoxLog make(String logName) {
        return new FoxLog(Logger.getLogger(logName));
    }

    private FoxLog(Logger log) {
        this.log = log;
        this.logName = log.getName();
    }

    public Logger log() {
        return this.log;
    }

    public String getLogName() {
        return this.logName;
    }

    public boolean isTraceOn() {
        return this.log.isLoggable(Level.FINE);
    }

    public void error(String msg) {
        this.log(ERROR, msg, null);
    }

    public void error(String msg, Throwable ex) {
        this.log(ERROR, msg, ex);
    }

    public void warning(String msg) {
        this.log(WARNING, msg, null);
    }

    public void warning(String msg, Throwable ex) {
        this.log(WARNING, msg, ex);
    }

    public void message(String msg) {
        this.log(MESSAGE, msg, null);
    }

    public void message(String msg, Throwable ex) {
        this.log(MESSAGE, msg, ex);
    }

    public void trace(String msg) {
        this.log(TRACE, msg, null);
    }

    public void trace(String msg, Throwable ex) {
        this.log(TRACE, msg, ex);
    }

    public void log(int severity, String msg, Throwable ex) {
        Level level = this.severityToLevel(severity);
        if (this.log.isLoggable(level)) {
            this.log.log(level, msg, ex);
            FoxLog.add(new Rec(severity, this.session, this.logName, msg, ex));
        }
    }

    public void logRecOnly(int severity, String msg) {
        if (this.log.isLoggable(this.severityToLevel(severity))) {
            FoxLog.add(new Rec(severity, this.session, this.logName, msg, null));
        }
    }

    private Level severityToLevel(int severity) {
        if (severity == ERROR) {
            return Level.SEVERE;
        }
        if (severity == WARNING) {
            return Level.WARNING;
        }
        if (severity == MESSAGE) {
            return Level.INFO;
        }
        if (severity == TRACE) {
            return Level.FINE;
        }
        return Level.ALL;
    }

    public FoxSession session() {
        return this.session;
    }

    public void setSession(FoxSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void opened(FoxSession session) {
        this.session = session;
        String msg = "Opened: " + FoxLog.toString(session);
        if (!FoxLog.stationToStationConnection(session)) {
            this.log.info(msg);
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(msg);
        }
        FoxLog.add(new Rec(10, session, this.logName, msg, null));
        String whoKey = FoxLog.toWho(session);
        Object object = lock;
        synchronized (object) {
            Who who = whoHistory.get(whoKey);
            if (who == null) {
                who = new Who(whoKey);
                whoHistory.put(whoKey, who);
            }
            who.opened(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed(FoxSession session, Throwable ex) {
        String msg;
        int type;
        if (this.session == session) {
            type = 11;
            msg = "Closed: " + FoxLog.toString(session);
        } else {
            type = 12;
            msg = "Rejected: " + FoxLog.toString(session);
        }
        if (!FoxLog.stationToStationConnection(session)) {
            this.log.info(msg);
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(msg);
        }
        FoxLog.add(new Rec(type, session, this.logName, msg, ex));
        String whoKey = FoxLog.toWho(session);
        Object object = lock;
        synchronized (object) {
            Who who = whoHistory.get(whoKey);
            if (who == null) {
                who = new Who(whoKey);
                whoHistory.put(whoKey, who);
            }
            if (type == 11) {
                who.closed(session);
            } else {
                who.rejected(session);
            }
        }
        this.session = null;
    }

    public static String toWho(FoxSession session) {
        if (session == null) {
            return "null";
        }
        try {
            String host;
            FoxMessage hello = session.getRemoteHello();
            if (hello == null) {
                hello = new FoxMessage();
                try {
                    host = session.getSocket().getInetAddress().toString();
                }
                catch (NullPointerException npe) {
                    host = "unknown";
                }
            } else {
                host = hello.getString("hostName", "unknown");
            }
            String app = hello.getString("app.name", "unknown");
            String station = hello.getString("station.name", null);
            String user = hello.getString("user", null);
            StringBuffer s = new StringBuffer();
            s.append(app);
            if (station != null) {
                s.append(" [").append(station).append("]");
            } else if (user != null) {
                s.append(" [").append(user).append("]");
            }
            s.append(" @ ").append(host);
            return s.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "err";
        }
    }

    public static String toString(FoxSession session) {
        if (session == null) {
            return "null";
        }
        StringBuffer s = new StringBuffer();
        s.append(session.getId());
        s.append(session.isServer() ? " <- " : " -> ");
        s.append(session.getRemoteId());
        s.append(" :: ");
        s.append(FoxLog.toWho(session));
        return s.toString();
    }

    static String toTime(long ticks) {
        if (ticks <= 0L) {
            return "null";
        }
        return format.format(new Date(Clock.millis() - Clock.ticks() + ticks));
    }

    static String toAge(long ticks) {
        return BRelTime.toString((long)(Clock.ticks() - ticks));
    }

    static String toDuration(long ticks) {
        return BRelTime.toString((long)ticks);
    }

    static boolean stationToStationConnection(FoxSession session) {
        try {
            String appName = session.getRemoteHello().getString("app.name", "");
            return appName.equals("Station") && appName.equals(Fox.appName);
        }
        catch (Exception exception) {
            return false;
        }
    }

    static void header(SpyWriter out) {
        out.w((Object)"\n");
        out.w((Object)Fox.appName).w((Object)" ").w((Object)Fox.appVersion);
        if (Sys.getStation() != null) {
            out.w((Object)(" [" + Sys.getStation().getStationName() + "]"));
        }
        out.w((Object)(" | " + FoxLog.toTime(Clock.ticks())));
        out.w((Object)(" | Max Log Size: " + max));
        out.w((Object)" | <a href='/fox/log'>Log Index</a>");
        out.w((Object)(" | <a href='/fox/log/all'>All Records [" + size + "]</a>"));
        out.w((Object)"<hr>\n");
    }

    static Who findWho(int id) {
        for (Who who : whoHistory.values()) {
            if (who.id != id) continue;
            return who;
        }
        return null;
    }

    static Rec findRec(int id) {
        Rec rec = head;
        while (rec != null) {
            if (rec.id == id) {
                return rec;
            }
            rec = rec.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(Rec rec) {
        Object object = lock;
        synchronized (object) {
            while (size >= max) {
                head = FoxLog.head.next;
                --size;
            }
            if (head == null) {
                head = tail = rec;
            } else {
                rec.id = FoxLog.tail.id + 1;
                FoxLog.tail.next = rec;
                tail = rec;
            }
            ++size;
        }
    }

    static String typeToString(int type) {
        if (type == ERROR) {
            return "Sever";
        }
        if (type == WARNING) {
            return "Warning";
        }
        if (type == MESSAGE) {
            return "Info";
        }
        if (type == TRACE) {
            return "Fine";
        }
        switch (type) {
            case 10: {
                return "Opened";
            }
            case 11: {
                return "Closed";
            }
            case 12: {
                return "Rejected";
            }
        }
        return "?" + type + "?";
    }

    static {
        int m;
        nextWhoId = 0;
        ERROR = Level.SEVERE.intValue();
        WARNING = Level.WARNING.intValue();
        MESSAGE = Level.INFO.intValue();
        TRACE = Level.FINE.intValue();
        format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
        lock = new Object();
        try {
            m = AccessController.doPrivileged(() -> {
                Integer logMax = AccessController.doPrivileged(() -> Integer.getInteger("niagara.fox.logMax"));
                if (logMax != null) {
                    return (int)logMax;
                }
                if (PlatformUtil.getPlatformProvider().isEmbedded()) {
                    return 100;
                }
                return 1000;
            });
        }
        catch (Exception e) {
            m = 1000;
            try {
                Logger.getLogger("fox").log(Level.SEVERE, "Error initializing FoxLog max size. Using default max of " + m, e);
            }
            catch (Exception ex) {
                System.out.println("Error initializing FoxLog max size. Using default max of " + m);
                e.printStackTrace();
            }
        }
        max = m;
        whoHistory = new HashMap();
        FoxLog.add(new Rec(MESSAGE, null, "fox", "Booted", null));
    }

    static class Rec
    extends Spy {
        Rec next;
        int id;
        long ticks = Clock.ticks();
        String sessionId;
        int type;
        String logName;
        String msg;
        Throwable ex;

        Rec(int type, FoxSession session, String logName, String msg, Throwable ex) {
            this.type = type;
            this.sessionId = session == null ? "" : session.getId();
            this.logName = logName;
            this.msg = msg;
            this.ex = ex;
        }

        public void write(SpyWriter out) throws Exception {
            FoxLog.header(out);
            out.startProps("Fox Log Record");
            out.prop((Object)"Id", (Object)("" + this.id));
            out.prop((Object)"Time", (Object)FoxLog.toTime(this.ticks));
            out.prop((Object)"Age", (Object)FoxLog.toAge(this.ticks));
            out.prop((Object)"Session", (Object)this.sessionId);
            out.prop((Object)"Type", (Object)FoxLog.typeToString(this.type));
            out.prop((Object)"LogName", (Object)this.logName);
            out.prop((Object)"Message", (Object)this.msg);
            out.endProps();
            if (this.ex != null) {
                out.w((Object)"<pre>");
                ThrowableUtil.dump((Writer)out, (Throwable)this.ex);
                out.w((Object)"</pre>");
            }
        }
    }

    static class Who {
        int id;
        String key;
        String[] sessionIds;
        String[] remoteIds;
        long[] openTicks;
        long[] closeTicks;
        byte[] flags;

        Who(String key) {
            int len = 20;
            this.id = nextWhoId++;
            this.key = key;
            this.sessionIds = new String[20];
            this.remoteIds = new String[20];
            this.openTicks = new long[20];
            this.closeTicks = new long[20];
            this.flags = new byte[20];
            for (int i = 0; i < 20; ++i) {
                this.sessionIds[i] = "";
            }
        }

        void opened(FoxSession session) {
            System.arraycopy(this.sessionIds, 0, this.sessionIds, 1, this.sessionIds.length - 1);
            System.arraycopy(this.remoteIds, 0, this.remoteIds, 1, this.remoteIds.length - 1);
            System.arraycopy(this.openTicks, 0, this.openTicks, 1, this.openTicks.length - 1);
            System.arraycopy(this.closeTicks, 0, this.closeTicks, 1, this.closeTicks.length - 1);
            System.arraycopy(this.flags, 0, this.flags, 1, this.flags.length - 1);
            this.sessionIds[0] = session.getId();
            this.remoteIds[0] = session.getRemoteId();
            this.openTicks[0] = Clock.ticks();
            this.closeTicks[0] = -1L;
            this.flags[0] = session.isServer() ? (byte)1 : 0;
        }

        void closed(FoxSession session) {
            String id = session.getId();
            for (int i = 0; i < this.sessionIds.length; ++i) {
                if (!this.sessionIds[i].equals(id)) continue;
                this.closeTicks[i] = Clock.ticks();
                break;
            }
        }

        void rejected(FoxSession session) {
            this.opened(session);
            this.closeTicks[0] = Long.MAX_VALUE;
        }

        HashMap<String, Object> sessionsToHashMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < this.sessionIds.length; ++i) {
                String id = this.sessionIds[i];
                if (id.isEmpty()) continue;
                map.put(id, this);
            }
            return map;
        }

        public String toString() {
            return this.key;
        }
    }

    static class SpyRecs
    extends SpyDir {
        String title;
        HashMap<String, Object> sessions;

        SpyRecs(String title, HashMap<String, Object> sessions) {
            this.title = title;
            this.sessions = sessions;
        }

        public Spy find(String name) {
            return FoxLog.findRec(Integer.parseInt(name));
        }

        public void write(SpyWriter out) throws Exception {
            FoxLog.header(out);
            out.startTable(true);
            out.trTitle((Object)this.title, 6);
            out.w((Object)"<tr><th>Time</th><th>Age</th><th>Sid</th><th>Log</th><th>Message</th><th>Exception</th></tr>\n");
            Rec rec = head;
            while (rec != null) {
                if (this.include(rec)) {
                    out.w((Object)"<tr");
                    if (rec.type == ERROR) {
                        out.w((Object)" bgcolor='#FFAA26'");
                    } else if (rec.type == WARNING) {
                        out.w((Object)" bgcolor='#FFFF00'");
                    }
                    out.w((Object)">").td().a(String.valueOf(rec.id), (Object)FoxLog.toTime(rec.ticks)).endTd().td((Object)FoxLog.toAge(rec.ticks)).td((Object)("" + rec.sessionId)).td((Object)rec.logName).w((Object)"<td align='left' nowrap='true'>").safe((Object)rec.msg).w((Object)"</td>").td((Object)(rec.ex == null ? "" : rec.ex.toString()));
                    out.w((Object)"</tr>\n");
                }
                rec = rec.next;
            }
            out.endTable();
        }

        boolean include(Rec rec) {
            if (this.sessions == null) {
                return true;
            }
            return this.sessions.get(rec.sessionId) != null;
        }
    }

    static class Index
    extends SpyDir {
        Index() {
        }

        public Spy find(String name) {
            HashMap<String, Object> sessions;
            String title;
            if (name.equals("all")) {
                title = "All Records";
                sessions = null;
            } else if (name.startsWith("byWho-")) {
                Who who = FoxLog.findWho(Integer.parseInt(name.substring(6)));
                title = "Records for " + who.key;
                sessions = who.sessionsToHashMap();
            } else if (name.startsWith("bySession-")) {
                String sessionId = name.substring(10);
                title = "Records for FoxSession " + sessionId;
                sessions = new HashMap();
                sessions.put(sessionId, (Object)this);
            } else {
                throw new IllegalStateException();
            }
            return new SpyRecs(title, sessions);
        }

        public void write(SpyWriter out) throws Exception {
            FoxLog.header(out);
            Object[] who = whoHistory.values().toArray(new Who[whoHistory.size()]);
            SortUtil.sort((Object[])who);
            out.startTable(true);
            out.trTitle((Object)("Log of who has made fox connections [" + who.length + "]"), 4);
            out.w((Object)"<tr><th>Session</th><th>Opened</th><th>Closed</th><th>Duration</th></tr>\n");
            for (int i = 0; i < who.length; ++i) {
                Object w = who[i];
                out.unsafe().trTitle((Object)("<a href='byWho-" + ((Who)w).id + "'>" + w), 4);
                for (int j = ((Who)w).sessionIds.length - 1; j >= 0; --j) {
                    String duration;
                    String closeStr;
                    String id = ((Who)w).sessionIds[j];
                    if (id.isEmpty()) continue;
                    String remoteId = ((Who)w).remoteIds[j];
                    long open = ((Who)w).openTicks[j];
                    long close = ((Who)w).closeTicks[j];
                    boolean isServer = (((Who)w).flags[j] & 1) != 0;
                    String sessionStr = id + (isServer ? " <- " : " -> ") + remoteId;
                    boolean isOpen = false;
                    if (close <= 0L) {
                        closeStr = "Open";
                        duration = FoxLog.toDuration(Clock.ticks() - open);
                        isOpen = true;
                    } else if (close == Long.MAX_VALUE) {
                        closeStr = "Rejected";
                        duration = "-";
                    } else {
                        closeStr = FoxLog.toTime(close);
                        duration = FoxLog.toDuration(close - open);
                    }
                    out.w((Object)"<tr").w((Object)(isOpen ? " bgcolor='#00ff00'" : "")).w((Object)">").td().a("bySession-" + id, (Object)sessionStr).endTd().td((Object)FoxLog.toTime(open)).td((Object)closeStr).td((Object)duration).w((Object)"</tr>\n");
                }
            }
            out.endTable();
        }
    }
}

