/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.LocalizableServerException;
import javax.baja.naming.BHost;
import javax.baja.naming.BStationSessionScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFoxScheme
extends BStationSessionScheme {
    public static final int DEFAULT_PORT = 1911;
    public static final String SCHEME_NAME = "fox";
    public static final BFoxScheme INSTANCE = new BFoxScheme();
    public static final Type TYPE = Sys.loadType(BFoxScheme.class);

    private BFoxScheme() {
        super(SCHEME_NAME);
    }

    public OrdQuery parse(String queryBody) {
        return new FoxQuery(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        return this.resolve(base, query, null);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query, AuthenticationClient client) throws SyntaxException, UnresolvedException {
        BHost host = null;
        BObject obj = base.get();
        host = obj instanceof BHost ? (BHost)obj : ((BComponent)obj).getHost();
        FoxQuery foxQuery = (FoxQuery)query;
        int port = foxQuery.port;
        BFoxSession session = BFoxSession.make(null, host, port, false);
        session.getConnection().setAuthenticationClient(client);
        try {
            session = BFoxSession.connect(session);
            return new OrdTarget(base, (BObject)session);
        }
        catch (LocalizableServerException e) {
            if (e.getLexiconModule().equals(SCHEME_NAME) && e.getLexiconKey().equals("error.NoPermissionForStation")) {
                session.disconnect();
            }
            throw e;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UnresolvedException(query.toString(), e);
        }
    }

    public int getDefaultPort() {
        return 1911;
    }

    public Type getType() {
        return TYPE;
    }

    public static class FoxQuery
    implements OrdQuery {
        int port;

        FoxQuery(String body) {
            body = body.trim();
            this.port = body.length() == 0 ? 1911 : Integer.parseInt(body);
        }

        FoxQuery(int port) {
            this.port = port;
        }

        public boolean isHost() {
            return false;
        }

        public boolean isSession() {
            return true;
        }

        public void normalize(OrdQueryList list, int index) {
            list.shiftToHost(index);
        }

        public String getScheme() {
            return BFoxScheme.SCHEME_NAME;
        }

        public String getBody() {
            StringBuffer sb = new StringBuffer();
            if (this.port != 1911) {
                sb.append(String.valueOf(this.port));
            }
            return sb.toString();
        }

        public String toString() {
            return "fox:" + this.getBody();
        }

        public int getPort() {
            return this.port;
        }
    }
}

