/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.LoginFailureCause;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.FoxsRedirectException;
import com.tridium.fox.sys.Acceptor;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BHost;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BCertificateAliasCredential;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BUsernameCredential;
import javax.baja.security.BUsernameSchemeCredentials;
import javax.baja.security.ReportCauseAuthenticationException;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class BFoxClientConnection
extends BFoxConnection
implements AuthenticationClient {
    public static final Property port = BFoxClientConnection.newProperty((int)0, (int)1911, null);
    public static final Property useFoxs = BFoxClientConnection.newProperty((int)5, (boolean)false, null);
    public static final Property lastFailureTime = BFoxClientConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastFailureCause = BFoxClientConnection.newProperty((int)1, (String)"", null);
    public static final Property retryPeriod = BFoxClientConnection.newProperty((int)0, (BValue)BRelTime.make((long)300000L), null);
    public static final Property nextAttemptTime = BFoxClientConnection.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property credentialStore = BFoxClientConnection.newProperty((int)0, (BValue)new BClientCredentials(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CredentialStoreFE")));
    public static final Action manualConnect = BFoxClientConnection.newAction((int)0, null);
    public static final Action manualDisconnect = BFoxClientConnection.newAction((int)0, null);
    public static final Action lingerTimeout = BFoxClientConnection.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BFoxClientConnection.class);
    public static long engageLinger = 60000L;
    private static CoalesceQueue queue;
    private static final ThreadPoolWorker threadPool;
    private static final Lexicon LEX;
    private BFoxSession foxSession;
    private AuthenticationClient authenticationClient = this;
    private String authenticationScheme;
    private BHost remoteHost;
    private final Object connectLock = new Object();
    private long lastFailureTicks;
    private Exception lastFailureException;
    private final Object retryLock = new Object();
    private final Map<Interest, InterestLogItem> interests = new HashMap<Interest, InterestLogItem>(5);
    private List<InterestLogItem> interestLog = new ArrayList<InterestLogItem>(20);
    private Clock.Ticket lingerTicket;
    private boolean checkBrandCompatibility = true;
    private boolean sslHandshakeComplete = false;
    private SSLSocketFactory socketFactory = null;

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public boolean getUseFoxs() {
        return this.getBoolean(useFoxs);
    }

    public void setUseFoxs(boolean v) {
        this.setBoolean(useFoxs, v, null);
    }

    public BAbsTime getLastFailureTime() {
        return (BAbsTime)this.get(lastFailureTime);
    }

    public void setLastFailureTime(BAbsTime v) {
        this.set(lastFailureTime, (BValue)v, null);
    }

    public String getLastFailureCause() {
        return this.getString(lastFailureCause);
    }

    public void setLastFailureCause(String v) {
        this.setString(lastFailureCause, v, null);
    }

    public BRelTime getRetryPeriod() {
        return (BRelTime)this.get(retryPeriod);
    }

    public void setRetryPeriod(BRelTime v) {
        this.set(retryPeriod, (BValue)v, null);
    }

    public BAbsTime getNextAttemptTime() {
        return (BAbsTime)this.get(nextAttemptTime);
    }

    public void setNextAttemptTime(BAbsTime v) {
        this.set(nextAttemptTime, (BValue)v, null);
    }

    public BClientCredentials getCredentialStore() {
        return (BClientCredentials)this.get(credentialStore);
    }

    public void setCredentialStore(BClientCredentials v) {
        this.set(credentialStore, (BValue)v, null);
    }

    public void manualConnect() {
        this.invoke(manualConnect, null, null);
    }

    public void manualDisconnect() {
        this.invoke(manualDisconnect, null, null);
    }

    public void lingerTimeout() {
        this.invoke(lingerTimeout, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFoxClientConnection(BFoxSession foxSession) {
        this.foxSession = foxSession;
        this.setRemoteHost(foxSession.getHost());
        this.setPort(foxSession.getPort());
        this.setUseFoxs(foxSession.getUseFoxs());
        this.init();
    }

    public BFoxClientConnection() {
        this.init();
    }

    private void init() {
        if (Sys.getStation() != null) {
            try {
                AccessController.doPrivileged(() -> Nre.getServiceManager()).getService("platCrypto:CertManagerService");
                this.setFlags((Slot)useFoxs, this.getFlags((Slot)useFoxs) & 0xFFFFFFFA);
            }
            catch (Exception e) {
                this.setUseFoxs(false);
                this.setFlags((Slot)useFoxs, this.getFlags((Slot)useFoxs) | 1 | 4);
            }
        } else {
            this.setFlags((Slot)useFoxs, this.getFlags((Slot)useFoxs) & 0xFFFFFFFA);
        }
        this.set(channels, BFoxChannelRegistry.getPrototype().newCopy());
    }

    public String getUsername() {
        return this.getCredentials().getUsername();
    }

    public final BFoxSession getFoxSession() {
        return this.foxSession;
    }

    public final BHost getRemoteHost() {
        Optional<NiagaraStation> station = this.getConnectionTarget(NiagaraStation.class);
        return station.isPresent() ? station.get().getRemoteHost() : this.remoteHost;
    }

    public void setRemoteHost(BHost remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteHost(BHost remoteHost, int port) {
        this.setRemoteHost(remoteHost);
        this.setPort(port);
    }

    public void setCredentials(BIUserCredentials credentials) {
        this.getCredentialStore().setCredentials(credentials);
    }

    public void setSSLSocketFactory(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.socketFactory;
    }

    public BIUserCredentials getCredentials() {
        return this.getCredentialStore().getCredentials();
    }

    public void setAuthenticationClient(AuthenticationClient client) {
        this.authenticationClient = client;
    }

    public AuthenticationClient getAuthenticationClient() {
        return this.authenticationClient;
    }

    public void setAuthenticationScheme(String scheme) {
        this.authenticationScheme = scheme;
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public boolean isSslHandshakeComplete() {
        return this.sslHandshakeComplete;
    }

    @Override
    public void sessionOpened(FoxSession session) {
        if (this.checkBrandCompatibility) {
            Acceptor.accept(session);
        }
        super.sessionOpened(session);
        if (this.foxSession != null) {
            this.foxSession.sessionOpened();
        }
        this.getConnectionTarget(NiagaraStation.class).ifPresent(NiagaraStation::clientOpened);
    }

    @Override
    public void sessionClosed(FoxSession session, Throwable cause) {
        this.sessionClosed(session, cause, null);
    }

    @Override
    public void sessionClosed(FoxSession session, Throwable cause, LoginFailureCause failureCause) {
        super.sessionClosed(session, cause);
        if (this.foxSession != null) {
            this.foxSession.sessionClosed(failureCause);
        }
        this.getConnectionTarget(NiagaraStation.class).ifPresent(NiagaraStation::clientClosed);
    }

    public void connect() throws Exception {
        try {
            AccessController.doPrivileged(new ConnectPrivilegedAction());
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interest[] getInterests() {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            return this.interests.keySet().toArray(new Interest[this.interests.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasInterests() {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            return !this.interests.isEmpty();
        }
    }

    public InterestLogItem[] getInterestLog() {
        InterestLogItem[] active = this.interests.values().toArray(new InterestLogItem[this.interests.size()]);
        InterestLogItem[] historical = this.interestLog.toArray(new InterestLogItem[this.interestLog.size()]);
        InterestLogItem[] total = new InterestLogItem[active.length + historical.length];
        System.arraycopy(active, 0, total, 0, active.length);
        System.arraycopy(historical, 0, total, active.length, historical.length);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEngaged(Interest interest) {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            return this.interests.get(interest) != null;
        }
    }

    public void engageNoRetry(Interest interest) throws Exception {
        this.engageNoRetry(interest, 5000L);
    }

    public void engageNoRetry(Interest interest, long failFastPeriod) throws Exception {
        this.engageNoRetry(interest, failFastPeriod, false);
    }

    public void engageNoRetry(Interest interest, long failFastPeriod, boolean updateState) throws Exception {
        Exception ex = this.lastFailureException;
        if (ex != null && Clock.ticks() - this.lastFailureTicks < failFastPeriod) {
            throw ex;
        }
        try {
            this.engage(interest, false);
        }
        catch (Exception e) {
            if (updateState) {
                this.transition("Waiting for retry...");
                long retryPeriod = this.getRetryPeriod().getMillis();
                this.setNextAttemptTime(BAbsTime.make((long)(Clock.millis() + retryPeriod)));
            }
            throw e;
        }
    }

    public void engageRetry(Interest interest) throws Exception {
        this.engage(interest, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void engage(Interest interest, boolean retry) throws Exception {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            if (this.interests.get(interest) == null) {
                InterestLogItem log = this.logEngaged(interest);
                this.interests.put(interest, log);
            }
            if (this.lingerTicket != null) {
                this.lingerTicket.cancel();
            }
        }
        while (true) {
            try {
                this.connect();
                this.interruptRetries();
                return;
            }
            catch (Exception e) {
                if (!retry) {
                    throw e;
                }
                this.transition("Waiting for retry...");
                long retryPeriod = this.getRetryPeriod().getMillis();
                this.setNextAttemptTime(BAbsTime.make((long)(Clock.millis() + retryPeriod)));
                Object object = this.retryLock;
                synchronized (object) {
                    this.retryLock.wait(retryPeriod);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disengage(Interest interest) {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            int oldSize = this.interests.size();
            if (interest != null) {
                InterestLogItem log = this.interests.get(interest);
                if (log != null) {
                    this.logDisengaged(log);
                }
                this.interests.remove(interest);
            }
            if (oldSize > 0 && this.interests.size() == 0) {
                if (this.isRunning()) {
                    this.lingerTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)engageLinger), (Action)lingerTimeout, null);
                } else {
                    this.close();
                }
            }
        }
        this.sslHandshakeComplete = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptRetries() {
        if (this.retryLock == null) {
            return;
        }
        Object object = this.retryLock;
        synchronized (object) {
            this.retryLock.notifyAll();
        }
    }

    private void transition(String newState) {
        if (this.log.isTraceOn()) {
            this.log.trace(this.getState() + " -> " + newState);
        }
        this.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLingerTimeout() {
        Map<Interest, InterestLogItem> map = this.interests;
        synchronized (map) {
            this.lingerTicket = null;
            if (this.interests.size() == 0) {
                this.close();
            }
        }
    }

    public boolean getCheckBrandCompatibility() {
        return this.checkBrandCompatibility;
    }

    public void setCheckBrandCompatibility(boolean check) {
        this.checkBrandCompatibility = check;
    }

    public final boolean isPasswordResetRequired() {
        FoxMessage remoteWelcome;
        FoxSession session = this.session();
        if (session != null && (remoteWelcome = session.getRemoteWelcome()) != null) {
            return remoteWelcome.getBoolean("forceReset", false);
        }
        return false;
    }

    public void pingOk() {
        this.getConnectionTarget(NiagaraStation.class).ifPresent(NiagaraStation::pingOk);
    }

    public void pingFail(String cause) {
        this.getConnectionTarget(NiagaraStation.class).ifPresent(station -> station.pingFail(cause));
    }

    public void doManualConnect() throws Exception {
        this.connect();
    }

    public void doManualDisconnect() throws Exception {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(lingerTimeout)) {
            try {
                if (!threadPool.isRunning()) {
                    ThreadPoolWorker threadPoolWorker = threadPool;
                    synchronized (threadPoolWorker) {
                        if (!threadPool.isRunning()) {
                            threadPool.start("foxLingerTimeout");
                        }
                    }
                }
                queue.enqueue((Object)new Invocation((BComponent)this, action, argument, cx));
            }
            catch (Exception e) {
                this.log.error("Could not invoke lingerTimeout action on fox client connection " + this.toDebugString(), e);
            }
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop.isFrozen() && (prop.getDefaultFlags() & 1) == 0) {
            this.interruptRetries();
        }
    }

    private InterestLogItem logEngaged(Interest interest) {
        InterestLogItem log = new InterestLogItem();
        log.interest = interest.toString();
        log.startTicks = Clock.ticks();
        return log;
    }

    private void logDisengaged(InterestLogItem log) {
        log.endTicks = Clock.ticks();
        while (this.interestLog.size() >= 20) {
            this.interestLog.remove(0);
        }
        this.interestLog.add(log);
    }

    public static void spyThreadPoolWorker(SpyWriter out) {
        try {
            threadPool.spy(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BUsernameCredential requestUsername(AuthenticationRealm realm) {
        BValue authScheme = this.get("authenticationScheme");
        if (authScheme instanceof BString && !((BString)authScheme).getString().isEmpty()) {
            return new BUsernameSchemeCredentials(this.getCredentials().getUsername(), ((BString)authScheme).getString());
        }
        return new BUsernameCredential(this.getCredentials().getUsername());
    }

    public BICredentials requestInformation(AuthenticationRealm realm, String schemeName, int step, BIObject seedInfo) {
        return this.getCredentials();
    }

    static {
        try {
            engageLinger = Long.parseLong(AccessController.doPrivileged(() -> System.getProperty("niagara.fox.engageLinger", "" + engageLinger)).trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        queue = new CoalesceQueue(1000);
        threadPool = new ThreadPoolWorker((Worker.ITodo)queue);
        threadPool.setMaxThreads(1000);
        LEX = Lexicon.make((String)"fox");
    }

    public static class InterestLogItem {
        public String interest;
        public long startTicks;
        public long endTicks;
    }

    public static class StringInterest
    implements Interest {
        private String string;

        public StringInterest(String s) {
            if (s == null) {
                throw new IllegalArgumentException("interest string is null");
            }
            this.string = s;
        }

        @Override
        public int hashCode() {
            return this.string.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof StringInterest && ((StringInterest)o).string.equals(this.string);
        }

        @Override
        public String toString() {
            return this.string;
        }
    }

    public static interface Interest {
        public int hashCode();

        public boolean equals(Object var1);

        public String toString();
    }

    private class ConnectPrivilegedAction
    implements PrivilegedExceptionAction<Object> {
        private ConnectPrivilegedAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run() throws Exception {
            Optional<NiagaraStation> parent = BFoxClientConnection.this.getConnectionTarget(NiagaraStation.class);
            long startTicks = Clock.ticks();
            Object object = BFoxClientConnection.this.connectLock;
            synchronized (object) {
                if (BFoxClientConnection.this.isConnected()) {
                    return null;
                }
                if (BFoxClientConnection.this.lastFailureTicks > startTicks) {
                    throw BFoxClientConnection.this.lastFailureException;
                }
                String startState = BFoxClientConnection.this.getState();
                FoxSession.IFoxSessionListener[] listeners = FoxSession.createListeners(BFoxClientConnection.this);
                try {
                    if (parent.isPresent() && parent.get().isFatalFault()) {
                        throw new Exception(parent.get().getFaultCause());
                    }
                    BFoxClientConnection.this.transition("Connecting...");
                    BFoxClientConnection.this.setNextAttemptTime(BAbsTime.NULL);
                    BHost remoteHost = BFoxClientConnection.this.getRemoteHost();
                    if (remoteHost == null) {
                        throw new IllegalStateException("Remote host not set");
                    }
                    BIUserCredentials cred = BFoxClientConnection.this.getCredentials();
                    if ((cred.getUsername() == null || cred.getUsername().isEmpty()) && BFoxClientConnection.this.authenticationClient.getPreconnectCredentials().isPresent()) {
                        cred = (BIUserCredentials)BFoxClientConnection.this.authenticationClient.getPreconnectCredentials().get();
                    }
                    Socket socket = null;
                    boolean redirect = false;
                    if (!BFoxClientConnection.this.getUseFoxs()) {
                        try {
                            socket = remoteHost.openSocket(BFoxClientConnection.this.getPort());
                            Fox.open((FoxConnection)BFoxClientConnection.this, socket, (BICredentials)cred, listeners);
                        }
                        catch (FoxsRedirectException fre) {
                            if (BFoxClientConnection.this.foxSession != null) {
                                throw fre;
                            }
                            socket.close();
                            redirect = true;
                            int redirectPort = fre.getPort();
                            BFoxClientConnection.this.setPort(fre.getPort());
                            BFoxClientConnection.this.setUseFoxs(true);
                            BFoxClientConnection.this.log.message("received foxs redirect to port " + redirectPort);
                        }
                    }
                    if (BFoxClientConnection.this.getUseFoxs() || redirect) {
                        try {
                            if (BFoxClientConnection.this.socketFactory == null) {
                                ICryptoManager cryptoFactory = CertManagerFactory.getInstance();
                                ClientTlsParameters tlsParameters = cred instanceof BCertificateAliasCredential ? new ClientTlsParameters(ClientTlsParameters.DEFAULT.getMinTlsProtocol(), ((BCertificateAliasCredential)cred).getCertificateAlias()) : ClientTlsParameters.DEFAULT;
                                SocketFactory fact = cryptoFactory.getClientSocketFactory(tlsParameters);
                                socket = remoteHost.openSocket(BFoxClientConnection.this.getPort(), fact);
                            } else {
                                socket = remoteHost.openSocket(BFoxClientConnection.this.getPort(), (SocketFactory)BFoxClientConnection.this.socketFactory);
                            }
                            if (socket instanceof SSLSocket) {
                                ((SSLSocket)socket).getSession();
                                BFoxClientConnection.this.sslHandshakeComplete = true;
                            }
                            if (BFoxClientConnection.this.foxSession != null) {
                                BFoxClientConnection.this.foxSession.setUseFoxs(true);
                                BFoxClientConnection.this.foxSession.setPort(BFoxClientConnection.this.getPort());
                            }
                            Fox.open((FoxConnection)BFoxClientConnection.this, socket, (BICredentials)cred, listeners);
                        }
                        catch (ServiceNotFoundException x) {
                            throw new IOException("CryptoFactory not found.");
                        }
                    }
                    BFoxClientConnection.this.lastFailureTicks = 0L;
                    BFoxClientConnection.this.lastFailureException = null;
                    BFoxClientConnection.this.setLastFailureTime(BAbsTime.NULL);
                    BFoxClientConnection.this.setLastFailureCause("");
                    if (BFoxClientConnection.this.isPasswordResetRequired()) {
                        BFoxClientConnection.this.pingFail(LEX.getText("ping.fail.passwordResetRequired"));
                    } else {
                        BFoxClientConnection.this.pingOk();
                    }
                    if (BFoxClientConnection.this.foxSession != null) {
                        BFoxClientConnection.this.foxSession.postConnect();
                    }
                }
                catch (FoxsRedirectException fre) {
                    throw fre;
                }
                catch (Exception e) {
                    String cause = e.toString();
                    if (e instanceof FoxAuthenticationException) {
                        FoxAuthenticationException ex = (FoxAuthenticationException)e;
                        cause = "Authentication Failed";
                        if (e instanceof ReportCauseAuthenticationException) {
                            cause = cause + ": " + ((ReportCauseAuthenticationException)e).getCauseMessage();
                        }
                        if (ex.fatal != null) {
                            cause = cause + ": " + ex.fatal;
                        }
                    }
                    BFoxClientConnection.this.transition(startState);
                    BFoxClientConnection.this.lastFailureTicks = Clock.ticks();
                    BFoxClientConnection.this.lastFailureException = e;
                    BFoxClientConnection.this.setLastFailureTime(Clock.time());
                    BFoxClientConnection.this.setLastFailureCause(cause);
                    BFoxClientConnection.this.pingFail(cause);
                    if (listeners != FoxSession.nullListeners) {
                        for (FoxSession.IFoxSessionListener listener : listeners) {
                            listener.connectionAborted(cause, e);
                        }
                    }
                    if (listeners != FoxSession.nullListeners) {
                        for (FoxSession.IFoxSessionListener listener : listeners) {
                            listener.connectionAborted(cause, e);
                        }
                    }
                    BFoxClientConnection.this.sslHandshakeComplete = false;
                    throw e;
                }
            }
            return null;
        }
    }
}

