/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxServer;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.session.IntMap;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxChannelRegistry;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionCircuits {
    static final int THREAD_POOL_SIZE = 2;
    private static final boolean NON_DEFAULT_THREAD_PRIORITIES_DISABLED = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.fox.nonDefaultThreadPrioritiesDisabled"));
    private static final Map<String, Map<String, Integer>> CHANNEL_CMD_TO_THREAD_PRIORITY_MAP = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final FoxSession session;
    private final IntMap circuits = new IntMap();
    private int nextId;
    private final ServiceThread[] threadPool = new ServiceThread[2];
    private int nonPoolServiceCount;

    SessionCircuits(FoxSession session) {
        this.session = session;
        this.nextId = session.isServer() ? 0 : 1;
    }

    synchronized FoxCircuit alloc(String chan, String cmd, FoxMessage meta) {
        int id = this.nextId;
        this.nextId += 2;
        FoxCircuit circuit = new FoxCircuit(id, this.session, chan, cmd, meta);
        this.circuits.put(id, circuit);
        return circuit;
    }

    synchronized void free(FoxCircuit c) {
        this.circuits.remove(c.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill() {
        FoxCircuit[] c = (FoxCircuit[])this.circuits.toArray(new FoxCircuit[this.circuits.size()]);
        for (int i = 0; i < c.length; ++i) {
            try {
                c[i].close();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        ServiceThread[] serviceThreadArray = this.threadPool;
        synchronized (this.threadPool) {
            for (int i = 0; i < this.threadPool.length; ++i) {
                if (this.threadPool[i] == null) continue;
                try {
                    this.threadPool[i].kill();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.threadPool[i] = null;
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    void circuitRequestReceived(FoxFrame frame) throws Exception {
        String command = frame.command;
        if (command == "open") {
            this.processOpen(frame.message);
            return;
        }
        if (command == "stream") {
            this.processStream(frame.message);
            return;
        }
        if (command == "close") {
            this.processClose(frame.message);
            return;
        }
        throw new InvalidCommandException(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processOpen(FoxMessage msg) throws Exception {
        int id = msg.getInt("id");
        String channel = msg.getString("channel").intern();
        String command = msg.getString("command").intern();
        FoxMessage meta = (FoxMessage)msg.getOptional("metadata");
        FoxCircuit circuit = new FoxCircuit(id, this.session, channel, command, meta);
        SessionCircuits sessionCircuits = this;
        synchronized (sessionCircuits) {
            if (this.circuits.get(id) != null) {
                throw new IllegalStateException("Circuit already allocated: " + id);
            }
            this.circuits.put(id, circuit);
        }
        this.runCircuit(circuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStream(FoxMessage msg) throws Exception {
        int id = msg.getInt("id");
        byte[] data = msg.getBlob("data");
        FoxCircuit circuit = null;
        SessionCircuits sessionCircuits = this;
        synchronized (sessionCircuits) {
            circuit = (FoxCircuit)this.circuits.get(id);
        }
        if (circuit != null) {
            circuit.pushIn(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processClose(FoxMessage msg) throws Exception {
        int id = msg.getInt("id");
        FoxCircuit circuit = null;
        SessionCircuits sessionCircuits = this;
        synchronized (sessionCircuits) {
            circuit = (FoxCircuit)this.circuits.get(id);
        }
        if (circuit != null) {
            circuit.close();
        }
    }

    public synchronized String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append("ThreadPool\n");
        for (i = 0; i < this.threadPool.length; ++i) {
            s.append("  pool[").append(i).append("] = ");
            if (this.threadPool[i] == null) {
                s.append("null");
            } else {
                s.append(this.threadPool[i].serviceCount);
            }
            s.append('\n');
        }
        s.append("  nonPoolServiceCount = " + this.nonPoolServiceCount).append('\n');
        s.append("Circuits\n");
        if (this.circuits.size() == 0) {
            s.append("  none\n");
        } else {
            for (i = 0; i < this.circuits.size(); ++i) {
                FoxCircuit c = (FoxCircuit)this.circuits.get(i);
                if (c == null) continue;
                s.append("  ").append(c).append('\n');
            }
        }
        s.append("Non-Default Circuit Command Thread Priorities\n");
        CHANNEL_CMD_TO_THREAD_PRIORITY_MAP.forEach((chan, map) -> map.forEach((cmd, pri) -> s.append("  ").append((String)chan).append(':').append((String)cmd).append(" = ").append(pri).append('\n')));
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCircuit(FoxCircuit circuit) {
        Integer threadPriority = SessionCircuits.getServiceThreadPriorityForCircuit(circuit);
        ServiceThread[] serviceThreadArray = this.threadPool;
        synchronized (this.threadPool) {
            if (threadPriority == null) {
                for (int i = 0; i < this.threadPool.length; ++i) {
                    if (this.threadPool[i] == null) {
                        this.threadPool[i] = new ServiceThread(this.session, "Fox:Circuit:" + this.session.getId() + " (Pooled:" + i + ")", true, null);
                        this.threadPool[i].start();
                    }
                    if (!this.threadPool[i].isAvailable()) continue;
                    this.threadPool[i].runCircuit(circuit);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
            ++this.nonPoolServiceCount;
            StringBuilder threadName = new StringBuilder();
            threadName.append("Fox:Circuit:").append(this.session.getId()).append(" (Non-pooled");
            if (threadPriority != null) {
                threadName.append(", pri:").append(threadPriority);
            }
            threadName.append(')');
            ServiceThread thread = new ServiceThread(this.session, threadName.toString(), false, threadPriority);
            thread.start();
            thread.runCircuit(circuit);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static Integer getServiceThreadPriorityForCircuit(FoxCircuit circuit) {
        if (NON_DEFAULT_THREAD_PRIORITIES_DISABLED) {
            return null;
        }
        Map cmdToThreadPriorityMap = CHANNEL_CMD_TO_THREAD_PRIORITY_MAP.computeIfAbsent(circuit.channel, k -> {
            Map<String, Integer> cmdToThreadPriority = null;
            try {
                BFoxChannel channel = (BFoxChannel)BFoxChannelRegistry.getPrototype().get(circuit.channel);
                if (channel != null) {
                    cmdToThreadPriority = channel.getCircuitCommandThreadPriorities();
                }
            }
            catch (Throwable t) {
                Logger.getLogger("fox").log(Level.WARNING, "Could not initialize circuit command thread priorities for fox channel: " + k, t);
            }
            cmdToThreadPriority = cmdToThreadPriority == null ? Collections.emptyMap() : Collections.unmodifiableMap(cmdToThreadPriority);
            return cmdToThreadPriority;
        });
        Integer threadPriority = (Integer)cmdToThreadPriorityMap.get(circuit.command);
        if (threadPriority != null) {
            if (threadPriority < 0) {
                threadPriority = null;
            } else if (threadPriority < 1) {
                threadPriority = 1;
            } else if (threadPriority > 10) {
                threadPriority = 10;
            }
        }
        return threadPriority;
    }

    static class ServiceThread
    implements Runnable {
        Thread thread;
        boolean isAlive = true;
        boolean pooled;
        FoxCircuit circuit;
        int serviceCount;

        ServiceThread(FoxSession session, String name, boolean pooled, Integer threadPriority) {
            this.thread = session.conn.makeThread(Fox.threadGroup, this, name);
            if (threadPriority != null) {
                this.thread.setPriority(threadPriority);
            }
            this.pooled = pooled;
        }

        public void start() {
            this.thread.start();
        }

        public synchronized void kill() {
            this.isAlive = false;
            this.notify();
        }

        public synchronized boolean isAvailable() {
            return this.circuit == null;
        }

        public synchronized void runCircuit(FoxCircuit circuit) {
            if (this.circuit != null) {
                throw new IllegalStateException();
            }
            this.circuit = circuit;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.isAlive) {
                ServiceThread serviceThread = this;
                synchronized (serviceThread) {
                    while (this.circuit == null) {
                        if (!this.isAlive) {
                            return;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++this.serviceCount;
                try {
                    this.circuit.session().conn().circuitOpened(this.circuit);
                }
                catch (Throwable e) {
                    if (e instanceof IncompatibleVersionException) {
                        FoxServer.log.log(Level.FINE, e.getMessage(), e);
                    } else {
                        e.printStackTrace();
                    }
                }
                finally {
                    this.circuit.close();
                }
                serviceThread = this;
                synchronized (serviceThread) {
                    this.circuit = null;
                    if (!this.pooled) {
                        return;
                    }
                }
            }
        }
    }
}

