/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.authn;

import com.tridium.authn.SessionIdCallback;
import com.tridium.fox.message.FoxMessage;
import com.tridium.session.NiagaraSession;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.authn.AuthenticationUtil;
import javax.baja.fox.authn.BFoxCallbackHandler;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

@NiagaraSlots
public class BFoxSessionIdCallbackHandler
extends BFoxCallbackHandler {
    public static final Type TYPE = Sys.loadType(BFoxSessionIdCallbackHandler.class);
    private String username;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof SessionIdCallback) {
                try {
                    this.session.setState("FoxBasicCallbackHandler receive login");
                    FoxMessage login = this.session.receiveTuning("login");
                    ((SessionIdCallback)callback).setSessionId(login.getString("requestedSessionId"));
                    this.username = login.getString("username");
                    ((SessionIdCallback)callback).setUsername(this.username);
                    ((SessionIdCallback)callback).setSession((NiagaraSession)this.session);
                    continue;
                }
                catch (Exception e) {
                    AuthenticationUtil.debug((Level)Level.SEVERE, (String)"Could not acquire username from NameCallback", (Throwable)e);
                    throw new IOException("Could not acquire username.");
                }
            }
            throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
        }
    }
}

